/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.complexPhrase.ComplexPhraseQueryParser;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.parser.QueryParser;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrQueryParser;
import org.apache.solr.search.SyntaxError;

public class ComplexPhraseQParserPlugin
extends QParserPlugin {
    public static final String NAME = "complexphrase";
    private boolean inOrder = true;

    @Override
    public void init(NamedList<?> args) {
        Object val;
        super.init(args);
        if (args != null && (val = args.get("inOrder")) != null) {
            this.inOrder = StrUtils.parseBool(val.toString());
        }
    }

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        ComplexPhraseQParser qParser = new ComplexPhraseQParser(qstr, localParams, params, req);
        qParser.setInOrder(this.inOrder);
        return qParser;
    }

    static class ComplexPhraseQParser
    extends QParser {
        ComplexPhraseQueryParser lparser;
        boolean inOrder = true;

        public void setInOrder(boolean inOrder) {
            this.inOrder = inOrder;
        }

        public ComplexPhraseQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(qstr, localParams, params, req);
        }

        @Override
        public Query parse() throws SyntaxError {
            String qstr = this.getString();
            String defaultField = this.getParam("df");
            final SolrQueryParserDelegate reverseAwareParser = new SolrQueryParserDelegate(this, defaultField);
            this.lparser = new ComplexPhraseQueryParser(defaultField, this.getReq().getSchema().getQueryAnalyzer()){

                @Override
                protected Query newWildcardQuery(Term t) {
                    try {
                        Query wildcardQuery = reverseAwareParser.getWildcardQuery(t.field(), t.text());
                        this.setRewriteMethod(wildcardQuery);
                        return wildcardQuery;
                    }
                    catch (SyntaxError e) {
                        throw new RuntimeException(e);
                    }
                }

                private Query setRewriteMethod(Query query) {
                    if (query instanceof MultiTermQuery) {
                        ((MultiTermQuery)query).setRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_REWRITE);
                    }
                    return query;
                }

                @Override
                protected Query newRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) {
                    boolean reverse = reverseAwareParser.isRangeShouldBeProtectedFromReverse(field, part1);
                    return super.newRangeQuery(field, reverse ? reverseAwareParser.getLowerBoundForReverse() : part1, part2, startInclusive || reverse, endInclusive);
                }
            };
            this.lparser.setAllowLeadingWildcard(true);
            if (this.localParams != null) {
                this.inOrder = this.localParams.getBool("inOrder", this.inOrder);
            }
            this.lparser.setInOrder(this.inOrder);
            QueryParser.Operator defaultOperator = QueryParsing.parseOP(this.getParam("q.op"));
            if (QueryParser.Operator.AND.equals((Object)defaultOperator)) {
                this.lparser.setDefaultOperator(QueryParser.Operator.AND);
            } else {
                this.lparser.setDefaultOperator(QueryParser.Operator.OR);
            }
            try {
                return this.lparser.parse(qstr);
            }
            catch (ParseException pe) {
                throw new SyntaxError(pe);
            }
        }

        @Override
        public String[] getDefaultHighlightFields() {
            String[] stringArray;
            if (this.lparser == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.lparser.getField();
            }
            return stringArray;
        }

        static final class SolrQueryParserDelegate
        extends SolrQueryParser {
            private SolrQueryParserDelegate(QParser parser, String defaultField) {
                super(parser, defaultField);
            }

            @Override
            protected Query getWildcardQuery(String field, String termStr) throws SyntaxError {
                return super.getWildcardQuery(field, termStr);
            }

            @Override
            protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws SyntaxError {
                return super.getRangeQuery(field, part1, part2, startInclusive, endInclusive);
            }

            @Override
            protected boolean isRangeShouldBeProtectedFromReverse(String field, String part1) {
                return super.isRangeShouldBeProtectedFromReverse(field, part1);
            }

            public String getLowerBoundForReverse() {
                return REVERSE_WILDCARD_LOWER_BOUND;
            }
        }
    }
}

