/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.parser.QueryParser;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.util.SolrPluginUtils;

public class DisMaxQParser
extends QParser {
    private static String IMPOSSIBLE_FIELD_NAME = "\ufffc\ufffc\ufffc";
    protected Map<String, Float> queryFields;
    protected Query parsedUserQuery;
    protected String[] boostParams;
    protected List<Query> boostQueries;
    protected Query altUserQuery;
    private boolean parsed = false;

    public static String parseMinShouldMatch(IndexSchema schema, SolrParams params) {
        QueryParser.Operator op = QueryParsing.parseOP(params.get("q.op"));
        return params.get("mm", op.equals((Object)QueryParser.Operator.AND) ? "100%" : "0%");
    }

    public static Map<String, Float> parseQueryFields(IndexSchema indexSchema, SolrParams solrParams) throws SyntaxError {
        Map<String, Float> queryFields = SolrPluginUtils.parseFieldBoosts(solrParams.getParams("qf"));
        if (queryFields.isEmpty()) {
            String df = solrParams.get("df");
            if (df == null) {
                throw new SyntaxError("Neither qf nor df are present.");
            }
            queryFields.put(df, Float.valueOf(1.0f));
        }
        return queryFields;
    }

    public DisMaxQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() throws SyntaxError {
        this.parsed = true;
        SolrParams solrParams = SolrParams.wrapDefaults(this.localParams, this.params);
        this.queryFields = DisMaxQParser.parseQueryFields(this.req.getSchema(), solrParams);
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        boolean notBlank = this.addMainQuery(query, solrParams);
        if (!notBlank) {
            return null;
        }
        this.addBoostQuery(query, solrParams);
        this.addBoostFunctions(query, solrParams);
        return QueryUtils.build(query, this);
    }

    protected void addBoostFunctions(BooleanQuery.Builder query, SolrParams solrParams) throws SyntaxError {
        String[] boostFuncs = solrParams.getParams("bf");
        if (null != boostFuncs && 0 != boostFuncs.length) {
            for (String boostFunc : boostFuncs) {
                if (null == boostFunc || boostFunc.isEmpty()) continue;
                Map<String, Float> ff = SolrPluginUtils.parseFieldBoosts(boostFunc);
                for (Map.Entry<String, Float> entry : ff.entrySet()) {
                    Query fq = this.subQuery(entry.getKey(), "func").getQuery();
                    Float b = entry.getValue();
                    if (null != b) {
                        fq = new BoostQuery(fq, b.floatValue());
                    }
                    query.add(fq, BooleanClause.Occur.SHOULD);
                }
            }
        }
    }

    protected void addBoostQuery(BooleanQuery.Builder query, SolrParams solrParams) throws SyntaxError {
        block9: {
            this.boostParams = solrParams.getParams("bq");
            this.boostQueries = null;
            if (this.boostParams != null && this.boostParams.length > 0) {
                this.boostQueries = new ArrayList<Query>();
                for (String qs : this.boostParams) {
                    if (qs.trim().length() == 0) continue;
                    Query q = this.subQuery(qs, null).getQuery();
                    this.boostQueries.add(q);
                }
            }
            if (null == this.boostQueries) break block9;
            if (1 == this.boostQueries.size() && 1 == this.boostParams.length) {
                BoostQuery bq;
                Query f = this.boostQueries.get(0);
                while (f instanceof BoostQuery && (bq = (BoostQuery)f).getBoost() == 1.0f) {
                    f = bq.getQuery();
                }
                if (f instanceof BooleanQuery) {
                    for (BooleanClause c : ((BooleanQuery)f).clauses()) {
                        query.add(c);
                    }
                } else {
                    query.add(f, BooleanClause.Occur.SHOULD);
                }
            } else {
                for (Query f : this.boostQueries) {
                    query.add(f, BooleanClause.Occur.SHOULD);
                }
            }
        }
    }

    protected boolean addMainQuery(BooleanQuery.Builder query, SolrParams solrParams) throws SyntaxError {
        Map<String, Float> phraseFields = SolrPluginUtils.parseFieldBoosts(solrParams.getParams("pf"));
        float tiebreaker = solrParams.getFloat("tie", 0.0f);
        SolrPluginUtils.DisjunctionMaxQueryParser up = this.getParser(this.queryFields, "qs", solrParams, tiebreaker);
        SolrPluginUtils.DisjunctionMaxQueryParser pp = this.getParser(phraseFields, "ps", solrParams, tiebreaker);
        this.parsedUserQuery = null;
        String userQuery = this.getString();
        this.altUserQuery = null;
        if (StrUtils.isBlank(userQuery)) {
            this.altUserQuery = this.getAlternateUserQuery(solrParams);
            if (this.altUserQuery == null) {
                return false;
            }
            query.add(this.altUserQuery, BooleanClause.Occur.MUST);
        } else {
            userQuery = SolrPluginUtils.partialEscape(SolrPluginUtils.stripUnbalancedQuotes(userQuery)).toString();
            userQuery = SolrPluginUtils.stripIllegalOperators(userQuery).toString();
            this.parsedUserQuery = this.getUserQuery(userQuery, up, solrParams);
            query.add(this.parsedUserQuery, BooleanClause.Occur.MUST);
            Query phrase = this.getPhraseQuery(userQuery, pp);
            if (null != phrase) {
                query.add(phrase, BooleanClause.Occur.SHOULD);
            }
        }
        return true;
    }

    protected Query getAlternateUserQuery(SolrParams solrParams) throws SyntaxError {
        String altQ = solrParams.get("q.alt");
        if (altQ != null) {
            QParser altQParser = this.subQuery(altQ, null);
            return altQParser.getQuery();
        }
        return null;
    }

    protected Query getPhraseQuery(String userQuery, SolrPluginUtils.DisjunctionMaxQueryParser pp) throws SyntaxError {
        String userPhraseQuery = userQuery.replace("\"", "");
        return pp.parse("\"" + userPhraseQuery + "\"");
    }

    protected Query getUserQuery(String userQuery, SolrPluginUtils.DisjunctionMaxQueryParser up, SolrParams solrParams) throws SyntaxError {
        Query dis;
        String minShouldMatch = DisMaxQParser.parseMinShouldMatch(this.req.getSchema(), solrParams);
        Query query = dis = up.parse(userQuery);
        if (dis instanceof BooleanQuery) {
            BooleanQuery.Builder t = new BooleanQuery.Builder();
            SolrPluginUtils.flattenBooleanQuery(t, (BooleanQuery)dis);
            boolean mmAutoRelax = this.params.getBool("mm.autoRelax", false);
            SolrPluginUtils.setMinShouldMatch(t, minShouldMatch, mmAutoRelax);
            query = QueryUtils.build(t, this);
        }
        return query;
    }

    protected SolrPluginUtils.DisjunctionMaxQueryParser getParser(Map<String, Float> fields, String paramName, SolrParams solrParams, float tiebreaker) {
        int slop = solrParams.getInt(paramName, 0);
        SolrPluginUtils.DisjunctionMaxQueryParser parser = new SolrPluginUtils.DisjunctionMaxQueryParser(this, IMPOSSIBLE_FIELD_NAME);
        parser.addAlias(IMPOSSIBLE_FIELD_NAME, tiebreaker, fields);
        parser.setPhraseSlop(slop);
        parser.setSplitOnWhitespace(true);
        return parser;
    }

    @Override
    public String[] getDefaultHighlightFields() {
        return this.queryFields.keySet().toArray(new String[0]);
    }

    @Override
    public Query getHighlightQuery() throws SyntaxError {
        if (!this.parsed) {
            this.parse();
        }
        return this.parsedUserQuery == null ? this.altUserQuery : this.parsedUserQuery;
    }

    @Override
    public void addDebugInfo(NamedList<Object> debugInfo) {
        super.addDebugInfo(debugInfo);
        debugInfo.add("altquerystring", this.altUserQuery);
        if (null != this.boostQueries) {
            debugInfo.add("boost_queries", this.boostParams);
            debugInfo.add("parsed_boost_queries", QueryParsing.toString(this.boostQueries, this.req.getSchema()));
        }
        debugInfo.add("boostfuncs", this.req.getParams().getParams("bf"));
    }
}

