/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;

public class DocSlice
implements DocList,
Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DocSlice.class) + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
    final int offset;
    final int len;
    final int[] docs;
    final float[] scores;
    final long matches;
    final TotalHits.Relation matchesRelation;
    final float maxScore;
    final long ramBytesUsed;

    public DocSlice(int offset, int len, int[] docs, float[] scores, long matches, float maxScore, TotalHits.Relation matchesRelation) {
        this.offset = offset;
        this.len = len;
        this.docs = docs;
        this.scores = scores;
        this.matches = matches;
        this.maxScore = maxScore;
        this.ramBytesUsed = BASE_RAM_BYTES_USED + (docs == null ? 0L : (long)docs.length << 2) + (scores == null ? 0L : ((long)scores.length << 2) + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER);
        this.matchesRelation = matchesRelation;
    }

    @Override
    public DocList subset(int offset, int len) {
        if (this.offset == offset && this.len == len) {
            return this;
        }
        int requestedEnd = offset + len;
        if (requestedEnd > this.docs.length && this.matches > (long)this.docs.length) {
            return null;
        }
        int realEndDoc = Math.min(requestedEnd, this.docs.length);
        int realLen = Math.max(realEndDoc - offset, 0);
        if (this.offset == offset && this.len == realLen) {
            return this;
        }
        return new DocSlice(offset, realLen, this.docs, this.scores, this.matches, this.maxScore, this.matchesRelation);
    }

    @Override
    public boolean hasScores() {
        return this.scores != null;
    }

    @Override
    public float maxScore() {
        return this.maxScore;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int size() {
        return this.len;
    }

    @Override
    public long matches() {
        return this.matches;
    }

    @Override
    public DocIterator iterator() {
        return new DocIterator(){
            int pos;
            final int end;
            {
                this.pos = DocSlice.this.offset;
                this.end = DocSlice.this.offset + DocSlice.this.len;
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.end;
            }

            @Override
            public Integer next() {
                return this.nextDoc();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The remove  operation is not supported by this Iterator.");
            }

            @Override
            public int nextDoc() {
                return DocSlice.this.docs[this.pos++];
            }

            @Override
            public float score() {
                return DocSlice.this.scores[this.pos - 1];
            }
        };
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    @Override
    public TotalHits.Relation hitCountRelation() {
        return this.matchesRelation;
    }
}

