/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.DoublePredicate;
import java.util.stream.Collectors;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.queries.function.FunctionMatchQuery;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Hash;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;

public class HashQParserPlugin
extends QParserPlugin {
    public static final String NAME = "hash";

    @Override
    public QParser createParser(String query, SolrParams localParams, SolrParams params, SolrQueryRequest request) {
        return new HashQParser(query, localParams, params, request);
    }

    private static class HashPartitionPredicate
    implements DoublePredicate {
        final int workers;
        final int worker;

        private HashPartitionPredicate(int workers, int worker) {
            this.workers = workers;
            this.worker = worker;
        }

        @Override
        public boolean test(double hashAsDouble) {
            return Math.abs((long)hashAsDouble) % (long)this.workers == (long)this.worker;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HashPartitionPredicate)) {
                return false;
            }
            HashPartitionPredicate that = (HashPartitionPredicate)o;
            return this.workers == that.workers && this.worker == that.worker;
        }

        public int hashCode() {
            return Objects.hash(this.workers, this.worker);
        }
    }

    private static class HashCodeValuesSource
    extends LongValuesSource {
        private final String[] fields;

        private HashCodeValuesSource(String[] fields) {
            this.fields = fields;
        }

        @Override
        public LongValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            final LongValues[] resultValues = new LongValues[this.fields.length];
            for (int i = 0; i < this.fields.length; ++i) {
                String field = this.fields[i];
                final NumericDocValues numericDocValues = ctx.reader().getNumericDocValues(field);
                if (numericDocValues != null) {
                    resultValues[i] = new LongValues(){
                        final NumericDocValues values;
                        boolean atDoc;
                        {
                            this.values = numericDocValues;
                            this.atDoc = false;
                        }

                        @Override
                        public boolean advanceExact(int doc) throws IOException {
                            this.atDoc = this.values.advanceExact(doc);
                            return true;
                        }

                        @Override
                        public long longValue() throws IOException {
                            return this.atDoc ? (long)Long.hashCode(this.values.longValue()) : 0L;
                        }
                    };
                    continue;
                }
                final SortedDocValues sortedDocValues = ctx.reader().getSortedDocValues(field);
                if (sortedDocValues != null) {
                    resultValues[i] = new LongValues(){
                        final SortedDocValues values;
                        boolean atDoc;
                        {
                            this.values = sortedDocValues;
                            this.atDoc = false;
                        }

                        @Override
                        public boolean advanceExact(int doc) throws IOException {
                            this.atDoc = this.values.advanceExact(doc);
                            return true;
                        }

                        @Override
                        public long longValue() throws IOException {
                            return this.atDoc ? (long)this.hashCode(this.values.lookupOrd(this.values.ordValue())) : 0L;
                        }

                        private int hashCode(BytesRef bytesRef) {
                            return Hash.murmurhash3_x86_32(bytesRef.bytes, bytesRef.offset, bytesRef.length, 0);
                        }
                    };
                    continue;
                }
                FieldInfo fieldInfo = ctx.reader().getFieldInfos().fieldInfo(field);
                if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't compute hash on field " + field);
                }
                resultValues[i] = LongValuesSource.constant(0L).getValues(ctx, scores);
            }
            if (resultValues.length == 1) {
                return resultValues[0];
            }
            return new LongValues(){
                private long result;

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    this.result = 1L;
                    for (LongValues longValues : resultValues) {
                        boolean present = longValues.advanceExact(doc);
                        this.result = 31L * this.result + (!present ? 0L : longValues.longValue());
                    }
                    return true;
                }

                @Override
                public long longValue() throws IOException {
                    return this.result;
                }
            };
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HashCodeValuesSource)) {
                return false;
            }
            HashCodeValuesSource that = (HashCodeValuesSource)o;
            return Arrays.equals(this.fields, that.fields);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.fields);
        }

        @Override
        public String toString() {
            return Arrays.stream(this.fields).collect(Collectors.joining(",", "hash(", ")"));
        }

        @Override
        public LongValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return this;
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return DocValues.isCacheable(ctx, this.fields);
        }
    }

    private static class HashQParser
    extends QParser {
        public HashQParser(String query, SolrParams localParams, SolrParams params, SolrQueryRequest request) {
            super(query, localParams, params, request);
        }

        @Override
        public Query parse() {
            int workers = this.localParams.getInt("workers", 0);
            if (workers < 2) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "workers needs to be more than 1");
            }
            int worker = this.localParams.getInt("worker", 0);
            String keyParam = this.params.get("partitionKeys");
            String[] keys = keyParam.replace(" ", "").split(",");
            Arrays.stream(keys).forEach(field -> this.req.getSchema().getField((String)field));
            return new FunctionMatchQuery(new HashCodeValuesSource(keys).toDoubleValuesSource(), new HashPartitionPredicate(workers, worker));
        }
    }
}

