/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;

public class MinHashQParser
extends QParser {
    public MinHashQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() throws SyntaxError {
        float similarity = this.localParams.getFloat("sim", 1.0f);
        float expectedTruePositive = this.localParams.getFloat("tp", 1.0f);
        String field = this.localParams.get("field", "min_hash");
        String separator = this.localParams.get("sep", "");
        String analyzerField = this.localParams.get("analyzer_field", field);
        ArrayList<BytesRef> hashes = new ArrayList<BytesRef>();
        if (separator.isEmpty()) {
            try {
                this.getHashesFromTokenStream(analyzerField, hashes);
            }
            catch (Exception e) {
                throw new SyntaxError(e);
            }
        } else {
            this.getHashesFromQueryString(separator, hashes);
        }
        return this.createFingerPrintQuery(field, hashes, similarity, expectedTruePositive);
    }

    private void getHashesFromQueryString(String separator, ArrayList<BytesRef> hashes) {
        Arrays.stream(this.qstr.split(separator)).forEach(s -> hashes.add(new BytesRef((CharSequence)s)));
    }

    private void getHashesFromTokenStream(String analyserField, ArrayList<BytesRef> hashes) throws Exception {
        TokenStream ts = this.getReq().getSchema().getIndexAnalyzer().tokenStream(analyserField, this.qstr);
        TermToBytesRefAttribute termAttribute = ts.getAttribute(TermToBytesRefAttribute.class);
        ts.reset();
        while (ts.incrementToken()) {
            BytesRef term = termAttribute.getBytesRef();
            hashes.add(BytesRef.deepCopyOf(term));
        }
        ts.end();
        ts.close();
    }

    private Query createFingerPrintQuery(String field, List<BytesRef> minhashes, float similarity, float expectedTruePositive) {
        TermQuery tq;
        int bandSize = 1;
        if (expectedTruePositive < 1.0f) {
            bandSize = MinHashQParser.computeBandSize(minhashes.size(), similarity, expectedTruePositive);
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        BooleanQuery.Builder childBuilder = new BooleanQuery.Builder();
        int rowInBand = 0;
        for (BytesRef minHash : minhashes) {
            tq = new TermQuery(new Term(field, minHash));
            if (bandSize == 1) {
                builder.add(new ConstantScoreQuery(tq), BooleanClause.Occur.SHOULD);
                continue;
            }
            childBuilder.add(new ConstantScoreQuery(tq), BooleanClause.Occur.MUST);
            if (++rowInBand != bandSize) continue;
            builder.add(new ConstantScoreQuery(childBuilder.build()), BooleanClause.Occur.SHOULD);
            childBuilder = new BooleanQuery.Builder();
            rowInBand = 0;
        }
        if (childBuilder.build().clauses().size() > 0) {
            for (BytesRef token : minhashes) {
                tq = new TermQuery(new Term(field, token.toString()));
                childBuilder.add(new ConstantScoreQuery(tq), BooleanClause.Occur.MUST);
                if (++rowInBand != bandSize) continue;
                builder.add(new ConstantScoreQuery(childBuilder.build()), BooleanClause.Occur.SHOULD);
                break;
            }
        }
        if ((double)expectedTruePositive >= 1.0 && similarity < 1.0f) {
            builder.setMinimumNumberShouldMatch((int)Math.ceil((float)minhashes.size() * similarity));
        }
        return builder.build();
    }

    static int computeBandSize(int numHash, double similarity, double expectedTruePositive) {
        for (int bands = 1; bands <= numHash; ++bands) {
            int rowsInBand = numHash / bands;
            double truePositive = 1.0 - Math.pow(1.0 - Math.pow(similarity, rowsInBand), bands);
            if (!(truePositive > expectedTruePositive)) continue;
            return rowsInBand;
        }
        return 1;
    }
}

