/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntFunction;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetFieldProcessorByArray;
import org.apache.solr.search.facet.FieldUtil;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.SweepCountAware;
import org.apache.solr.search.facet.SweepDISI;
import org.apache.solr.uninverting.FieldCacheImpl;

class FacetFieldProcessorByArrayDV
extends FacetFieldProcessorByArray {
    static boolean unwrap_singleValued_multiDv = true;
    boolean multiValuedField;
    SortedSetDocValues si;
    OrdinalMap ordinalMap = null;
    private boolean[] reuseBool;
    private int[][] reuse = new int[12][];

    FacetFieldProcessorByArrayDV(FacetContext fcontext, FacetField freq, SchemaField sf) {
        super(fcontext, freq, sf);
        this.multiValuedField = sf.multiValued() || sf.getType().multiValuedFieldCache();
    }

    @Override
    protected void findStartAndEndOrds() throws IOException {
        if (this.multiValuedField) {
            this.si = FieldUtil.getSortedSetDocValues(this.fcontext.qcontext, this.sf, null);
            if (this.si instanceof MultiDocValues.MultiSortedSetDocValues) {
                this.ordinalMap = ((MultiDocValues.MultiSortedSetDocValues)this.si).mapping;
            }
        } else {
            SortedDocValues single = FieldUtil.getSortedDocValues(this.fcontext.qcontext, this.sf, null);
            this.si = DocValues.singleton(single);
            if (single instanceof MultiDocValues.MultiSortedDocValues) {
                this.ordinalMap = ((MultiDocValues.MultiSortedDocValues)single).mapping;
            }
        }
        if (this.si.getValueCount() >= Integer.MAX_VALUE) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Field has too many unique values. field=" + this.sf + " nterms= " + this.si.getValueCount());
        }
        if (this.prefixRef != null) {
            this.startTermIndex = (int)this.si.lookupTerm(this.prefixRef.get());
            if (this.startTermIndex < 0) {
                this.startTermIndex = -this.startTermIndex - 1;
            }
            this.prefixRef.append(UnicodeUtil.BIG_TERM);
            this.endTermIndex = (int)this.si.lookupTerm(this.prefixRef.get());
            assert (this.endTermIndex < 0);
            this.endTermIndex = -this.endTermIndex - 1;
        } else {
            this.startTermIndex = 0;
            this.endTermIndex = (int)this.si.getValueCount();
        }
        this.nTerms = this.endTermIndex - this.startTermIndex;
    }

    @Override
    protected void collectDocs() throws IOException {
        boolean accumSeg;
        int domainSize = this.fcontext.base.size();
        if (this.nTerms <= 0 || domainSize < this.effectiveMincount) {
            return;
        }
        SlotAcc.SweepCountAccStruct base = SlotAcc.SweepingCountSlotAcc.baseStructOf(this);
        List<SlotAcc.SweepCountAccStruct> others = SlotAcc.SweepingCountSlotAcc.otherStructsOf(this);
        assert (null != base);
        boolean countOnly = this.collectAcc == null && this.allBucketsAcc == null;
        boolean fullRange = this.startTermIndex == 0 && (long)this.endTermIndex == this.si.getValueCount();
        long domainMultiplier = this.multiValuedField ? 4L : 2L;
        boolean manyHitsPerBucket = (long)domainSize * domainMultiplier > this.si.getValueCount() + 3L;
        boolean canDoPerSeg = countOnly && fullRange;
        boolean bl = accumSeg = manyHitsPerBucket && canDoPerSeg;
        if (((FacetField)this.freq).perSeg != null) {
            accumSeg = canDoPerSeg && ((FacetField)this.freq).perSeg != false;
        }
        int maxSize = others.size() + 1;
        List<LeafReaderContext> leaves = this.fcontext.searcher.getIndexReader().leaves();
        DocIdSetIterator[] subIterators = new DocIdSetIterator[maxSize];
        SlotAcc.CountSlotAcc[] activeCountAccs = new SlotAcc.CountSlotAcc[maxSize];
        for (int subIdx = 0; subIdx < leaves.size(); ++subIdx) {
            LeafReaderContext subCtx = leaves.get(subIdx);
            this.setNextReaderFirstPhase(subCtx);
            SweepDISI disi = SweepDISI.newInstance(base, others, subIterators, activeCountAccs, subCtx);
            if (disi == null) continue;
            LongValues toGlobal = this.ordinalMap == null ? null : this.ordinalMap.getGlobalOrds(subIdx);
            SortedDocValues singleDv = null;
            SortedSetDocValues multiDv = null;
            if (this.multiValuedField) {
                multiDv = subCtx.reader().getSortedSetDocValues(this.sf.getName());
                if (multiDv == null) {
                    if (countOnly) continue;
                    multiDv = DocValues.emptySortedSet();
                } else if (countOnly && multiDv.getValueCount() < 1L) continue;
                if (unwrap_singleValued_multiDv) {
                    singleDv = DocValues.unwrapSingleton(multiDv);
                }
            } else {
                singleDv = subCtx.reader().getSortedDocValues(this.sf.getName());
                if (singleDv == null) {
                    if (countOnly) continue;
                    singleDv = DocValues.emptySorted();
                } else if (countOnly && singleDv.getValueCount() < 1) continue;
            }
            if (singleDv != null) {
                if (accumSeg) {
                    this.collectPerSeg(singleDv, disi, toGlobal);
                    continue;
                }
                if (canDoPerSeg && toGlobal != null) {
                    this.collectCounts(singleDv, disi, toGlobal);
                    continue;
                }
                this.collectDocs(singleDv, disi, toGlobal);
                continue;
            }
            if (accumSeg) {
                this.collectPerSeg(multiDv, disi, toGlobal);
                continue;
            }
            if (canDoPerSeg && toGlobal != null) {
                this.collectCounts(multiDv, disi, toGlobal);
                continue;
            }
            this.collectDocs(multiDv, disi, toGlobal);
        }
        Arrays.fill((Object[])this.reuse, null);
    }

    @Override
    protected BytesRef lookupOrd(int ord) throws IOException {
        return this.si.lookupOrd(ord);
    }

    private void collectPerSeg(SortedDocValues singleDv, SweepDISI disi, LongValues toGlobal) throws IOException {
        int segMax = singleDv.getValueCount();
        SweepCountAware.SegCountPerSeg segCounter = this.getSegCountPerSeg(disi, segMax);
        if (singleDv instanceof FieldCacheImpl.SortedDocValuesImpl.Iter) {
            int doc;
            FieldCacheImpl.SortedDocValuesImpl.Iter fc = (FieldCacheImpl.SortedDocValuesImpl.Iter)singleDv;
            while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
                int segOrd = fc.getOrd(doc);
                if (segOrd < 0) continue;
                int maxIdx = disi.registerCounts(segCounter);
                segCounter.incrementCount(segOrd, 1, maxIdx);
            }
        } else {
            int doc;
            while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
                int segOrd;
                if (!singleDv.advanceExact(doc) || (segOrd = singleDv.ordValue()) < 0) continue;
                int maxIdx = disi.registerCounts(segCounter);
                segCounter.incrementCount(segOrd, 1, maxIdx);
            }
        }
        segCounter.register(disi.countAccs, toGlobal, segMax - 1);
    }

    private SweepCountAware.SegCountPerSeg getSegCountPerSeg(SweepDISI disi, int segMax) {
        int size = disi.size;
        return new SweepCountAware.SegCountPerSeg(this.getSegmentCountArrays(segMax, size), this.getBoolArr(segMax), segMax, size);
    }

    private SweepCountAware.SegCountGlobal getSegCountGlobal(SweepDISI disi, SortedDocValues dv) {
        return new SweepCountAware.SegCountGlobal(disi.countAccs);
    }

    private SweepCountAware.SegCountGlobal getSegCountGlobal(SweepDISI disi, SortedSetDocValues dv) {
        return new SweepCountAware.SegCountGlobal(disi.countAccs);
    }

    private void collectPerSeg(SortedSetDocValues multiDv, SweepDISI disi, LongValues toGlobal) throws IOException {
        int doc;
        int segMax = (int)multiDv.getValueCount();
        SweepCountAware.SegCountPerSeg segCounter = this.getSegCountPerSeg(disi, segMax);
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            int segOrd;
            if (!multiDv.advanceExact(doc)) continue;
            int maxIdx = disi.registerCounts(segCounter);
            while ((segOrd = (int)multiDv.nextOrd()) >= 0) {
                segCounter.incrementCount(segOrd, 1, maxIdx);
            }
        }
        segCounter.register(disi.countAccs, toGlobal, segMax - 1);
    }

    private boolean[] getBoolArr(int maxNeeded) {
        if (this.reuseBool == null) {
            this.reuseBool = new boolean[(int)this.si.getValueCount() + 1];
        } else {
            Arrays.fill(this.reuseBool, 0, maxNeeded, false);
        }
        return this.reuseBool;
    }

    private int[] getCountArr(int maxNeeded, int idx) {
        if (idx >= this.reuse.length) {
            this.reuse = (int[][])Arrays.copyOf(this.reuse, idx + 1);
        }
        if (this.reuse[idx] == null) {
            this.reuse[idx] = new int[(int)this.si.getValueCount() + 1];
        } else {
            Arrays.fill(this.reuse[idx], 0, maxNeeded, 0);
        }
        return this.reuse[idx];
    }

    private int[][] getSegmentCountArrays(int segMax, int size) {
        int[][] ret = new int[size][];
        int i = size - 1;
        do {
            ret[i] = this.getCountArr(segMax, i);
        } while (i-- > 0);
        return ret;
    }

    private void collectDocs(SortedDocValues singleDv, SweepDISI disi, LongValues toGlobal) throws IOException {
        int doc;
        SweepCountAware.SegCountGlobal segCounter = this.getSegCountGlobal(disi, singleDv);
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            if (!singleDv.advanceExact(doc)) continue;
            int maxIdx = disi.registerCounts(segCounter);
            int segOrd = singleDv.ordValue();
            this.collect(doc, segOrd, toGlobal, segCounter, maxIdx, disi.collectBase());
        }
    }

    private void collectCounts(SortedDocValues singleDv, SweepDISI disi, LongValues toGlobal) throws IOException {
        SweepCountAware.SegCountGlobal segCounter = this.getSegCountGlobal(disi, singleDv);
        if (singleDv instanceof FieldCacheImpl.SortedDocValuesImpl.Iter) {
            int doc;
            FieldCacheImpl.SortedDocValuesImpl.Iter fc = (FieldCacheImpl.SortedDocValuesImpl.Iter)singleDv;
            while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
                int segOrd = fc.getOrd(doc);
                if (segOrd < 0) continue;
                int ord = (int)toGlobal.get(segOrd);
                int maxIdx = disi.registerCounts(segCounter);
                segCounter.incrementCount(ord, 1, maxIdx);
            }
        } else {
            int doc;
            while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
                if (!singleDv.advanceExact(doc)) continue;
                int segOrd = singleDv.ordValue();
                int ord = (int)toGlobal.get(segOrd);
                int maxIdx = disi.registerCounts(segCounter);
                segCounter.incrementCount(ord, 1, maxIdx);
            }
        }
    }

    private void collectDocs(SortedSetDocValues multiDv, SweepDISI disi, LongValues toGlobal) throws IOException {
        int doc;
        SweepCountAware.SegCountGlobal segCounter = this.getSegCountGlobal(disi, multiDv);
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            int segOrd;
            if (!multiDv.advanceExact(doc)) continue;
            int maxIdx = disi.registerCounts(segCounter);
            boolean collectBase = disi.collectBase();
            while ((segOrd = (int)multiDv.nextOrd()) >= 0) {
                this.collect(doc, segOrd, toGlobal, segCounter, maxIdx, collectBase);
            }
        }
    }

    private void collectCounts(SortedSetDocValues multiDv, SweepDISI disi, LongValues toGlobal) throws IOException {
        int doc;
        SweepCountAware.SegCountGlobal segCounter = this.getSegCountGlobal(disi, multiDv);
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            int segOrd;
            if (!multiDv.advanceExact(doc)) continue;
            int maxIdx = disi.registerCounts(segCounter);
            while ((segOrd = (int)multiDv.nextOrd()) >= 0) {
                int ord = (int)toGlobal.get(segOrd);
                segCounter.incrementCount(ord, 1, maxIdx);
            }
        }
    }

    private void collect(int doc, int segOrd, LongValues toGlobal, SweepCountAware.SegCountGlobal segCounter, int maxIdx, boolean collectBase) throws IOException {
        int ord = toGlobal != null && segOrd >= 0 ? (int)toGlobal.get(segOrd) : segOrd;
        int arrIdx = ord - this.startTermIndex;
        if (arrIdx >= 0 && arrIdx < this.nTerms) {
            segCounter.incrementCount(arrIdx, 1, maxIdx);
            if (collectBase) {
                if (this.collectAcc != null) {
                    this.collectAcc.collect(doc, arrIdx, (IntFunction<SlotAcc.SlotContext>)this.slotContext);
                }
                if (this.allBucketsAcc != null) {
                    this.allBucketsAcc.collect(doc, arrIdx, (IntFunction<SlotAcc.SlotContext>)this.slotContext);
                }
            }
        }
    }
}

