/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryContext;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.uninverting.FieldCacheImpl;

public class FieldUtil {
    public static SortedDocValues getSortedDocValues(SolrIndexSearcher searcher, String field) throws IOException {
        SchemaField sf = searcher.getSchema().getField(field);
        QueryContext qContext = QueryContext.newContext(searcher);
        return FieldUtil.getSortedDocValues(qContext, sf, null);
    }

    public static SortedDocValues getSortedDocValues(QueryContext context, SchemaField field, QParser qparser) throws IOException {
        SortedDocValues si = context.searcher().getSlowAtomicReader().getSortedDocValues(field.getName());
        return si == null ? DocValues.emptySorted() : si;
    }

    public static SortedSetDocValues getSortedSetDocValues(QueryContext context, SchemaField field, QParser qparser) throws IOException {
        SortedSetDocValues si = context.searcher().getSlowAtomicReader().getSortedSetDocValues(field.getName());
        return si == null ? DocValues.emptySortedSet() : si;
    }

    public static NumericDocValues getNumericDocValues(QueryContext context, SchemaField field, QParser qparser) throws IOException {
        SolrIndexSearcher searcher = context.searcher();
        NumericDocValues si = searcher.getSlowAtomicReader().getNumericDocValues(field.getName());
        return si == null ? DocValues.emptyNumeric() : si;
    }

    public static boolean isFieldCache(SortedDocValues singleDv) {
        return singleDv instanceof FieldCacheImpl.SortedDocValuesImpl.Iter;
    }

    public static void visitOrds(SortedDocValues singleDv, DocIdSetIterator disi, OrdFunc ordFunc) throws IOException {
        if (singleDv instanceof FieldCacheImpl.SortedDocValuesImpl.Iter) {
            int doc;
            FieldCacheImpl.SortedDocValuesImpl.Iter fc = (FieldCacheImpl.SortedDocValuesImpl.Iter)singleDv;
            while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
                ordFunc.handleOrd(doc, fc.getOrd(doc));
            }
        } else {
            int doc;
            while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
                if (!singleDv.advanceExact(doc)) continue;
                ordFunc.handleOrd(doc, singleDv.ordValue());
            }
        }
    }

    public static OrdValues getOrdValues(SortedDocValues singleDv, DocIdSetIterator disi) {
        if (singleDv instanceof FieldCacheImpl.SortedDocValuesImpl.Iter) {
            FieldCacheImpl.SortedDocValuesImpl.Iter fc = (FieldCacheImpl.SortedDocValuesImpl.Iter)singleDv;
            return new FCOrdValues(fc, disi);
        }
        return new DVOrdValues(singleDv, disi);
    }

    public static class DVOrdValues
    extends OrdValues {
        SortedDocValues vals;
        DocIdSetIterator disi;
        int valDoc;

        public DVOrdValues(SortedDocValues vals, DocIdSetIterator disi) {
            this.vals = vals;
            this.disi = disi;
        }

        @Override
        public int nextDoc() throws IOException {
            boolean match;
            do {
                this.doc = this.disi.nextDoc();
                if (this.doc != Integer.MAX_VALUE) continue;
                return Integer.MAX_VALUE;
            } while (!(match = this.vals.advanceExact(this.doc)));
            this.ord = this.vals.ordValue();
            return this.doc;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return false;
        }

        @Override
        public int ordValue() {
            return 0;
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            return null;
        }
    }

    public static class FCOrdValues
    extends OrdValues {
        FieldCacheImpl.SortedDocValuesImpl.Iter vals;
        DocIdSetIterator disi;

        public FCOrdValues(FieldCacheImpl.SortedDocValuesImpl.Iter iter, DocIdSetIterator disi) {
            this.vals = iter;
            this.disi = disi;
        }

        @Override
        public int nextDoc() throws IOException {
            this.doc = this.disi.nextDoc();
            if (this.doc == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            this.ord = this.vals.getOrd(this.doc);
            return this.doc;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return false;
        }

        @Override
        public int ordValue() {
            return 0;
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            return null;
        }
    }

    public static abstract class OrdValues
    extends SortedDocValues {
        int doc;
        int ord;

        public int getOrd() {
            return this.ord;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public abstract int nextDoc() throws IOException;

        @Override
        public int advance(int target) throws IOException {
            return 0;
        }

        @Override
        public long cost() {
            return 0L;
        }

        @Override
        public int getValueCount() {
            throw new UnsupportedOperationException();
        }
    }

    @FunctionalInterface
    public static interface OrdFunc {
        public void handleOrd(int var1, int var2);
    }
}

