/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import org.apache.lucene.util.PriorityQueue;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.facet.SweepCountAware;
import org.apache.solr.search.facet.SweepDocIterator;

final class UnionDocIterator
extends SweepDocIterator {
    private final int maxIdx = this.size - 1;
    private final SubIterStruct baseSub;
    private boolean collectBase;
    private final PriorityQueue<SubIterStruct> queue = new PriorityQueue<SubIterStruct>(this.size){

        @Override
        protected boolean lessThan(SubIterStruct a, SubIterStruct b) {
            return a.docId < b.docId;
        }
    };
    private SubIterStruct top;
    private int docId = -1;

    UnionDocIterator(DocIterator[] subIterators, int baseIdx) throws IOException {
        super(subIterators.length);
        SubIterStruct tmpBase = null;
        int i = this.maxIdx;
        do {
            SubIterStruct subIterStruct = new SubIterStruct(subIterators[i], i);
            this.queue.add(subIterStruct);
            if (i != baseIdx) continue;
            tmpBase = subIterStruct;
        } while (i-- > 0);
        this.baseSub = tmpBase;
        this.top = this.queue.top();
    }

    @Override
    public int nextDoc() {
        if (this.top.docId == this.docId) {
            do {
                this.top.nextDoc();
                this.top = this.queue.updateTop();
            } while (this.top.docId == this.docId);
        }
        this.collectBase = false;
        this.docId = this.top.docId;
        return this.docId;
    }

    @Override
    public boolean hasNext() {
        if (this.top.docId == this.docId) {
            do {
                this.top.nextDoc();
                this.top = this.queue.updateTop();
            } while (this.top.docId == this.docId);
        }
        return this.top.docId != Integer.MAX_VALUE;
    }

    @Override
    public boolean collectBase() {
        assert (this.top.docId != this.docId) : "must call registerCounts() before collectBase()";
        return this.collectBase;
    }

    @Override
    public int registerCounts(SweepCountAware.SegCounter segCounts) {
        int i = -1;
        do {
            if (!this.collectBase && this.top == this.baseSub) {
                this.collectBase = true;
            }
            segCounts.map(this.top.index, ++i);
            this.top.nextDoc();
            this.top = this.queue.updateTop();
        } while (this.top.docId == this.docId);
        return i;
    }

    private static final class SubIterStruct {
        private final DocIterator sub;
        private final int index;
        private int docId;

        public SubIterStruct(DocIterator sub, int index) throws IOException {
            this.sub = sub;
            this.index = index;
            this.nextDoc();
        }

        public void nextDoc() {
            this.docId = this.sub.hasNext() ? this.sub.nextDoc() : Integer.MAX_VALUE;
        }
    }
}

