/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.common.util.Hash;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.HLLAgg;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.util.hll.HLL;

abstract class UniqueSlotAcc
extends SlotAcc {
    HLLAgg.HLLFactory factory;
    SchemaField field;
    FixedBitSet[] arr;
    int[] counts;
    int nTerms;

    public UniqueSlotAcc(FacetContext fcontext, SchemaField field, int numSlots, HLLAgg.HLLFactory factory) throws IOException {
        super(fcontext);
        this.factory = factory;
        this.arr = new FixedBitSet[numSlots];
        this.field = field;
    }

    @Override
    public void reset() throws IOException {
        this.counts = null;
        for (FixedBitSet bits : this.arr) {
            if (bits == null) continue;
            bits.clear(0, bits.length());
        }
    }

    @Override
    public Object getValue(int slot) throws IOException {
        if (this.fcontext.isShard()) {
            return this.getShardValue(slot);
        }
        return this.getNonShardValue(slot);
    }

    public long getNonShardValue(int slot) {
        FixedBitSet bs;
        long res = this.counts != null ? (long)this.counts[slot] : ((bs = this.arr[slot]) == null ? 0L : (long)bs.cardinality());
        return res;
    }

    private Object getShardHLL(int slot) throws IOException {
        FixedBitSet ords = this.arr[slot];
        if (ords == null) {
            return HLLAgg.NO_VALUES;
        }
        HLL hll = this.factory.getHLL();
        long maxOrd = ords.length();
        Hash.LongPair hashResult = new Hash.LongPair();
        int ord = -1;
        while ((long)(++ord) < maxOrd && (ord = ords.nextSetBit(ord)) != Integer.MAX_VALUE) {
            BytesRef val = this.lookupOrd(ord);
            Hash.murmurhash3_x64_128(val.bytes, val.offset, val.length, 0, hashResult);
            hll.addRaw(hashResult.val1);
        }
        SimpleOrderedMap<byte[]> map = new SimpleOrderedMap<byte[]>();
        map.add("hll", hll.toBytes());
        return map;
    }

    private Object getShardValue(int slot) throws IOException {
        if (this.factory != null) {
            return this.getShardHLL(slot);
        }
        FixedBitSet ords = this.arr[slot];
        int unique = this.counts != null ? this.counts[slot] : (ords == null ? 0 : ords.cardinality());
        SimpleOrderedMap<Serializable> map = new SimpleOrderedMap<Serializable>();
        map.add("unique", Integer.valueOf(unique));
        map.add("nTerms", Integer.valueOf(this.nTerms));
        int maxExplicit = 100;
        if (unique > 0) {
            ArrayList<Object> lst = new ArrayList<Object>(Math.min(unique, maxExplicit));
            int maxOrd = ords.length();
            if (maxOrd > 0) {
                int ord = 0;
                while (lst.size() < maxExplicit && (ord = ords.nextSetBit(ord)) != Integer.MAX_VALUE) {
                    BytesRef val = this.lookupOrd(ord);
                    Object o = this.field.getType().toObject(this.field, val);
                    lst.add(o);
                    if (++ord < maxOrd) continue;
                    break;
                }
            }
            map.add("vals", lst);
        }
        return map;
    }

    protected abstract BytesRef lookupOrd(int var1) throws IOException;

    public void calcCounts() {
        this.counts = new int[this.arr.length];
        for (int i = 0; i < this.arr.length; ++i) {
            FixedBitSet bs = this.arr[i];
            this.counts[i] = bs == null ? 0 : bs.cardinality();
        }
    }

    @Override
    public int compare(int slotA, int slotB) {
        if (this.counts == null) {
            this.calcCounts();
        }
        return this.counts[slotA] - this.counts[slotB];
    }

    @Override
    public void resize(SlotAcc.Resizer resizer) {
        this.arr = resizer.resize(this.arr, null);
        if (this.counts != null) {
            this.counts = resizer.resize(this.counts, 0);
        }
    }
}

