/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueInt;
import org.apache.solr.common.SolrException;
import org.apache.solr.index.SlowCompositeReaderWrapper;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.NumericHidingLeafReader;
import org.apache.solr.search.SolrIndexSearcher;

public class OrdFieldSource
extends ValueSource {
    protected final String field;
    private static final int hcode = OrdFieldSource.class.hashCode();

    public OrdFieldSource(String field) {
        this.field = field;
    }

    @Override
    public String description() {
        return "ord(" + this.field + ")";
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        LeafReader r;
        final int off = readerContext.docBase;
        Object o = context.get("searcher");
        if (o instanceof SolrIndexSearcher) {
            SolrIndexSearcher is = (SolrIndexSearcher)o;
            SchemaField sf = is.getSchema().getFieldOrNull(this.field);
            if (sf != null && sf.getType().isPointField()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ord() is not supported over Points based field " + this.field);
            }
            if (sf != null && !sf.hasDocValues() && !sf.multiValued() && sf.getType().getNumberType() != null) {
                List<LeafReaderContext> leaves = is.getIndexReader().leaves();
                IndexReader[] hidingLeaves = new LeafReader[leaves.size()];
                int upto = 0;
                for (LeafReaderContext raw : leaves) {
                    hidingLeaves[upto++] = NumericHidingLeafReader.wrap(raw.reader(), this.field);
                }
                r = SlowCompositeReaderWrapper.wrap(new MultiReader(hidingLeaves));
            } else {
                r = ((SolrIndexSearcher)o).getSlowAtomicReader();
            }
        } else {
            IndexReader topReader = ReaderUtil.getTopLevelContext(readerContext).reader();
            r = SlowCompositeReaderWrapper.wrap(topReader);
        }
        final SortedDocValues sindex = SortedSetSelector.wrap(DocValues.getSortedSet(r, this.field), SortedSetSelector.Type.MIN);
        return new IntDocValues(this){
            private int lastDocID;

            private int getOrdForDoc(int docID) throws IOException {
                if (docID < this.lastDocID) {
                    throw new IllegalArgumentException("docs out of order: lastDocID=" + this.lastDocID + " docID=" + docID);
                }
                if (docID > sindex.docID()) {
                    sindex.advance(docID);
                }
                if (docID == sindex.docID()) {
                    return sindex.ordValue();
                }
                return -1;
            }

            private String toTerm(String readableValue) {
                return readableValue;
            }

            @Override
            public int intVal(int doc) throws IOException {
                return this.getOrdForDoc(doc + off);
            }

            @Override
            public int ordVal(int doc) throws IOException {
                return this.getOrdForDoc(doc + off);
            }

            @Override
            public int numOrd() {
                return sindex.getValueCount();
            }

            @Override
            public boolean exists(int doc) throws IOException {
                return this.getOrdForDoc(doc + off) != 0;
            }

            @Override
            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueInt mval = new MutableValueInt();

                    @Override
                    public MutableValue getValue() {
                        return this.mval;
                    }

                    @Override
                    public void fillValue(int doc) throws IOException {
                        this.mval.value = this.getOrdForDoc(doc);
                        this.mval.exists = this.mval.value != 0;
                    }
                };
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof OrdFieldSource && this.field.equals(((OrdFieldSource)o).field);
    }

    @Override
    public int hashCode() {
        return hcode + this.field.hashCode();
    }
}

