/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.command;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueDate;
import org.apache.lucene.util.mutable.MutableValueDouble;
import org.apache.lucene.util.mutable.MutableValueFloat;
import org.apache.lucene.util.mutable.MutableValueInt;
import org.apache.lucene.util.mutable.MutableValueLong;
import org.apache.solr.common.util.Utils;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.SchemaField;

class GroupConverter {
    GroupConverter() {
    }

    static Collection<SearchGroup<BytesRef>> fromMutable(SchemaField field, Collection<SearchGroup<MutableValue>> values) {
        if (values == null) {
            return null;
        }
        FieldType fieldType = field.getType();
        ArrayList<SearchGroup<BytesRef>> result = new ArrayList<SearchGroup<BytesRef>>(values.size());
        for (SearchGroup<MutableValue> original : values) {
            SearchGroup converted = new SearchGroup();
            converted.sortValues = original.sortValues;
            if (((MutableValue)original.groupValue).exists) {
                BytesRefBuilder binary = new BytesRefBuilder();
                fieldType.readableToIndexed(Utils.OBJECT_TO_STRING.apply(((MutableValue)original.groupValue).toObject()), binary);
                converted.groupValue = binary.get();
            } else {
                converted.groupValue = null;
            }
            result.add(converted);
        }
        return result;
    }

    static Collection<SearchGroup<MutableValue>> toMutable(SchemaField field, Collection<SearchGroup<BytesRef>> values) {
        FieldType fieldType = field.getType();
        ArrayList<SearchGroup<MutableValue>> result = new ArrayList<SearchGroup<MutableValue>>(values.size());
        for (SearchGroup<BytesRef> original : values) {
            MutableValue v;
            SearchGroup converted = new SearchGroup();
            converted.sortValues = original.sortValues;
            NumberType type = fieldType.getNumberType();
            switch (type) {
                case INTEGER: {
                    MutableValueInt mutableInt = new MutableValueInt();
                    if (original.groupValue == null) {
                        mutableInt.value = 0;
                        mutableInt.exists = false;
                    } else {
                        mutableInt.value = (Integer)fieldType.toObject(field, (BytesRef)original.groupValue);
                    }
                    v = mutableInt;
                    break;
                }
                case FLOAT: {
                    MutableValueFloat mutableFloat = new MutableValueFloat();
                    if (original.groupValue == null) {
                        mutableFloat.value = 0.0f;
                        mutableFloat.exists = false;
                    } else {
                        mutableFloat.value = ((Float)fieldType.toObject(field, (BytesRef)original.groupValue)).floatValue();
                    }
                    v = mutableFloat;
                    break;
                }
                case DOUBLE: {
                    MutableValueDouble mutableDouble = new MutableValueDouble();
                    if (original.groupValue == null) {
                        mutableDouble.value = 0.0;
                        mutableDouble.exists = false;
                    } else {
                        mutableDouble.value = (Double)fieldType.toObject(field, (BytesRef)original.groupValue);
                    }
                    v = mutableDouble;
                    break;
                }
                case LONG: {
                    MutableValueLong mutableLong = new MutableValueLong();
                    if (original.groupValue == null) {
                        mutableLong.value = 0L;
                        mutableLong.exists = false;
                    } else {
                        mutableLong.value = (Long)fieldType.toObject(field, (BytesRef)original.groupValue);
                    }
                    v = mutableLong;
                    break;
                }
                case DATE: {
                    MutableValueDate mutableDate = new MutableValueDate();
                    if (original.groupValue == null) {
                        mutableDate.value = 0L;
                        mutableDate.exists = false;
                    } else {
                        mutableDate.value = ((Date)fieldType.toObject(field, (BytesRef)original.groupValue)).getTime();
                    }
                    v = mutableDate;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            converted.groupValue = v;
            result.add(converted);
        }
        return result;
    }

    static TopGroups<BytesRef> fromMutable(SchemaField field, TopGroups<MutableValue> values) {
        if (values == null) {
            return null;
        }
        FieldType fieldType = field.getType();
        GroupDocs[] groupDocs = (GroupDocs[])Array.newInstance(GroupDocs.class, values.groups.length);
        for (int i = 0; i < values.groups.length; ++i) {
            BytesRef groupValue;
            GroupDocs original = values.groups[i];
            if (((MutableValue)original.groupValue).exists) {
                BytesRefBuilder binary = new BytesRefBuilder();
                fieldType.readableToIndexed(Utils.OBJECT_TO_STRING.apply(((MutableValue)original.groupValue).toObject()), binary);
                groupValue = binary.get();
            } else {
                groupValue = null;
            }
            groupDocs[i] = new GroupDocs<BytesRef>(original.score, original.maxScore, original.totalHits, original.scoreDocs, groupValue, original.groupSortValues);
        }
        return new TopGroups<BytesRef>(values.groupSort, values.withinGroupSort, values.totalHitCount, values.totalGroupedHitCount, groupDocs, values.maxScore);
    }
}

