/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.command;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.TermGroupSelector;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.search.grouping.TopGroupsCollector;
import org.apache.lucene.search.grouping.ValueSourceGroupSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.grouping.Command;
import org.apache.solr.search.grouping.distributed.command.GroupConverter;

public class TopGroupsFieldCommand
implements Command<TopGroups<BytesRef>> {
    private final Query query;
    private final SchemaField field;
    private final Sort groupSort;
    private final Sort withinGroupSort;
    private final Collection<SearchGroup<BytesRef>> firstPhaseGroups;
    private final int maxDocPerGroup;
    private final boolean needScores;
    private final boolean needMaxScore;
    private TopGroupsCollector<?> secondPassCollector;
    private TopGroups<BytesRef> topGroups;

    private TopGroupsFieldCommand(Query query, SchemaField field, Sort groupSort, Sort withinGroupSort, Collection<SearchGroup<BytesRef>> firstPhaseGroups, int maxDocPerGroup, boolean needScores, boolean needMaxScore) {
        this.query = query;
        this.field = field;
        this.groupSort = groupSort;
        this.withinGroupSort = withinGroupSort;
        this.firstPhaseGroups = firstPhaseGroups;
        this.maxDocPerGroup = maxDocPerGroup;
        this.needScores = needScores;
        this.needMaxScore = needMaxScore;
    }

    @Override
    public List<Collector> create() throws IOException {
        if (this.firstPhaseGroups.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Collector> collectors = new ArrayList<Collector>(1);
        FieldType fieldType = this.field.getType();
        if (fieldType.getNumberType() != null) {
            ValueSource vs = fieldType.getValueSource(this.field, null);
            Collection v = GroupConverter.toMutable(this.field, this.firstPhaseGroups);
            this.secondPassCollector = new TopGroupsCollector<MutableValue>(new ValueSourceGroupSelector(vs, new HashMap<Object, Object>()), v, this.groupSort, this.withinGroupSort, this.maxDocPerGroup, this.needMaxScore);
        } else {
            this.secondPassCollector = new TopGroupsCollector<BytesRef>(new TermGroupSelector(this.field.getName()), this.firstPhaseGroups, this.groupSort, this.withinGroupSort, this.maxDocPerGroup, this.needMaxScore);
        }
        collectors.add(this.secondPassCollector);
        return collectors;
    }

    @Override
    public void postCollect(IndexSearcher searcher) throws IOException {
        if (this.firstPhaseGroups.isEmpty()) {
            GroupDocs[] groups = (GroupDocs[])Array.newInstance(GroupDocs.class, 0);
            this.topGroups = new TopGroups(this.groupSort.getSort(), this.withinGroupSort.getSort(), 0, 0, groups, Float.NaN);
            return;
        }
        FieldType fieldType = this.field.getType();
        TopGroups<MutableValue> tg = this.secondPassCollector.getTopGroups(0);
        this.topGroups = fieldType.getNumberType() != null ? GroupConverter.fromMutable(this.field, tg) : tg;
        if (this.needScores) {
            for (GroupDocs group : this.topGroups.groups) {
                TopFieldCollector.populateScores(group.scoreDocs, searcher, this.query);
            }
        }
    }

    @Override
    public TopGroups<BytesRef> result() throws IOException {
        return this.topGroups;
    }

    @Override
    public String getKey() {
        return this.field.getName();
    }

    @Override
    public Sort getGroupSort() {
        return this.groupSort;
    }

    @Override
    public Sort getWithinGroupSort() {
        return this.withinGroupSort;
    }

    public static class Builder {
        private Query query;
        private SchemaField field;
        private Sort groupSort;
        private Sort withinGroupSort;
        private Collection<SearchGroup<BytesRef>> firstPhaseGroups;
        private Integer maxDocPerGroup;
        private boolean needScores = false;
        private boolean needMaxScore = false;

        public Builder setQuery(Query query) {
            this.query = query;
            return this;
        }

        public Builder setField(SchemaField field) {
            this.field = field;
            return this;
        }

        public Builder setGroupSort(Sort groupSort) {
            this.groupSort = groupSort;
            return this;
        }

        public Builder setSortWithinGroup(Sort withinGroupSort) {
            this.withinGroupSort = withinGroupSort;
            return this;
        }

        public Builder setFirstPhaseGroups(Collection<SearchGroup<BytesRef>> firstPhaseGroups) {
            this.firstPhaseGroups = firstPhaseGroups;
            return this;
        }

        public Builder setMaxDocPerGroup(int maxDocPerGroup) {
            this.maxDocPerGroup = maxDocPerGroup;
            return this;
        }

        public Builder setNeedScores(Boolean needScores) {
            this.needScores = needScores;
            return this;
        }

        public Builder setNeedMaxScore(Boolean needMaxScore) {
            this.needMaxScore = needMaxScore;
            return this;
        }

        public TopGroupsFieldCommand build() {
            if (this.query == null || this.field == null || this.groupSort == null || this.withinGroupSort == null || this.firstPhaseGroups == null || this.maxDocPerGroup == null) {
                throw new IllegalStateException("All required fields must be set");
            }
            return new TopGroupsFieldCommand(this.query, this.field, this.groupSort, this.withinGroupSort, this.firstPhaseGroups, this.maxDocPerGroup, this.needScores, this.needMaxScore);
        }
    }
}

