/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.join.GraphEdgeCollector;
import org.apache.solr.util.LongIterator;
import org.apache.solr.util.LongSet;

public class GraphPointsCollector
extends GraphEdgeCollector {
    final LongSet set = new LongSet(256);
    SortedNumericDocValues values = null;

    public GraphPointsCollector(SchemaField collectField, DocSet skipSet, DocSet leafNodes) {
        super(collectField, skipSet, leafNodes);
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        super.doSetNextReader(context);
        this.values = DocValues.getSortedNumeric(context.reader(), this.collectField.getName());
    }

    @Override
    void addEdgeIdsToResult(int doc) throws IOException {
        int valuesDoc = this.values.docID();
        if (valuesDoc < doc) {
            valuesDoc = this.values.advance(doc);
        }
        if (valuesDoc == doc) {
            int count = this.values.docValueCount();
            for (int i = 0; i < count; ++i) {
                long v = this.values.nextValue();
                this.set.add(v);
            }
        }
    }

    @Override
    public Query getResultQuery(SchemaField matchField, boolean useAutomaton) {
        if (this.set.cardinality() == 0) {
            return null;
        }
        Query q = null;
        NumberType ntype = this.collectField.getType().getNumberType();
        boolean multiValued = this.collectField.multiValued();
        if (ntype == NumberType.LONG || ntype == NumberType.DATE) {
            long[] vals = new long[this.set.cardinality()];
            int i = 0;
            LongIterator iter = this.set.iterator();
            while (iter.hasNext()) {
                long bits;
                long v = bits = iter.next();
                vals[i++] = v;
            }
            q = LongPoint.newSetQuery(matchField.getName(), vals);
        } else if (ntype == NumberType.INTEGER) {
            int[] vals = new int[this.set.cardinality()];
            int i = 0;
            LongIterator iter = this.set.iterator();
            while (iter.hasNext()) {
                long bits = iter.next();
                int v = (int)bits;
                vals[i++] = v;
            }
            q = IntPoint.newSetQuery(matchField.getName(), vals);
        } else if (ntype == NumberType.DOUBLE) {
            double[] vals = new double[this.set.cardinality()];
            int i = 0;
            LongIterator iter = this.set.iterator();
            while (iter.hasNext()) {
                long bits = iter.next();
                double v = multiValued ? NumericUtils.sortableLongToDouble(bits) : Double.longBitsToDouble(bits);
                vals[i++] = v;
            }
            q = DoublePoint.newSetQuery(matchField.getName(), vals);
        } else if (ntype == NumberType.FLOAT) {
            float[] vals = new float[this.set.cardinality()];
            int i = 0;
            LongIterator iter = this.set.iterator();
            while (iter.hasNext()) {
                long bits = iter.next();
                float v = multiValued ? NumericUtils.sortableIntToFloat((int)bits) : Float.intBitsToFloat((int)bits);
                vals[i++] = v;
            }
            q = FloatPoint.newSetQuery(matchField.getName(), vals);
        }
        return q;
    }
}

