/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.admin.SecurityConfHandler;
import org.apache.solr.security.Permission;

enum AutorizationEditOperation {
    SET_USER_ROLE("set-user-role"){

        @Override
        public Map<String, Object> edit(Map<String, Object> latestConf, CommandOperation op) {
            Map<String, Object> roleMap = SecurityConfHandler.getMapValue(latestConf, "user-role");
            Map<String, Object> map = op.getDataMap();
            if (op.hasError()) {
                return null;
            }
            for (Map.Entry<String, Object> e : map.entrySet()) {
                if (e.getValue() == null) {
                    roleMap.remove(e.getKey());
                    continue;
                }
                if (e.getValue() instanceof String || e.getValue() instanceof List) {
                    roleMap.put(e.getKey(), e.getValue());
                    continue;
                }
                op.addError("Unexpected value ");
                return null;
            }
            return latestConf;
        }
    }
    ,
    SET_PERMISSION("set-permission"){

        @Override
        public Map<String, Object> edit(Map<String, Object> latestConf, CommandOperation op) {
            Integer index = op.getInt(AutorizationEditOperation.INDEX, null);
            Integer beforeIdx = op.getInt(AutorizationEditOperation.BEFORE, null);
            Map dataMap = op.getDataMap();
            if (op.hasError()) {
                return null;
            }
            dataMap = Utils.getDeepCopy(dataMap, 3);
            dataMap.remove(AutorizationEditOperation.BEFORE);
            if (beforeIdx != null && index != null) {
                op.addError("Cannot use 'index' and 'before together ");
                return null;
            }
            for (String key : dataMap.keySet()) {
                if (Permission.knownKeys.contains(key)) continue;
                op.addError("Unknown key, " + key);
            }
            try {
                Permission.load(dataMap);
            }
            catch (Exception e) {
                op.addError(e.getMessage());
                return null;
            }
            if (op.hasError()) {
                return null;
            }
            List<Map<String, Object>> permissions = AutorizationEditOperation.ensureIndexOnPermissions(latestConf);
            ArrayList<Map<String, Object>> permissionsCopy = new ArrayList<Map<String, Object>>();
            boolean beforeSatisfied = beforeIdx == null;
            boolean indexSatisfied = index == null;
            for (Map<String, Object> perm : permissions) {
                Integer thisIdx = 2.getIndex(perm);
                if (thisIdx.equals(beforeIdx)) {
                    beforeSatisfied = true;
                    permissionsCopy.add(dataMap);
                    permissionsCopy.add(perm);
                    continue;
                }
                if (thisIdx.equals(index)) {
                    indexSatisfied = true;
                    permissionsCopy.add(dataMap);
                    continue;
                }
                permissionsCopy.add(perm);
            }
            if (!beforeSatisfied) {
                op.addError("Invalid 'before' :" + beforeIdx);
                return null;
            }
            if (!indexSatisfied) {
                op.addError("Invalid 'index' :" + index);
                return null;
            }
            if (!permissionsCopy.contains(dataMap)) {
                permissionsCopy.add(dataMap);
            }
            2.setIndex(permissionsCopy);
            latestConf.put(AutorizationEditOperation.PERMISSIONS, permissionsCopy);
            return latestConf;
        }
    }
    ,
    UPDATE_PERMISSION("update-permission"){

        @Override
        public Map<String, Object> edit(Map<String, Object> latestConf, CommandOperation op) {
            Integer index = op.getInt(AutorizationEditOperation.INDEX);
            if (op.hasError()) {
                return null;
            }
            List<Map<String, Object>> permissions = AutorizationEditOperation.ensureIndexOnPermissions(latestConf);
            for (Map<String, Object> permission : permissions) {
                if (!index.equals(3.getIndex(permission))) continue;
                LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(permission);
                copy.putAll(op.getDataMap());
                op.setCommandData(copy);
                latestConf.put(AutorizationEditOperation.PERMISSIONS, permissions);
                return SET_PERMISSION.edit(latestConf, op);
            }
            op.addError("No such permission " + this.name);
            return null;
        }
    }
    ,
    DELETE_PERMISSION("delete-permission"){

        @Override
        public Map<String, Object> edit(Map<String, Object> latestConf, CommandOperation op) {
            Integer id = op.getInt("");
            if (op.hasError()) {
                return null;
            }
            List<Map<String, Object>> p = AutorizationEditOperation.ensureIndexOnPermissions(latestConf);
            if (p.stream().anyMatch(map -> id.equals(4.getIndex(map)))) {
                List<Map<String, Object>> c = p.stream().filter(map -> !id.equals(4.getIndex(map))).collect(Collectors.toList());
                4.setIndex(c);
                latestConf.put(AutorizationEditOperation.PERMISSIONS, c);
                return latestConf;
            }
            op.addError("No such index: " + id);
            return null;
        }
    };

    private static final String PERMISSIONS = "permissions";
    private static final String INDEX = "index";
    private static final String BEFORE = "before";
    public final String name;

    private AutorizationEditOperation(String s) {
        this.name = s;
    }

    public static AutorizationEditOperation get(String name) {
        for (AutorizationEditOperation o : AutorizationEditOperation.values()) {
            if (!o.name.equals(name)) continue;
            return o;
        }
        return null;
    }

    static void setIndex(List<Map<String, Object>> permissionsCopy) {
        AtomicInteger counter = new AtomicInteger(0);
        permissionsCopy.forEach(map -> map.put(INDEX, counter.incrementAndGet()));
    }

    static Integer getIndex(Map<String, Object> permission) {
        Object idx = permission.get(INDEX);
        return idx instanceof Number ? ((Number)idx).intValue() : -1;
    }

    private static List<Map<String, Object>> ensureIndexOnPermissions(Map<String, Object> latestConf) {
        List permissions = SecurityConfHandler.getListValue(latestConf, PERMISSIONS);
        if (permissions.stream().noneMatch(map -> map.containsKey(INDEX))) {
            AutorizationEditOperation.setIndex(permissions);
        }
        return permissions;
    }

    public abstract Map<String, Object> edit(Map<String, Object> var1, CommandOperation var2);

    public String getOperationName() {
        return this.name;
    }
}

