/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.solr.api.ApiBag;
import org.apache.solr.client.api.model.ErrorInfo;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;

public class ResponseUtils {
    private static final boolean SYSTEM_HIDE_STACK_TRACES = Boolean.getBoolean("solr.hideStackTrace");

    private ResponseUtils() {
    }

    public static int getErrorInfo(Throwable ex, NamedList<Object> info, Logger log) {
        return ResponseUtils.getErrorInfo(ex, info, log, false);
    }

    public static int getErrorInfo(Throwable ex, NamedList<Object> info, Logger log, boolean hideTrace) {
        int code = 500;
        if (ex instanceof SolrException) {
            SolrException solrExc = (SolrException)ex;
            code = solrExc.code();
            NamedList<String> errorMetadata = solrExc.getMetadata();
            if (errorMetadata == null) {
                errorMetadata = new NamedList();
            }
            errorMetadata.add("error-class", ex.getClass().getName());
            errorMetadata.add("root-error-class", SolrException.getRootCause(ex).getClass().getName());
            info.add("metadata", errorMetadata);
            if (ex instanceof ApiBag.ExceptionWithErrObject) {
                ApiBag.ExceptionWithErrObject exception = (ApiBag.ExceptionWithErrObject)ex;
                info.add("details", exception.getErrs());
            }
        }
        for (Throwable th = ex; th != null; th = th.getCause()) {
            String msg = th.getMessage();
            if (msg == null) continue;
            info.add("msg", msg);
            break;
        }
        if (code == 500 || code < 100) {
            if (!ResponseUtils.hideStackTrace(hideTrace)) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                info.add("trace", sw.toString());
            }
            log.error("500 Exception", ex);
            if (code < 100) {
                log.warn("invalid return code: {}", (Object)code);
                code = 500;
            }
        }
        info.add("code", code);
        return code;
    }

    public static ErrorInfo getTypedErrorInfo(Throwable ex, Logger log) {
        return ResponseUtils.getTypedErrorInfo(ex, log, false);
    }

    public static ErrorInfo getTypedErrorInfo(Throwable ex, Logger log, boolean hideTrace) {
        ErrorInfo errorInfo = new ErrorInfo();
        int code = 500;
        if (ex instanceof SolrException) {
            SolrException solrExc = (SolrException)ex;
            code = solrExc.code();
            errorInfo.metadata = new ErrorInfo.ErrorMetadata();
            errorInfo.metadata.errorClass = ex.getClass().getName();
            errorInfo.metadata.rootErrorClass = SolrException.getRootCause(ex).getClass().getName();
            if (ex instanceof ApiBag.ExceptionWithErrObject) {
                ApiBag.ExceptionWithErrObject exception = (ApiBag.ExceptionWithErrObject)ex;
                errorInfo.details = exception.getErrs();
            }
        }
        for (Throwable th = ex; th != null; th = th.getCause()) {
            String msg = th.getMessage();
            if (msg == null) continue;
            errorInfo.msg = msg;
            break;
        }
        if (code == 500 || code < 100) {
            if (!ResponseUtils.hideStackTrace(hideTrace)) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                errorInfo.trace = sw.toString();
            }
            log.error("500 Exception", ex);
            if (code < 100) {
                log.warn("invalid return code: {}", (Object)code);
                code = 500;
            }
        }
        errorInfo.code = code;
        return errorInfo;
    }

    private static boolean hideStackTrace(boolean hideTrace) {
        return hideTrace || SYSTEM_HIDE_STACK_TRACES;
    }
}

