/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.spelling.Token;

public class SpellingResult {
    private Collection<Token> tokens;
    private Map<Token, LinkedHashMap<String, Integer>> suggestions = new LinkedHashMap<Token, LinkedHashMap<String, Integer>>();
    private Map<Token, Integer> tokenFrequency;
    public static final int NO_FREQUENCY_INFO = -1;

    public SpellingResult() {
    }

    public SpellingResult(Collection<Token> tokens) {
        this.tokens = tokens;
    }

    public void add(Token token, List<String> suggestions) {
        LinkedHashMap<String, Integer> map = this.suggestions.get(token);
        if (map == null) {
            map = new LinkedHashMap();
            this.suggestions.put(token, map);
        }
        for (String suggestion : suggestions) {
            map.put(suggestion, -1);
        }
    }

    public void addFrequency(Token token, int docFreq) {
        if (this.tokenFrequency == null) {
            this.tokenFrequency = new LinkedHashMap<Token, Integer>();
        }
        this.tokenFrequency.put(token, docFreq);
    }

    public void add(Token token, String suggestion, int docFreq) {
        LinkedHashMap<String, Integer> map = this.suggestions.get(token);
        if (map == null) {
            map = new LinkedHashMap();
            this.suggestions.put(token, map);
        }
        map.put(suggestion, docFreq);
    }

    public LinkedHashMap<String, Integer> get(Token token) {
        return this.suggestions.get(token);
    }

    public Integer getTokenFrequency(Token token) {
        return this.tokenFrequency.get(token);
    }

    public boolean hasTokenFrequencyInfo() {
        return this.tokenFrequency != null && !this.tokenFrequency.isEmpty();
    }

    public Map<Token, LinkedHashMap<String, Integer>> getSuggestions() {
        return this.suggestions;
    }

    public Map<Token, Integer> getTokenFrequency() {
        return this.tokenFrequency;
    }

    public Collection<Token> getTokens() {
        return this.tokens;
    }

    public void setTokens(Collection<Token> tokens) {
        this.tokens = tokens;
    }
}

