/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spell.CombineSuggestion;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.WordBreakSpellChecker;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.ResultEntry;
import org.apache.solr.spelling.SolrSpellChecker;
import org.apache.solr.spelling.SpellingOptions;
import org.apache.solr.spelling.SpellingResult;
import org.apache.solr.spelling.Token;

public class WordBreakSolrSpellChecker
extends SolrSpellChecker {
    public static final String PARAM_COMBINE_WORDS = "combineWords";
    public static final String PARAM_BREAK_WORDS = "breakWords";
    public static final String PARAM_MAX_CHANGES = "maxChanges";
    public static final String PARAM_MAX_COMBINE_WORD_LENGTH = "maxCombinedLength";
    public static final String PARAM_MIN_BREAK_WORD_LENGTH = "minBreakLength";
    public static final String PARAM_BREAK_SUGGESTION_TIE_BREAKER = "breakSugestionTieBreaker";
    public static final String PARAM_MAX_EVALUATIONS = "maxEvaluations";
    public static final String PARAM_MIN_SUGGESTION_FREQUENCY = "minSuggestionFreq";
    private WordBreakSpellChecker wbsp = null;
    private boolean combineWords = false;
    private boolean breakWords = false;
    private WordBreakSpellChecker.BreakSuggestionSortMethod sortMethod = WordBreakSpellChecker.BreakSuggestionSortMethod.NUM_CHANGES_THEN_MAX_FREQUENCY;
    private static final Pattern spacePattern = Pattern.compile("\\s+");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String init(NamedList<?> config, SolrCore core) {
        int msf;
        int me;
        int mbwl;
        int mcl;
        String name = super.init(config, core);
        this.combineWords = this.boolParam(config, PARAM_COMBINE_WORDS);
        this.breakWords = this.boolParam(config, PARAM_BREAK_WORDS);
        this.wbsp = new WordBreakSpellChecker();
        String bstb = this.strParam(config, PARAM_BREAK_SUGGESTION_TIE_BREAKER);
        if (bstb != null) {
            if ((bstb = bstb.toUpperCase(Locale.ROOT)).equals(BreakSuggestionTieBreaker.SUM_FREQ.name())) {
                this.sortMethod = WordBreakSpellChecker.BreakSuggestionSortMethod.NUM_CHANGES_THEN_SUMMED_FREQUENCY;
            } else {
                if (!bstb.equals(BreakSuggestionTieBreaker.MAX_FREQ.name())) throw new IllegalArgumentException("Invalid value for parameter breakSugestionTieBreaker : " + bstb);
                this.sortMethod = WordBreakSpellChecker.BreakSuggestionSortMethod.NUM_CHANGES_THEN_MAX_FREQUENCY;
            }
        } else {
            this.sortMethod = WordBreakSpellChecker.BreakSuggestionSortMethod.NUM_CHANGES_THEN_MAX_FREQUENCY;
        }
        int mc = this.intParam(config, PARAM_MAX_CHANGES);
        if (mc > 0) {
            this.wbsp.setMaxChanges(mc);
        }
        if ((mcl = this.intParam(config, PARAM_MAX_COMBINE_WORD_LENGTH)) > 0) {
            this.wbsp.setMaxCombineWordLength(mcl);
        }
        if ((mbwl = this.intParam(config, PARAM_MIN_BREAK_WORD_LENGTH)) > 0) {
            this.wbsp.setMinBreakWordLength(mbwl);
        }
        if ((me = this.intParam(config, PARAM_MAX_EVALUATIONS)) > 0) {
            this.wbsp.setMaxEvaluations(me);
        }
        if ((msf = this.intParam(config, PARAM_MIN_SUGGESTION_FREQUENCY)) <= 0) return name;
        this.wbsp.setMinSuggestionFrequency(msf);
        return name;
    }

    private String strParam(NamedList<?> config, String paramName) {
        Object o = config.get(paramName);
        return o == null ? null : o.toString();
    }

    private boolean boolParam(NamedList<?> config, String paramName) {
        String s = this.strParam(config, paramName);
        return "true".equalsIgnoreCase(s) || "on".equalsIgnoreCase(s);
    }

    private int intParam(NamedList<?> config, String paramName) {
        Object o = config.get(paramName);
        if (o == null) {
            return 0;
        }
        try {
            return Integer.parseInt(o.toString());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid integer for parameter " + paramName + " : " + o);
        }
    }

    @Override
    public SpellingResult getSuggestions(SpellingOptions options) throws IOException {
        IndexReader ir = options.reader;
        int numSuggestions = options.count;
        StringBuilder sb = new StringBuilder();
        Token[] tokenArr = options.tokens.toArray(new Token[0]);
        ArrayList<Token> tokenArrWithSeparators = new ArrayList<Token>(options.tokens.size() + 2);
        ArrayList<Term> termArr = new ArrayList<Term>(options.tokens.size() + 2);
        ArrayList<ResultEntry> breakSuggestionList = new ArrayList<ResultEntry>();
        ArrayList<ResultEntry> noBreakSuggestionList = new ArrayList<ResultEntry>();
        boolean lastOneProhibited = false;
        boolean lastOneRequired = false;
        int lastOneprocedesNewBooleanOp = 0;
        for (int i = 0; i < tokenArr.length; ++i) {
            int procedesNewBooleanOp;
            boolean prohibited = (tokenArr[i].getFlags() & 0x4000) == 16384;
            boolean required = (tokenArr[i].getFlags() & 0x8000) == 32768;
            int n = procedesNewBooleanOp = (tokenArr[i].getFlags() & 0x10000) == 65536 ? 1 : 0;
            if (i > 0 && (prohibited != lastOneProhibited || required != lastOneRequired || lastOneprocedesNewBooleanOp != 0)) {
                termArr.add(WordBreakSpellChecker.SEPARATOR_TERM);
                tokenArrWithSeparators.add(null);
            }
            lastOneProhibited = prohibited;
            lastOneRequired = required;
            lastOneprocedesNewBooleanOp = procedesNewBooleanOp;
            Term thisTerm = new Term(this.field, tokenArr[i].toString());
            termArr.add(thisTerm);
            tokenArrWithSeparators.add(tokenArr[i]);
            if (!this.breakWords) continue;
            SuggestWord[][] breakSuggestions = this.wbsp.suggestWordBreaks(thisTerm, numSuggestions, ir, options.suggestMode, this.sortMethod);
            if (breakSuggestions.length == 0) {
                noBreakSuggestionList.add(new ResultEntry(tokenArr[i], null, 0));
            }
            for (SuggestWord[] breakSuggestion : breakSuggestions) {
                sb.delete(0, sb.length());
                boolean firstOne = true;
                int freq = 0;
                for (SuggestWord word : breakSuggestion) {
                    if (!firstOne) {
                        sb.append(" ");
                    }
                    firstOne = false;
                    sb.append(word.string);
                    if (this.sortMethod == WordBreakSpellChecker.BreakSuggestionSortMethod.NUM_CHANGES_THEN_MAX_FREQUENCY) {
                        freq = Math.max(freq, word.freq);
                        continue;
                    }
                    freq += word.freq;
                }
                breakSuggestionList.add(new ResultEntry(tokenArr[i], sb.toString(), freq));
            }
        }
        breakSuggestionList.addAll(noBreakSuggestionList);
        List combineSuggestionList = Collections.emptyList();
        CombineSuggestion[] combineSuggestions = this.wbsp.suggestWordCombinations(termArr.toArray(new Term[0]), numSuggestions, ir, options.suggestMode);
        if (this.combineWords) {
            combineSuggestionList = new ArrayList(combineSuggestions.length);
            for (CombineSuggestion cs : combineSuggestions) {
                int firstTermIndex = cs.originalTermIndexes[0];
                int lastTermIndex = cs.originalTermIndexes[cs.originalTermIndexes.length - 1];
                sb.delete(0, sb.length());
                for (int i = firstTermIndex; i <= lastTermIndex; ++i) {
                    if (i > firstTermIndex) {
                        sb.append(" ");
                    }
                    sb.append(((Token)tokenArrWithSeparators.get(i)).toString());
                }
                Token token = new Token(sb.toString(), ((Token)tokenArrWithSeparators.get(firstTermIndex)).startOffset(), ((Token)tokenArrWithSeparators.get(lastTermIndex)).endOffset());
                combineSuggestionList.add(new ResultEntry(token, cs.suggestion.string, cs.suggestion.freq));
            }
        }
        SpellingResult result = new SpellingResult();
        Iterator breakIter = breakSuggestionList.iterator();
        Iterator combineIter = combineSuggestionList.iterator();
        ResultEntry lastBreak = breakIter.hasNext() ? (ResultEntry)breakIter.next() : null;
        ResultEntry lastCombine = combineIter.hasNext() ? (ResultEntry)combineIter.next() : null;
        int breakCount = 0;
        int combineCount = 0;
        while (lastBreak != null || lastCombine != null) {
            if (lastBreak == null) {
                this.addToResult(result, lastCombine.token, this.getCombineFrequency(ir, lastCombine.token), lastCombine.suggestion, lastCombine.freq);
                lastCombine = null;
            } else if (lastCombine == null) {
                this.addToResult(result, lastBreak.token, ir.docFreq(new Term(this.field, lastBreak.token.toString())), lastBreak.suggestion, lastBreak.freq);
                lastBreak = null;
            } else if (lastBreak.freq < lastCombine.freq) {
                this.addToResult(result, lastCombine.token, this.getCombineFrequency(ir, lastCombine.token), lastCombine.suggestion, lastCombine.freq);
                lastCombine = null;
            } else if (lastCombine.freq < lastBreak.freq) {
                this.addToResult(result, lastBreak.token, ir.docFreq(new Term(this.field, lastBreak.token.toString())), lastBreak.suggestion, lastBreak.freq);
                lastBreak = null;
            } else if (breakCount >= combineCount) {
                this.addToResult(result, lastCombine.token, this.getCombineFrequency(ir, lastCombine.token), lastCombine.suggestion, lastCombine.freq);
                lastCombine = null;
            } else {
                this.addToResult(result, lastBreak.token, ir.docFreq(new Term(this.field, lastBreak.token.toString())), lastBreak.suggestion, lastBreak.freq);
                lastBreak = null;
            }
            if (lastBreak == null && breakIter.hasNext()) {
                lastBreak = (ResultEntry)breakIter.next();
                ++breakCount;
            }
            if (lastCombine != null || !combineIter.hasNext()) continue;
            lastCombine = (ResultEntry)combineIter.next();
            ++combineCount;
        }
        return result;
    }

    private void addToResult(SpellingResult result, Token token, int tokenFrequency, String suggestion, int suggestionFrequency) {
        if (suggestion == null) {
            result.add(token, Collections.emptyList());
            result.addFrequency(token, tokenFrequency);
        } else {
            result.add(token, suggestion, suggestionFrequency);
            result.addFrequency(token, tokenFrequency);
        }
    }

    private int getCombineFrequency(IndexReader ir, Token token) throws IOException {
        String[] words = spacePattern.split(token.toString());
        int result = 0;
        if (this.sortMethod == WordBreakSpellChecker.BreakSuggestionSortMethod.NUM_CHANGES_THEN_MAX_FREQUENCY) {
            for (String word : words) {
                result = Math.max(result, ir.docFreq(new Term(this.field, word)));
            }
        } else {
            for (String word : words) {
                result += ir.docFreq(new Term(this.field, word));
            }
        }
        return result;
    }

    @Override
    public void build(SolrCore core, SolrIndexSearcher searcher) {
    }

    @Override
    public void reload(SolrCore core, SolrIndexSearcher searcher) throws IOException {
    }

    @Override
    public boolean isSuggestionsMayOverlap() {
        return true;
    }

    public static enum BreakSuggestionTieBreaker {
        MAX_FREQ,
        SUM_FREQ;

    }
}

