/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling.suggest;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.Accountable;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.suggest.DictionaryFactory;
import org.apache.solr.spelling.suggest.LookupFactory;
import org.apache.solr.spelling.suggest.SuggesterOptions;
import org.apache.solr.spelling.suggest.SuggesterResult;
import org.apache.solr.update.SolrCoreState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrSuggester
implements Accountable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String DEFAULT_DICT_NAME = "default";
    public static final String LOCATION = "sourceLocation";
    public static final String LOOKUP_IMPL = "lookupImpl";
    public static final String DICTIONARY_IMPL = "dictionaryImpl";
    public static final String STORE_DIR = "storeDir";
    static SuggesterResult EMPTY_RESULT = new SuggesterResult();
    private String sourceLocation;
    private Path storeDir;
    private Dictionary dictionary;
    private Lookup lookup;
    private String lookupImpl;
    private String dictionaryImpl;
    private String name;
    private LookupFactory factory;
    private DictionaryFactory dictionaryFactory;
    private Analyzer contextFilterQueryAnalyzer;

    public String init(NamedList<?> config, SolrCore core) {
        log.info("init: {}", config);
        this.name = config.get("name") != null ? (String)config.get("name") : DEFAULT_DICT_NAME;
        this.sourceLocation = (String)config.get(LOCATION);
        this.lookupImpl = (String)config.get(LOOKUP_IMPL);
        this.dictionaryImpl = (String)config.get(DICTIONARY_IMPL);
        String store = (String)config.get(STORE_DIR);
        if (this.lookupImpl == null) {
            this.lookupImpl = LookupFactory.DEFAULT_FILE_BASED_DICT;
            log.info("No {} parameter was provided falling back to {}", (Object)LOOKUP_IMPL, (Object)this.lookupImpl);
        }
        this.contextFilterQueryAnalyzer = new TokenizerChain(new StandardTokenizerFactory(Collections.emptyMap()), null);
        this.factory = core.getResourceLoader().newInstance(this.lookupImpl, LookupFactory.class);
        this.lookup = this.factory.create(config, core);
        if (this.lookup instanceof Closeable) {
            core.addCloseHook(new CloseHook(){

                @Override
                public void preClose(SolrCore core) {
                    try {
                        ((Closeable)((Object)SolrSuggester.this.lookup)).close();
                    }
                    catch (IOException e) {
                        log.warn("Could not close the suggester lookup.", (Throwable)e);
                    }
                }
            });
        }
        if (store != null && !store.isEmpty()) {
            this.storeDir = Path.of(store, new String[0]);
            this.storeDir = Path.of(core.getDataDir(), new String[0]).resolve(this.storeDir);
            try {
                Files.createDirectories(this.storeDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.warn("Could not create directory {}", (Object)this.storeDir);
            }
            Path storeFile = this.getStoreFile();
            if (Files.exists(storeFile, new LinkOption[0])) {
                log.debug("attempt reload of the stored lookup from file {}", (Object)storeFile);
                try {
                    this.lookup.load(Files.newInputStream(storeFile, new OpenOption[0]));
                }
                catch (IOException e) {
                    log.warn("Loading stored lookup data failed, possibly not cached yet");
                }
            }
        }
        if (this.dictionaryImpl == null) {
            this.dictionaryImpl = this.sourceLocation == null ? DictionaryFactory.DEFAULT_INDEX_BASED_DICT : DictionaryFactory.DEFAULT_FILE_BASED_DICT;
            log.info("No {} parameter was provided falling back to {}", (Object)DICTIONARY_IMPL, (Object)this.dictionaryImpl);
        }
        this.dictionaryFactory = core.getResourceLoader().newInstance(this.dictionaryImpl, DictionaryFactory.class);
        this.dictionaryFactory.setParams(config);
        log.info("Dictionary loaded with params: {}", config);
        return this.name;
    }

    public void build(SolrCore core, SolrIndexSearcher searcher) throws IOException {
        log.info("SolrSuggester.build({})", (Object)this.name);
        this.dictionary = this.dictionaryFactory.create(core, searcher);
        try {
            this.lookup.build(this.dictionary);
        }
        catch (AlreadyClosedException e) {
            SolrCoreState.CoreIsClosedException e2 = new SolrCoreState.CoreIsClosedException("Suggester build has been interrupted by a core reload or shutdown.");
            e2.initCause(e);
            throw e2;
        }
        if (this.storeDir != null) {
            Path target = this.getStoreFile();
            if (!this.lookup.store(Files.newOutputStream(target, new OpenOption[0]))) {
                log.error("Store Lookup build failed");
            } else if (log.isInfoEnabled()) {
                log.info("Stored suggest data to: {}", (Object)target.toAbsolutePath());
            }
        }
    }

    public void reload() throws IOException {
        log.info("SolrSuggester.reload({})", (Object)this.name);
        if (this.dictionary == null && this.storeDir != null) {
            Path lookupFile = this.getStoreFile();
            if (Files.exists(lookupFile, new LinkOption[0])) {
                this.lookup.load(Files.newInputStream(lookupFile, new OpenOption[0]));
            } else {
                log.info("lookup file doesn't exist");
            }
        }
    }

    public Path getStoreFile() {
        if (this.storeDir == null) {
            return null;
        }
        return this.storeDir.resolve(this.factory.storeFileName());
    }

    public SuggesterResult getSuggestions(SuggesterOptions options) throws IOException {
        List<Lookup.LookupResult> suggestions;
        if (log.isDebugEnabled()) {
            log.debug("getSuggestions: {}", (Object)options.token);
        }
        if (this.lookup == null) {
            log.info("Lookup is null - invoke suggest.build first");
            return EMPTY_RESULT;
        }
        SuggesterResult res = new SuggesterResult();
        if (options.contextFilterQuery == null) {
            suggestions = this.lookup.lookup(options.token, false, options.count);
        } else {
            BooleanQuery query = this.parseContextFilterQuery(options.contextFilterQuery);
            suggestions = this.lookup.lookup(options.token, query, options.count, options.allTermsRequired, options.highlight);
            if (suggestions == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Context Filtering Query not supported by {}", this.lookup.getClass());
                }
                suggestions = this.lookup.lookup(options.token, false, options.count);
            }
        }
        res.add(this.getName(), options.token.toString(), suggestions);
        return res;
    }

    private BooleanQuery parseContextFilterQuery(String contextFilter) {
        if (contextFilter == null) {
            return null;
        }
        Query query = null;
        try {
            query = new StandardQueryParser(this.contextFilterQueryAnalyzer).parse(contextFilter, "contexts");
            if (query instanceof BooleanQuery) {
                return (BooleanQuery)query;
            }
            return new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).build();
        }
        catch (QueryNodeException e) {
            throw new IllegalArgumentException("Failed to parse query: " + query);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public long ramBytesUsed() {
        return this.lookup.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return this.lookup.getChildResources();
    }

    public String toString() {
        return "SolrSuggester [ name=" + this.name + ", sourceLocation=" + this.sourceLocation + ", storeDir=" + (Comparable)(this.storeDir == null ? "" : this.storeDir.toAbsolutePath()) + ", lookupImpl=" + this.lookupImpl + ", dictionaryImpl=" + this.dictionaryImpl + ", sizeInBytes=" + (this.lookup != null ? String.valueOf(this.ramBytesUsed()) : "0") + " ]";
    }
}

