/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.uninverting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.StringHelper;

public class DocTermOrds
implements Accountable {
    private static final int TNUM_OFFSET = 2;
    public static final int DEFAULT_INDEX_INTERVAL_BITS = 7;
    private int indexIntervalBits;
    private int indexIntervalMask;
    private int indexInterval;
    protected final int maxTermDocFreq;
    protected final String field;
    protected int numTermsInField;
    protected long termInstances;
    private long memsz;
    protected int total_time;
    protected int phase1_time;
    protected int[] index;
    protected byte[][] tnums = new byte[256][];
    protected long sizeOfIndexedStrings;
    protected BytesRef[] indexedTermsArray = new BytesRef[0];
    protected BytesRef prefix;
    protected int ordBase;
    protected PostingsEnum postingsEnum;
    protected boolean checkForDocValues = true;
    private static final byte[] BLOCK7 = new byte[]{5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1};

    @Override
    public long ramBytesUsed() {
        if (this.memsz != 0L) {
            return this.memsz;
        }
        long sz = 96L;
        if (this.index != null) {
            sz += (long)this.index.length * 4L;
        }
        if (this.tnums != null) {
            for (byte[] arr : this.tnums) {
                if (arr == null) continue;
                sz += (long)arr.length;
            }
        }
        if (this.indexedTermsArray != null) {
            sz += 32L + ((long)this.indexedTermsArray.length << 3) + this.sizeOfIndexedStrings;
        }
        this.memsz = sz;
        return sz;
    }

    public DocTermOrds(LeafReader reader, Bits liveDocs, String field) throws IOException {
        this(reader, liveDocs, field, null, Integer.MAX_VALUE);
    }

    public DocTermOrds(LeafReader reader, Bits liveDocs, String field, BytesRef termPrefix) throws IOException {
        this(reader, liveDocs, field, termPrefix, Integer.MAX_VALUE);
    }

    public DocTermOrds(LeafReader reader, Bits liveDocs, String field, BytesRef termPrefix, int maxTermDocFreq) throws IOException {
        this(reader, liveDocs, field, termPrefix, maxTermDocFreq, 7);
    }

    public DocTermOrds(LeafReader reader, Bits liveDocs, String field, BytesRef termPrefix, int maxTermDocFreq, int indexIntervalBits) throws IOException {
        this(field, maxTermDocFreq, indexIntervalBits);
        this.uninvert(reader, liveDocs, termPrefix);
    }

    protected DocTermOrds(String field, int maxTermDocFreq, int indexIntervalBits) {
        this.field = field;
        this.maxTermDocFreq = maxTermDocFreq;
        this.indexIntervalBits = indexIntervalBits;
        this.indexIntervalMask = -1 >>> 32 - indexIntervalBits;
        this.indexInterval = 1 << indexIntervalBits;
    }

    public TermsEnum getOrdTermsEnum(LeafReader reader) throws IOException {
        assert (null != this.indexedTermsArray);
        if (0 == this.indexedTermsArray.length) {
            return null;
        }
        return new OrdWrappedTermsEnum(reader);
    }

    public int numTerms() {
        return this.numTermsInField;
    }

    public boolean isEmpty() {
        return this.index == null;
    }

    protected void visitTerm(TermsEnum te, int termNum) throws IOException {
    }

    protected void setActualDocFreq(int termNum, int df) throws IOException {
    }

    protected void uninvert(LeafReader reader, Bits liveDocs, BytesRef termPrefix) throws IOException {
        BytesRef t;
        BytesRef seekStart;
        FieldInfo info = reader.getFieldInfos().fieldInfo(this.field);
        if (this.checkForDocValues && info != null && info.getDocValuesType() != DocValuesType.NONE) {
            throw new IllegalStateException("Type mismatch: " + this.field + " was indexed as " + info.getDocValuesType());
        }
        long startTime = System.nanoTime();
        this.prefix = termPrefix == null ? null : BytesRef.deepCopyOf(termPrefix);
        int maxDoc = reader.maxDoc();
        int[] index = new int[maxDoc];
        int[] lastTerm = new int[maxDoc];
        byte[][] bytes = new byte[maxDoc][];
        Terms terms = reader.terms(this.field);
        if (terms == null) {
            return;
        }
        TermsEnum te = terms.iterator();
        BytesRef bytesRef = seekStart = termPrefix != null ? termPrefix : new BytesRef();
        if (te.seekCeil(seekStart) == TermsEnum.SeekStatus.END) {
            return;
        }
        ArrayList<BytesRef> indexedTerms = new ArrayList<BytesRef>();
        PagedBytes indexedTermsBytes = new PagedBytes(15);
        byte[] tempArr = new byte[12];
        int termNum = 0;
        this.postingsEnum = null;
        while ((t = te.term()) != null && (termPrefix == null || StringHelper.startsWith(t, termPrefix))) {
            int df;
            this.visitTerm(te, termNum);
            if ((termNum & this.indexIntervalMask) == 0) {
                this.sizeOfIndexedStrings += (long)t.length;
                BytesRef indexedTerm = new BytesRef();
                indexedTermsBytes.copy(t, indexedTerm);
                indexedTerms.add(indexedTerm);
            }
            if ((df = te.docFreq()) <= this.maxTermDocFreq) {
                int doc;
                this.postingsEnum = te.postings(this.postingsEnum, 0);
                int actualDF = 0;
                while ((doc = this.postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                    ++actualDF;
                    ++this.termInstances;
                    int delta = termNum - lastTerm[doc] + 2;
                    lastTerm[doc] = termNum;
                    int val = index[doc];
                    if ((val & Integer.MIN_VALUE) != 0) {
                        byte[] arr;
                        int pos = val & Integer.MAX_VALUE;
                        int ilen = DocTermOrds.vIntSize(delta);
                        int newend = pos + ilen;
                        if (newend > (arr = bytes[doc]).length) {
                            int newLen = newend + 3 & 0xFFFFFFFC;
                            byte[] newarr = new byte[newLen];
                            System.arraycopy(arr, 0, newarr, 0, pos);
                            arr = newarr;
                            bytes[doc] = newarr;
                        }
                        pos = DocTermOrds.writeInt(delta, arr, pos);
                        index[doc] = pos | Integer.MIN_VALUE;
                        continue;
                    }
                    int ipos = val == 0 ? 0 : ((val & 0xFF80) == 0 ? 1 : ((val & 0xFF8000) == 0 ? 2 : ((val & 0xFF800000) == 0 ? 3 : 4)));
                    int endPos = DocTermOrds.writeInt(delta, tempArr, ipos);
                    if (endPos <= 4) {
                        for (int j = ipos; j < endPos; ++j) {
                            val |= (tempArr[j] & 0xFF) << (j << 3);
                        }
                        index[doc] = val;
                        continue;
                    }
                    for (int j = 0; j < ipos; ++j) {
                        tempArr[j] = (byte)val;
                        val >>>= 8;
                    }
                    index[doc] = endPos | Integer.MIN_VALUE;
                    bytes[doc] = tempArr;
                    tempArr = new byte[12];
                }
                this.setActualDocFreq(termNum, actualDF);
            }
            ++termNum;
            if (te.next() != null) continue;
            break;
        }
        this.numTermsInField = termNum;
        long midPoint = System.nanoTime();
        if (this.termInstances == 0L) {
            this.tnums = null;
        } else {
            this.index = index;
            for (int pass = 0; pass < 256; ++pass) {
                byte[] target = this.tnums[pass];
                int pos = 0;
                if (target != null) {
                    pos = target.length;
                } else {
                    target = new byte[4096];
                }
                for (int docbase = pass << 16; docbase < maxDoc; docbase += 0x1000000) {
                    int lim = Math.min(docbase + 65536, maxDoc);
                    for (int doc = docbase; doc < lim; ++doc) {
                        int val = index[doc];
                        if ((val & Integer.MIN_VALUE) == 0) continue;
                        int len = val & Integer.MAX_VALUE;
                        index[doc] = pos | Integer.MIN_VALUE;
                        byte[] arr = bytes[doc];
                        bytes[doc] = null;
                        if (target.length <= pos + len) {
                            int newlen = target.length;
                            while (newlen <= pos + len) {
                                if ((newlen <<= 1) >= 0 || (newlen = 0x7FFFFFEF) > pos + len) continue;
                                throw new IllegalStateException("Too many terms (> Integer.MAX_VALUE-16) to uninvert field '" + this.field + "'");
                            }
                            byte[] newtarget = new byte[newlen];
                            System.arraycopy(target, 0, newtarget, 0, pos);
                            target = newtarget;
                        }
                        System.arraycopy(arr, 0, target, pos, len);
                        pos += len + 1;
                    }
                }
                if (pos < target.length) {
                    byte[] newtarget = new byte[pos];
                    System.arraycopy(target, 0, newtarget, 0, pos);
                    target = newtarget;
                }
                this.tnums[pass] = target;
                if (pass << 16 > maxDoc) break;
            }
        }
        this.indexedTermsArray = indexedTerms.toArray(new BytesRef[0]);
        long endTime = System.nanoTime();
        this.total_time = (int)TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
        this.phase1_time = (int)TimeUnit.MILLISECONDS.convert(midPoint - startTime, TimeUnit.NANOSECONDS);
    }

    private static int vIntSize(int x) {
        return BLOCK7[Integer.numberOfLeadingZeros(x)];
    }

    private static int writeInt(int x, byte[] arr, int pos) {
        int a = x >>> 28;
        if (a != 0) {
            arr[pos++] = (byte)(a | 0x80);
        }
        if ((a = x >>> 21) != 0) {
            arr[pos++] = (byte)(a | 0x80);
        }
        if ((a = x >>> 14) != 0) {
            arr[pos++] = (byte)(a | 0x80);
        }
        if ((a = x >>> 7) != 0) {
            arr[pos++] = (byte)(a | 0x80);
        }
        arr[pos++] = (byte)(x & 0x7F);
        return pos;
    }

    public BytesRef lookupTerm(TermsEnum termsEnum, int ord) throws IOException {
        termsEnum.seekExact(ord);
        return termsEnum.term();
    }

    public SortedSetDocValues iterator(LeafReader reader) throws IOException {
        if (this.isEmpty()) {
            return DocValues.emptySortedSet();
        }
        return new Iterator(reader);
    }

    private class Iterator
    extends SortedSetDocValues {
        final LeafReader reader;
        final TermsEnum te;
        final int maxDoc;
        final int[] buffer = new int[5];
        int bufferUpto;
        int bufferLength;
        private int doc = -1;
        private int tnum;
        private int upto;
        private byte[] arr;

        Iterator(LeafReader reader) throws IOException {
            this.reader = reader;
            this.maxDoc = reader.maxDoc();
            this.te = this.termsEnum();
        }

        @Override
        public long nextOrd() {
            while (this.bufferUpto == this.bufferLength) {
                if (this.bufferLength < this.buffer.length) {
                    return -1L;
                }
                this.bufferLength = this.read(this.buffer);
                this.bufferUpto = 0;
            }
            return this.buffer[this.bufferUpto++];
        }

        @Override
        public int docValueCount() {
            int delta;
            int start;
            if (this.arr == null) {
                return this.bufferLength;
            }
            int cursor = start = DocTermOrds.this.index[this.doc] & Integer.MAX_VALUE;
            do {
                byte b;
                delta = 0;
                do {
                    b = this.arr[cursor++];
                    delta = delta << 7 | b & 0x7F;
                } while ((b & 0x80) != 0);
            } while (delta != 0);
            return cursor - start - 1;
        }

        int read(int[] buffer) {
            int bufferUpto;
            block6: {
                bufferUpto = 0;
                if (this.arr == null) {
                    int code = this.upto;
                    int delta = 0;
                    while (true) {
                        delta = delta << 7 | code & 0x7F;
                        if ((code & 0x80) == 0) {
                            if (delta == 0) break block6;
                            this.tnum += delta - 2;
                            buffer[bufferUpto++] = DocTermOrds.this.ordBase + this.tnum;
                            delta = 0;
                        }
                        code >>>= 8;
                    }
                }
                do {
                    byte b;
                    int delta = 0;
                    do {
                        b = this.arr[this.upto++];
                        delta = delta << 7 | b & 0x7F;
                    } while ((b & 0x80) != 0);
                    if (delta == 0) break;
                    this.tnum += delta - 2;
                    buffer[bufferUpto++] = DocTermOrds.this.ordBase + this.tnum;
                } while (bufferUpto != buffer.length);
            }
            return bufferUpto;
        }

        private void setDocument(int docID) {
            this.doc = docID;
            this.tnum = 0;
            int code = DocTermOrds.this.index[docID];
            if ((code & Integer.MIN_VALUE) != 0) {
                this.upto = code & Integer.MAX_VALUE;
                int whichArray = docID >>> 16 & 0xFF;
                this.arr = DocTermOrds.this.tnums[whichArray];
            } else {
                this.arr = null;
                this.upto = code;
            }
            this.bufferUpto = 0;
            this.bufferLength = this.read(this.buffer);
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.setDocument(target);
            return this.bufferLength > 0;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.docID() + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            for (int d = target; d < this.maxDoc; ++d) {
                if (!this.advanceExact(d)) continue;
                return d;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public long cost() {
            return this.maxDoc;
        }

        @Override
        public BytesRef lookupOrd(long ord) {
            try {
                return DocTermOrds.this.lookupTerm(this.te, (int)ord);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public long getValueCount() {
            return DocTermOrds.this.numTerms();
        }

        @Override
        public long lookupTerm(BytesRef key) {
            try {
                switch (this.te.seekCeil(key)) {
                    case FOUND: {
                        assert (this.te.ord() >= 0L);
                        return this.te.ord();
                    }
                    case NOT_FOUND: {
                        assert (this.te.ord() >= 0L);
                        return -this.te.ord() - 1L;
                    }
                }
                return (long)(-DocTermOrds.this.numTerms()) - 1L;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public TermsEnum termsEnum() {
            try {
                return DocTermOrds.this.getOrdTermsEnum(this.reader);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final class OrdWrappedTermsEnum
    extends BaseTermsEnum {
        private final TermsEnum termsEnum;
        private BytesRef term;
        private long ord;

        public OrdWrappedTermsEnum(LeafReader reader) throws IOException {
            this.ord = (long)(-DocTermOrds.this.indexInterval) - 1L;
            assert (DocTermOrds.this.indexedTermsArray != null);
            assert (0 != DocTermOrds.this.indexedTermsArray.length);
            this.termsEnum = reader.terms(DocTermOrds.this.field).iterator();
        }

        @Override
        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            return this.termsEnum.postings(reuse, flags);
        }

        @Override
        public ImpactsEnum impacts(int flags) throws IOException {
            return this.termsEnum.impacts(flags);
        }

        @Override
        public BytesRef term() {
            return this.term;
        }

        @Override
        public BytesRef next() throws IOException {
            if (++this.ord < 0L) {
                this.ord = 0L;
            }
            if (this.termsEnum.next() == null) {
                this.term = null;
                return null;
            }
            return this.setTerm();
        }

        @Override
        public int docFreq() throws IOException {
            return this.termsEnum.docFreq();
        }

        @Override
        public long totalTermFreq() throws IOException {
            return this.termsEnum.totalTermFreq();
        }

        @Override
        public long ord() {
            return (long)DocTermOrds.this.ordBase + this.ord;
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef target) throws IOException {
            if (this.term != null && this.term.equals(target)) {
                return TermsEnum.SeekStatus.FOUND;
            }
            int startIdx = Arrays.binarySearch(DocTermOrds.this.indexedTermsArray, target);
            if (startIdx >= 0) {
                TermsEnum.SeekStatus seekStatus = this.termsEnum.seekCeil(target);
                assert (seekStatus == TermsEnum.SeekStatus.FOUND);
                this.ord = (long)startIdx << DocTermOrds.this.indexIntervalBits;
                this.setTerm();
                assert (this.term != null);
                return TermsEnum.SeekStatus.FOUND;
            }
            if ((startIdx = -startIdx - 1) == 0) {
                TermsEnum.SeekStatus seekStatus = this.termsEnum.seekCeil(target);
                assert (seekStatus == TermsEnum.SeekStatus.NOT_FOUND);
                this.ord = 0L;
                this.setTerm();
                assert (this.term != null);
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            if (this.ord >> DocTermOrds.this.indexIntervalBits != (long)(--startIdx) || this.term == null || this.term.compareTo(target) > 0) {
                TermsEnum.SeekStatus seekStatus = this.termsEnum.seekCeil(DocTermOrds.this.indexedTermsArray[startIdx]);
                assert (seekStatus == TermsEnum.SeekStatus.FOUND);
                this.ord = (long)startIdx << DocTermOrds.this.indexIntervalBits;
                this.setTerm();
                assert (this.term != null);
            }
            while (this.term != null && this.term.compareTo(target) < 0) {
                this.next();
            }
            if (this.term == null) {
                return TermsEnum.SeekStatus.END;
            }
            if (this.term.compareTo(target) == 0) {
                return TermsEnum.SeekStatus.FOUND;
            }
            return TermsEnum.SeekStatus.NOT_FOUND;
        }

        @Override
        public boolean seekExact(BytesRef text) throws IOException {
            return this.seekCeil(text) == TermsEnum.SeekStatus.FOUND;
        }

        @Override
        public void seekExact(long targetOrd) throws IOException {
            int delta = (int)(targetOrd - (long)DocTermOrds.this.ordBase - this.ord);
            if (delta < 0 || delta > DocTermOrds.this.indexInterval) {
                int idx = (int)(targetOrd >>> DocTermOrds.this.indexIntervalBits);
                BytesRef base = DocTermOrds.this.indexedTermsArray[idx];
                this.ord = (long)idx << DocTermOrds.this.indexIntervalBits;
                delta = (int)(targetOrd - this.ord);
                TermsEnum.SeekStatus seekStatus = this.termsEnum.seekCeil(base);
                assert (seekStatus == TermsEnum.SeekStatus.FOUND);
            }
            while (--delta >= 0) {
                BytesRef br = this.termsEnum.next();
                if (br == null) {
                    assert (false);
                    return;
                }
                ++this.ord;
            }
            this.setTerm();
            assert (this.term != null);
        }

        private BytesRef setTerm() throws IOException {
            this.term = this.termsEnum.term();
            if (DocTermOrds.this.prefix != null && !StringHelper.startsWith(this.term, DocTermOrds.this.prefix)) {
                this.term = null;
            }
            return this.term;
        }
    }
}

