/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.uninverting.UninvertingReader;

final class DeleteByQueryWrapper
extends Query {
    final Query in;
    final IndexSchema schema;

    DeleteByQueryWrapper(Query in, IndexSchema schema) {
        this.in = in;
        this.schema = schema;
    }

    LeafReader wrap(LeafReader reader) {
        return UninvertingReader.wrap(reader, this.schema.getUninversionMapper());
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.in.rewrite(reader);
        if (!rewritten.equals(this.in)) {
            return new DeleteByQueryWrapper(rewritten, this.schema);
        }
        return super.rewrite(reader);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        LeafReader wrapped = this.wrap((LeafReader)searcher.getIndexReader());
        final IndexSearcher privateContext = new IndexSearcher(wrapped);
        privateContext.setQueryCache(searcher.getQueryCache());
        final Weight inner = this.in.createWeight(privateContext, scoreMode, boost);
        return new Weight(this){

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                return inner.scorer(privateContext.getIndexReader().leaves().get(0));
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return inner.isCacheable(ctx);
            }
        };
    }

    @Override
    public String toString(String field) {
        return "Uninverting(" + this.in.toString(field) + ")";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + Objects.hashCode(this.in);
        result = 31 * result + Objects.hashCode(this.schema);
        return result;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((DeleteByQueryWrapper)this.getClass().cast(other));
    }

    private boolean equalsTo(DeleteByQueryWrapper other) {
        return Objects.equals(this.in, other.in) && Objects.equals(this.schema, other.schema);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }
}

