/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrDocumentBase;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.DenseVectorField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;

public class DocumentBuilder {
    static int MIN_LENGTH_TO_MOVE_LAST = Integer.getInteger("solr.docBuilder.minLengthToMoveLast", 4096);
    static int MAX_VALUES_AS_STRING_LENGTH = 256;

    private static void addField(Document doc, SchemaField field, Object val, boolean forInPlaceUpdate) {
        if (val instanceof IndexableField) {
            if (forInPlaceUpdate) assert (val instanceof NumericDocValuesField) : "Expected in-place update to be done on NDV fields only.";
            doc.add((IndexableField)val);
            return;
        }
        for (IndexableField f : field.getType().createFields(field, val)) {
            if (f == null) continue;
            if (forInPlaceUpdate) {
                if (!(f instanceof NumericDocValuesField)) continue;
                doc.add(f);
                continue;
            }
            doc.add(f);
        }
    }

    private static String getID(SolrInputDocument doc, IndexSchema schema) {
        Object id = "";
        SchemaField sf = schema.getUniqueKeyField();
        if (sf != null) {
            id = "[doc=" + doc.getFieldValue(sf.getName()) + "] ";
        }
        return id;
    }

    public static Document toDocument(SolrInputDocument doc, IndexSchema schema) {
        return DocumentBuilder.toDocument(doc, schema, false, true);
    }

    public static Document toDocument(SolrInputDocument doc, IndexSchema schema, boolean forInPlaceUpdate, boolean ignoreNestedDocs) {
        if (!ignoreNestedDocs && doc.hasChildDocuments()) {
            throw DocumentBuilder.unexpectedNestedDocException(schema, forInPlaceUpdate);
        }
        SchemaField uniqueKeyField = schema.getUniqueKeyField();
        String uniqueKeyFieldName = null == uniqueKeyField ? null : uniqueKeyField.getName();
        Document out = new Document();
        HashSet<String> usedFields = new HashSet<String>();
        for (SolrInputField solrInputField : doc) {
            if (forInPlaceUpdate && (solrInputField.getName().equals(uniqueKeyFieldName) || solrInputField.getName().equals("_root_"))) continue;
            if (solrInputField.getFirstValue() instanceof SolrDocumentBase) {
                if (ignoreNestedDocs) continue;
                throw DocumentBuilder.unexpectedNestedDocException(schema, forInPlaceUpdate);
            }
            String name = solrInputField.getName();
            SchemaField sfield = schema.getFieldOrNull(name);
            boolean used = false;
            if (sfield != null && !sfield.multiValued() && solrInputField.getValueCount() > 1 && !(sfield.getType() instanceof DenseVectorField)) {
                Object fieldValue = solrInputField.getValue().toString();
                if (((String)fieldValue).length() > MAX_VALUES_AS_STRING_LENGTH) {
                    assert (((String)fieldValue).endsWith("]"));
                    fieldValue = ((String)fieldValue).substring(0, MAX_VALUES_AS_STRING_LENGTH - 4) + "...]";
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: " + DocumentBuilder.getID(doc, schema) + "multiple values encountered for non multiValued field " + sfield.getName() + ": " + (String)fieldValue);
            }
            List<CopyField> copyFields = schema.getCopyFieldsList(name);
            if (copyFields.size() == 0) {
                copyFields = null;
            }
            boolean hasField = false;
            try {
                if (sfield != null && sfield.getType() instanceof DenseVectorField) {
                    Object vectorValue = solrInputField.getValue();
                    if (vectorValue != null) {
                        hasField = true;
                        used = DocumentBuilder.addOriginalField(vectorValue, sfield, forInPlaceUpdate, out, usedFields);
                        if (copyFields != null) {
                            used |= DocumentBuilder.addCopyFields(schema, vectorValue, sfield.getType(), copyFields, forInPlaceUpdate, uniqueKeyFieldName, out, usedFields);
                        }
                    }
                } else {
                    for (Object v : solrInputField) {
                        if (v == null) continue;
                        hasField = true;
                        if (sfield != null) {
                            used = DocumentBuilder.addOriginalField(v, sfield, forInPlaceUpdate, out, usedFields);
                        }
                        if (copyFields == null) continue;
                        used |= DocumentBuilder.addCopyFields(schema, v, sfield.getType(), copyFields, forInPlaceUpdate, uniqueKeyFieldName, out, usedFields);
                    }
                }
            }
            catch (SolrException ex) {
                throw new SolrException(SolrException.ErrorCode.getErrorCode(ex.code()), "ERROR: " + DocumentBuilder.getID(doc, schema) + "Error adding field '" + solrInputField.getName() + "'='" + solrInputField.getValue() + "' msg=" + ex.getMessage(), (Throwable)ex);
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: " + DocumentBuilder.getID(doc, schema) + "Error adding field '" + solrInputField.getName() + "'='" + solrInputField.getValue() + "' msg=" + ex.getMessage(), (Throwable)ex);
            }
            if (used || !hasField) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: " + DocumentBuilder.getID(doc, schema) + "unknown field '" + name + "'");
        }
        if (!forInPlaceUpdate) {
            for (SchemaField schemaField : schema.getRequiredFields()) {
                if (out.getField(schemaField.getName()) != null) continue;
                if (schemaField.getDefaultValue() != null) {
                    DocumentBuilder.addField(out, schemaField, schemaField.getDefaultValue(), false);
                    continue;
                }
                String msg = DocumentBuilder.getID(doc, schema) + "missing required field: " + schemaField.getName();
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
            }
        }
        if (!forInPlaceUpdate) {
            DocumentBuilder.moveLargestFieldLast(out);
        }
        return out;
    }

    private static boolean addOriginalField(Object originalFieldValue, SchemaField sfield, boolean forInPlaceUpdate, Document out, Set<String> usedFields) {
        DocumentBuilder.addField(out, sfield, originalFieldValue, forInPlaceUpdate);
        usedFields.add(sfield.getName());
        return true;
    }

    private static boolean addCopyFields(IndexSchema schema, Object originalFieldValue, FieldType originalFieldType, List<CopyField> copyFields, boolean forInPlaceUpdate, String uniqueKeyFieldName, Document out, Set<String> usedFields) {
        boolean used = false;
        for (CopyField cf : copyFields) {
            SchemaField destinationField = cf.getDestination();
            boolean destHasValues = usedFields.contains(destinationField.getName());
            if (originalFieldType instanceof DenseVectorField && !(destinationField.getType() instanceof DenseVectorField)) {
                if (schema.getCopySources(destinationField.getName()).contains("*")) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The copy field destination must be a DenseVectorField: " + destinationField.getName());
            }
            if (!destinationField.multiValued() && destHasValues) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Multiple values encountered for non multiValued copy field " + destinationField.getName() + ": " + originalFieldValue);
            }
            Object fieldValue = originalFieldValue;
            if (originalFieldValue instanceof CharSequence && cf.getMaxChars() > 0) {
                fieldValue = cf.getLimitedValue(originalFieldValue.toString());
            }
            DocumentBuilder.addField(out, destinationField, fieldValue, destinationField.getName().equals(uniqueKeyFieldName) ? false : forInPlaceUpdate);
            usedFields.add(destinationField.getName());
            used = true;
        }
        return used;
    }

    private static SolrException unexpectedNestedDocException(IndexSchema schema, boolean forInPlaceUpdate) {
        if (!schema.isUsableForChildDocs()) {
            return new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to index docs with children: the schema must include definitions for both a uniqueKey field and the '_root_' field, using the exact same fieldType");
        }
        if (forInPlaceUpdate) {
            return new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to index docs with children: for an in-place update, just provide the doc by itself");
        }
        return new SolrException(SolrException.ErrorCode.SERVER_ERROR, "A document unexpectedly contained nested child documents");
    }

    private static void moveLargestFieldLast(Document doc) {
        String largestField = null;
        int largestFieldLen = -1;
        boolean largestIsLast = true;
        for (IndexableField field : doc) {
            if (!field.fieldType().stored()) continue;
            if (largestIsLast && !field.name().equals(largestField)) {
                largestIsLast = false;
            }
            if (field.numericValue() != null) continue;
            String strVal = field.stringValue();
            if (strVal != null) {
                if (strVal.length() <= largestFieldLen) continue;
                largestField = field.name();
                largestFieldLen = strVal.length();
                largestIsLast = true;
                continue;
            }
            BytesRef bytesRef = field.binaryValue();
            if (bytesRef == null || bytesRef.length <= largestFieldLen) continue;
            largestField = field.name();
            largestFieldLen = bytesRef.length;
            largestIsLast = true;
        }
        if (!largestIsLast && largestField != null && largestFieldLen > MIN_LENGTH_TO_MOVE_LAST) {
            ArrayList<IndexableField> addToEnd = new ArrayList<IndexableField>();
            Iterator<IndexableField> iterator = doc.iterator();
            while (iterator.hasNext()) {
                IndexableField field = iterator.next();
                if (!field.name().equals(largestField)) continue;
                addToEnd.add(field);
                iterator.remove();
            }
            for (IndexableField field : addToEnd) {
                doc.add(field);
            }
        }
    }
}

