/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.TimedVersionBucket;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.VersionBucket;
import org.apache.solr.util.RefCounted;

public class VersionInfo {
    private static final String SYS_PROP_BUCKET_VERSION_LOCK_TIMEOUT_MS = "bucketVersionLockTimeoutMs";
    private final UpdateLog ulog;
    private final int numBuckets;
    private volatile VersionBucket[] buckets;
    private final Object bucketsSync = new Object();
    private final SchemaField versionField;
    final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final int versionBucketLockTimeoutMs;
    private long vclock;
    private final Object clockSync = new Object();

    public static SchemaField getAndCheckVersionField(IndexSchema schema) throws SolrException {
        String errPrefix = "_version_ field must exist in schema and be searchable (indexed or docValues) and retrievable(stored or docValues) and not multiValued";
        SchemaField sf = schema.getFieldOrNull("_version_");
        if (null == sf) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "_version_ field must exist in schema and be searchable (indexed or docValues) and retrievable(stored or docValues) and not multiValued (_version_ does not exist)");
        }
        if (!sf.indexed() && !sf.hasDocValues()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "_version_ field must exist in schema and be searchable (indexed or docValues) and retrievable(stored or docValues) and not multiValued (_version_ not searchable");
        }
        if (!sf.stored() && !sf.hasDocValues()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "_version_ field must exist in schema and be searchable (indexed or docValues) and retrievable(stored or docValues) and not multiValued (_version_ not retrievable");
        }
        if (sf.multiValued()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "_version_ field must exist in schema and be searchable (indexed or docValues) and retrievable(stored or docValues) and not multiValued (_version_ is multiValued");
        }
        return sf;
    }

    public VersionInfo(UpdateLog ulog, int nBuckets) {
        this.ulog = ulog;
        IndexSchema schema = ulog.uhandler.core.getLatestSchema();
        this.versionField = VersionInfo.getAndCheckVersionField(schema);
        this.versionBucketLockTimeoutMs = ulog.uhandler.core.getSolrConfig().get("updateHandler").get("versionBucketLockTimeoutMs").intVal(Integer.parseInt(System.getProperty(SYS_PROP_BUCKET_VERSION_LOCK_TIMEOUT_MS, "0")));
        this.numBuckets = BitUtil.nextHighestPowerOfTwo(nBuckets);
    }

    public int getVersionBucketLockTimeoutMs() {
        return this.versionBucketLockTimeoutMs;
    }

    public void reload() {
    }

    public SchemaField getVersionField() {
        return this.versionField;
    }

    public void lockForUpdate() {
        this.lock.readLock().lock();
    }

    public void unlockForUpdate() {
        this.lock.readLock().unlock();
    }

    public void blockUpdates() {
        this.lock.writeLock().lock();
    }

    public void unblockUpdates() {
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="need currentTimeMillis just for getting realistic version stamps, does not assume monotonicity")
    public long getNewClock() {
        Object object = this.clockSync;
        synchronized (object) {
            long time = System.currentTimeMillis();
            long result = time << 20;
            if (result <= this.vclock) {
                result = this.vclock + 1L;
            }
            this.vclock = result;
            return this.vclock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOldClock() {
        Object object = this.clockSync;
        synchronized (object) {
            return this.vclock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClock(long clock) {
        Object object = this.clockSync;
        synchronized (object) {
            this.vclock = Math.max(this.vclock, clock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionBucket bucket(int hash) {
        int slot = hash & this.numBuckets - 1;
        if (this.buckets == null) {
            Object object = this.bucketsSync;
            synchronized (object) {
                if (this.buckets == null) {
                    this.buckets = this.createVersionBuckets();
                }
            }
        }
        return this.buckets[slot];
    }

    private VersionBucket[] createVersionBuckets() {
        VersionBucket[] buckets = new VersionBucket[this.numBuckets];
        for (int i = 0; i < buckets.length; ++i) {
            buckets[i] = this.versionBucketLockTimeoutMs > 0 ? new TimedVersionBucket() : new VersionBucket();
        }
        return buckets;
    }

    public Long lookupVersion(BytesRef idBytes) {
        return this.ulog.lookupVersion(idBytes);
    }

    public Long getVersionFromIndex(BytesRef idBytes) {
        RefCounted<SolrIndexSearcher> newestSearcher = this.ulog.uhandler.core.getRealtimeSearcher();
        try {
            SolrIndexSearcher searcher = newestSearcher.get();
            long lookup = searcher.lookupId(idBytes);
            if (lookup < 0L) {
                Long l = null;
                return l;
            }
            ValueSource vs = this.versionField.getType().getValueSource(this.versionField, null);
            Map<Object, Object> context = ValueSource.newContext(searcher);
            vs.createWeight(context, searcher);
            FunctionValues fv = vs.getValues(context, searcher.getTopReaderContext().leaves().get((int)(lookup >> 32)));
            long ver = fv.longVal((int)lookup);
            Long l = ver;
            return l;
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading version from index", (Throwable)e);
        }
        finally {
            if (newestSearcher != null) {
                newestSearcher.decref();
            }
        }
    }
}

