/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import com.j256.simplemagic.ContentInfo;
import com.j256.simplemagic.ContentInfoUtil;
import com.j256.simplemagic.ContentType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.solr.common.SolrException;

public class FileTypeMagicUtil
implements ContentInfoUtil.ErrorCallBack {
    private final ContentInfoUtil util;
    private static final Set<String> SKIP_FOLDERS = new HashSet<String>(Arrays.asList(".", ".."));
    public static FileTypeMagicUtil INSTANCE = new FileTypeMagicUtil();
    private static final Set<String> forbiddenTypes = new HashSet<String>(Arrays.asList(System.getProperty("solr.configset.upload.mimetypes.forbidden", "application/x-java-applet,application/zip,application/x-tar,text/x-shellscript").split(",")));

    FileTypeMagicUtil() {
        try {
            this.util = new ContentInfoUtil("/magic/executables", (ContentInfoUtil.ErrorCallBack)this);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error parsing magic file", (Throwable)e);
        }
    }

    public static void assertConfigSetFolderLegal(Path confPath) throws IOException {
        Files.walkFileTree(confPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (FileTypeMagicUtil.isFileForbiddenInConfigset(file)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Not uploading file %s to configset, as it matched the MAGIC signature of a forbidden mime type %s", file, INSTANCE.guessMimeType(file)));
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                if (SKIP_FOLDERS.contains(dir.getFileName().toString())) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public String guessMimeType(Path file) {
        try {
            return this.guessTypeFallbackToOctetStream(this.util.findMatch(file.toFile()));
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    String guessMimeType(InputStream stream) {
        try {
            return this.guessTypeFallbackToOctetStream(this.util.findMatch(stream));
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    public String guessMimeType(byte[] bytes) {
        return this.guessTypeFallbackToOctetStream(this.util.findMatch(bytes));
    }

    public void error(String line, String details, Exception e) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "%s: %s", line, details), (Throwable)e);
    }

    public static boolean isFileForbiddenInConfigset(Path file) {
        boolean bl;
        block8: {
            InputStream fileStream = Files.newInputStream(file, new OpenOption[0]);
            try {
                bl = FileTypeMagicUtil.isFileForbiddenInConfigset(fileStream);
                if (fileStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileStream != null) {
                        try {
                            fileStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "Error reading file %s", file), (Throwable)e);
                }
            }
            fileStream.close();
        }
        return bl;
    }

    static boolean isFileForbiddenInConfigset(InputStream fileStream) {
        return forbiddenTypes.contains(INSTANCE.guessMimeType(fileStream));
    }

    public static boolean isFileForbiddenInConfigset(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return false;
        }
        return forbiddenTypes.contains(INSTANCE.guessMimeType(bytes));
    }

    private String guessTypeFallbackToOctetStream(ContentInfo contentInfo) {
        if (contentInfo == null) {
            return ContentType.OTHER.getMimeType();
        }
        return contentInfo.getContentType().getMimeType();
    }
}

