/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ShardParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrResponseUtil {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private SolrResponseUtil() {
    }

    public static Object getSubsectionFromShardResponse(ResponseBuilder rb, ShardResponse srsp, String shardResponseKey, boolean subSectionOptional) {
        try {
            SolrResponse solrResponse = srsp.getSolrResponse();
            NamedList<Object> response = solrResponse.getResponse();
            Object shardResponseSubsection = response.get(shardResponseKey);
            if (shardResponseSubsection != null) {
                return shardResponseSubsection;
            }
            NamedList responseHeader = Objects.requireNonNull((NamedList)response.get("responseHeader"));
            if (subSectionOptional || Boolean.TRUE.equals(responseHeader.getBooleanArg("partialResults"))) {
                return null;
            }
            log.warn("corrupted response on {} : {}", (Object)srsp.getShardRequest(), (Object)solrResponse);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, shardResponseKey + " is absent in response from " + srsp.getNodeName() + ", but partialResults isn't set in the response.");
        }
        catch (Exception ex) {
            if (rb != null && ShardParams.getShardsTolerantAsBool(rb.req.getParams())) {
                return null;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to read " + shardResponseKey + " info for shard: " + srsp.getShard(), (Throwable)ex);
        }
    }
}

