/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.circuitbreaker;

import com.google.common.util.concurrent.AtomicDouble;
import java.io.Closeable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.logging.CircularList;

public class AveragingMetricProvider
implements Closeable {
    private final CircularList<Double> samplesRingBuffer;
    private ScheduledExecutorService executor;
    private final AtomicDouble currentAverageValue = new AtomicDouble(-1.0);

    public AveragingMetricProvider(MetricProvider metricProvider, int numSamples, long sampleInterval) {
        this.samplesRingBuffer = new CircularList(numSamples);
        this.executor = Executors.newSingleThreadScheduledExecutor(new SolrNamedThreadFactory("AveragingMetricProvider-" + metricProvider.getClass().getSimpleName()));
        this.executor.scheduleWithFixedDelay(() -> {
            this.samplesRingBuffer.add(metricProvider.getMetricValue());
            this.currentAverageValue.set(this.samplesRingBuffer.toList().stream().mapToDouble(Double::doubleValue).average().orElse(-1.0));
        }, 0L, sampleInterval, TimeUnit.SECONDS);
    }

    public double getMetricValue() {
        return this.currentAverageValue.get();
    }

    @Override
    public void close() {
        ExecutorUtil.shutdownAndAwaitTermination(this.executor);
    }

    public static interface MetricProvider {
        public double getMetricValue();
    }
}

