/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.circuitbreaker;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.EnvUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.util.circuitbreaker.CPUCircuitBreaker;
import org.apache.solr.util.circuitbreaker.CircuitBreaker;
import org.apache.solr.util.circuitbreaker.LoadAverageCircuitBreaker;
import org.apache.solr.util.circuitbreaker.MemoryCircuitBreaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircuitBreakerRegistry
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<SolrRequest.SolrRequestType, List<CircuitBreaker>> circuitBreakerMap = new HashMap<SolrRequest.SolrRequestType, List<CircuitBreaker>>();
    private static final Map<SolrRequest.SolrRequestType, List<CircuitBreaker>> globalCircuitBreakerMap = new HashMap<SolrRequest.SolrRequestType, List<CircuitBreaker>>();
    private static final Pattern SYSPROP_REGEX = Pattern.compile("solr.circuitbreaker\\.(update|query)\\.(cpu|mem|loadavg)");
    public static final String SYSPROP_PREFIX = "solr.circuitbreaker.";
    public static final String SYSPROP_UPDATE_CPU = "solr.circuitbreaker.update.cpu";
    public static final String SYSPROP_UPDATE_MEM = "solr.circuitbreaker.update.mem";
    public static final String SYSPROP_UPDATE_LOADAVG = "solr.circuitbreaker.update.loadavg";
    public static final String SYSPROP_QUERY_CPU = "solr.circuitbreaker.query.cpu";
    public static final String SYSPROP_QUERY_MEM = "solr.circuitbreaker.query.mem";
    public static final String SYSPROP_QUERY_LOADAVG = "solr.circuitbreaker.query.loadavg";

    public CircuitBreakerRegistry(CoreContainer coreContainer) {
        CircuitBreakerRegistry.initGlobal(coreContainer);
    }

    private static void initGlobal(CoreContainer coreContainer) {
        EnvUtils.getProperties().keySet().stream().map(SYSPROP_REGEX::matcher).filter(Matcher::matches).collect(Collectors.groupingBy(m -> m.group(2) + ":" + System.getProperty(m.group(0)))).forEach((breakerAndValue, breakers) -> {
            CircuitBreaker breaker;
            String[] breakerAndValueArr = breakerAndValue.split(":");
            switch (breakerAndValueArr[0]) {
                case "cpu": {
                    breaker = new CPUCircuitBreaker(coreContainer).setThreshold(Double.parseDouble(breakerAndValueArr[1]));
                    break;
                }
                case "mem": {
                    breaker = new MemoryCircuitBreaker().setThreshold(Double.parseDouble(breakerAndValueArr[1]));
                    break;
                }
                case "loadavg": {
                    breaker = new LoadAverageCircuitBreaker().setThreshold(Double.parseDouble(breakerAndValueArr[1]));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown circuit breaker type: " + breakerAndValueArr[0]);
                }
            }
            breaker.setRequestTypes(breakers.stream().map(m -> m.group(1)).collect(Collectors.toList()));
            CircuitBreakerRegistry.registerGlobal(breaker);
            if (log.isInfoEnabled()) {
                log.info("Registered global circuit breaker {} for request type(s) {}", breakerAndValue, breaker.getRequestTypes());
            }
        });
    }

    public static Set<CircuitBreaker> listGlobal() {
        return globalCircuitBreakerMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(CircuitBreaker circuitBreaker) {
        Map<SolrRequest.SolrRequestType, List<CircuitBreaker>> map = this.circuitBreakerMap;
        synchronized (map) {
            circuitBreaker.getRequestTypes().forEach(r -> {
                List list = this.circuitBreakerMap.computeIfAbsent((SolrRequest.SolrRequestType)((Object)r), k -> new ArrayList());
                list.add(circuitBreaker);
                if (log.isInfoEnabled()) {
                    log.info("Registered circuit breaker {} for request type(s) {}", (Object)circuitBreaker.getClass().getSimpleName(), (Object)r);
                }
            });
        }
    }

    public static void registerGlobal(CircuitBreaker circuitBreaker) {
        circuitBreaker.getRequestTypes().forEach(r -> {
            List list = globalCircuitBreakerMap.computeIfAbsent((SolrRequest.SolrRequestType)((Object)r), k -> new ArrayList());
            list.add(circuitBreaker);
        });
    }

    @VisibleForTesting
    public void deregisterAll() throws IOException {
        this.close();
        CircuitBreakerRegistry.deregisterGlobal();
    }

    @VisibleForTesting
    public static void deregisterGlobal() {
        CircuitBreakerRegistry.closeGlobal();
    }

    public List<CircuitBreaker> checkTripped(SolrRequest.SolrRequestType requestType) {
        Map<SolrRequest.SolrRequestType, List<CircuitBreaker>> combinedMap = this.getCombinedMap();
        List<CircuitBreaker> breakersOfType = combinedMap.get((Object)requestType);
        ArrayList<CircuitBreaker> triggeredCircuitBreakers = null;
        for (CircuitBreaker circuitBreaker : breakersOfType) {
            if (!circuitBreaker.isTripped()) continue;
            if (triggeredCircuitBreakers == null) {
                triggeredCircuitBreakers = new ArrayList<CircuitBreaker>();
            }
            triggeredCircuitBreakers.add(circuitBreaker);
        }
        return triggeredCircuitBreakers;
    }

    public static String toErrorMessage(List<CircuitBreaker> circuitBreakerList) {
        StringBuilder sb = new StringBuilder();
        for (CircuitBreaker circuitBreaker : circuitBreakerList) {
            sb.append(circuitBreaker.getErrorMessage());
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean isEnabled(SolrRequest.SolrRequestType requestType) {
        return this.circuitBreakerMap.containsKey((Object)requestType) || globalCircuitBreakerMap.containsKey((Object)requestType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Map<SolrRequest.SolrRequestType, List<CircuitBreaker>> map = this.circuitBreakerMap;
        synchronized (map) {
            CircuitBreakerRegistry.closeCircuitBreakers(this.circuitBreakerMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
            this.circuitBreakerMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeGlobal() {
        Map<SolrRequest.SolrRequestType, List<CircuitBreaker>> map = globalCircuitBreakerMap;
        synchronized (map) {
            CircuitBreakerRegistry.closeCircuitBreakers(globalCircuitBreakerMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
            globalCircuitBreakerMap.clear();
        }
    }

    private static void closeCircuitBreakers(List<CircuitBreaker> breakers) {
        AtomicInteger closeFailedCounter = new AtomicInteger(0);
        breakers.forEach(it -> {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Closing circuit breaker {} for request type(s) {}", (Object)it.getClass().getSimpleName(), it.getRequestTypes());
                }
                it.close();
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error(String.format(Locale.ROOT, "Failed to close circuit breaker %s for request type(s) %s", it.getClass().getSimpleName(), it.getRequestTypes()), (Throwable)e);
                }
                closeFailedCounter.incrementAndGet();
            }
        });
        if (closeFailedCounter.get() > 0) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to close " + closeFailedCounter.get() + " circuit breakers");
        }
    }

    private Map<SolrRequest.SolrRequestType, List<CircuitBreaker>> getCombinedMap() {
        HashMap<SolrRequest.SolrRequestType, List<CircuitBreaker>> combinedMap = new HashMap<SolrRequest.SolrRequestType, List<CircuitBreaker>>(this.circuitBreakerMap);
        globalCircuitBreakerMap.forEach((k, v) -> combinedMap.merge((SolrRequest.SolrRequestType)((Object)k), (List<CircuitBreaker>)v, (v1, v2) -> {
            ArrayList newList = new ArrayList();
            newList.addAll(v1);
            newList.addAll(v2);
            return newList;
        }));
        return combinedMap;
    }
}

