/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.plugin;

import java.util.Map;
import org.apache.solr.common.ConfigNode;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.util.plugin.AbstractPluginLoader;
import org.apache.solr.util.plugin.MapInitializedPlugin;

public class MapPluginLoader<T extends MapInitializedPlugin>
extends AbstractPluginLoader<T> {
    private final Map<String, T> registry;

    public MapPluginLoader(String name, Class<T> pluginClassType, Map<String, T> map) {
        super(name, pluginClassType);
        this.registry = map;
    }

    @Override
    protected void init(T plugin, ConfigNode node) throws Exception {
        Map<String, String> params = DOMUtil.toMapExcept(node, "name", "class");
        plugin.init(params);
    }

    @Override
    protected T register(String name, T plugin) throws Exception {
        if (this.registry != null) {
            return (T)((MapInitializedPlugin)this.registry.put(name, plugin));
        }
        return null;
    }
}

