/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.tracing;

import io.opentracing.propagation.TextMap;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;

public class HttpServletCarrier
implements TextMap {
    private Iterator<Map.Entry<String, String>> it;

    public HttpServletCarrier(final HttpServletRequest request) {
        this.it = new Iterator<Map.Entry<String, String>>(){
            Enumeration<String> headerNameIt;
            String headerName;
            Enumeration<String> headerValue;
            {
                this.headerNameIt = request.getHeaderNames();
                this.headerName = null;
                this.headerValue = null;
            }

            @Override
            public boolean hasNext() {
                if (this.headerValue != null && this.headerValue.hasMoreElements()) {
                    return true;
                }
                return this.headerNameIt.hasMoreElements();
            }

            @Override
            public Map.Entry<String, String> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.headerValue == null || !this.headerValue.hasMoreElements()) {
                    this.headerName = this.headerNameIt.nextElement();
                    this.headerValue = request.getHeaders(this.headerName);
                }
                final String key = this.headerName;
                final String val = this.headerValue.nextElement();
                return new Map.Entry<String, String>(){

                    @Override
                    public String getKey() {
                        return key;
                    }

                    @Override
                    public String getValue() {
                        return val;
                    }

                    @Override
                    public String setValue(String value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.it;
    }

    @Override
    public void put(String key, String value) {
        throw new UnsupportedOperationException("HttpServletCarrier should only be used with Tracer.extract()");
    }
}

