/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cjk.CJKWidthCharFilter;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.ja.JapaneseCompletionFilter;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;

public class JapaneseCompletionAnalyzer
extends Analyzer {
    private final JapaneseCompletionFilter.Mode mode;
    private final UserDictionary userDict;

    public JapaneseCompletionAnalyzer() {
        this(null, JapaneseCompletionFilter.Mode.INDEX);
    }

    public JapaneseCompletionAnalyzer(UserDictionary userDict, JapaneseCompletionFilter.Mode mode) {
        this.userDict = userDict;
        this.mode = mode;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        JapaneseTokenizer tokenizer = new JapaneseTokenizer(this.userDict, true, true, JapaneseTokenizer.Mode.NORMAL);
        TokenFilter stream = new JapaneseCompletionFilter(tokenizer, this.mode);
        stream = new LowerCaseFilter(stream);
        return new Analyzer.TokenStreamComponents(tokenizer, (TokenStream)stream);
    }

    @Override
    protected Reader initReader(String fieldName, Reader reader) {
        return new CJKWidthCharFilter(reader);
    }

    @Override
    protected Reader initReaderForNormalization(String fieldName, Reader reader) {
        return new CJKWidthCharFilter(reader);
    }
}

