/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.completion;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.ja.completion.CharSequenceUtils;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;

public class KatakanaRomanizer {
    private static final String ROMAJI_MAP_FILE = "romaji_map.txt";
    private static KatakanaRomanizer INSTANCE;
    private final CharsRef[][] keystrokes;
    private final Map<CharsRef, List<CharsRef>> romajiMap;

    public static KatakanaRomanizer getInstance() {
        return INSTANCE;
    }

    private KatakanaRomanizer(CharsRef[][] keystrokes, Map<CharsRef, List<CharsRef>> romajiMap) {
        this.keystrokes = keystrokes;
        this.romajiMap = romajiMap;
    }

    public List<CharsRef> romanize(CharsRef input) {
        int pos;
        MatchedKeystroke matched;
        assert (CharSequenceUtils.isKatakanaOrHWAlphabets(input));
        ArrayList<CharsRefBuilder> pendingOutputs = new ArrayList<CharsRefBuilder>();
        for (pos = 0; pos < input.length && (matched = this.longestKeystrokeMatch(input, pos)) != null; pos += matched.keystrokeLen) {
            List<CharsRef> candidates = this.romajiMap.get(this.keystrokes[matched.keystrokeLen - 1][matched.keystrokeIndex]);
            if (pendingOutputs.size() == 0) {
                for (CharsRef cref : candidates) {
                    CharsRefBuilder output = new CharsRefBuilder();
                    output.copyChars(cref);
                    pendingOutputs.add(output);
                }
                continue;
            }
            if (candidates.size() == 1) {
                CharsRef cref = candidates.get(0);
                for (CharsRefBuilder pdgOutput : pendingOutputs) {
                    pdgOutput.append(cref.chars, 0, cref.length);
                }
                continue;
            }
            ArrayList<CharsRefBuilder> outputs = new ArrayList<CharsRefBuilder>();
            for (CharsRef cref : candidates) {
                for (CharsRefBuilder pdgOutput : pendingOutputs) {
                    CharsRefBuilder buffer = new CharsRefBuilder();
                    buffer.copyChars(pdgOutput.chars(), 0, pdgOutput.length());
                    buffer.append(cref.chars, cref.offset, cref.length);
                    outputs.add(buffer);
                }
            }
            pendingOutputs = outputs;
        }
        if (pos < input.length) {
            for (CharsRefBuilder output : pendingOutputs) {
                output.append(input.chars, pos, input.length - pos);
            }
        }
        return pendingOutputs.stream().map(CharsRefBuilder::get).collect(Collectors.toList());
    }

    private MatchedKeystroke longestKeystrokeMatch(CharsRef input, int inputOffset) {
        for (int len = Math.min(input.length - inputOffset, this.keystrokes.length); len > 0; --len) {
            CharsRef ref = new CharsRef(input.chars, inputOffset, len);
            int index = Arrays.binarySearch(this.keystrokes[len - 1], ref);
            if (index < 0) continue;
            return new MatchedKeystroke(len, index);
        }
        return null;
    }

    static {
        try (InputStreamReader is = new InputStreamReader(KatakanaRomanizer.class.getResourceAsStream(ROMAJI_MAP_FILE), Charset.forName("UTF-8"));
             BufferedReader ir = new BufferedReader(is);){
            String line;
            HashMap<CharsRef, List<CharsRef>> romajiMap = new HashMap<CharsRef, List<CharsRef>>();
            while ((line = ir.readLine()) != null) {
                String[] cols;
                if (line.startsWith("#") || (cols = line.trim().split(",")).length < 2) continue;
                CharsRef prefix = new CharsRef(cols[0]);
                romajiMap.put(prefix, new ArrayList());
                for (int i = 1; i < cols.length; ++i) {
                    ((List)romajiMap.get(prefix)).add(new CharsRef(cols[i]));
                }
            }
            Set keystrokeSet = romajiMap.keySet();
            int maxKeystrokeLength = keystrokeSet.stream().mapToInt(CharsRef::length).max().getAsInt();
            CharsRef[][] keystrokes = new CharsRef[maxKeystrokeLength][];
            int len = 0;
            while (len < maxKeystrokeLength) {
                int l = len++;
                keystrokes[l] = (CharsRef[])keystrokeSet.stream().filter(k -> k.length - 1 == l).toArray(CharsRef[]::new);
            }
            for (Object[] objectArray : keystrokes) {
                Arrays.sort(objectArray);
            }
            INSTANCE = new KatakanaRomanizer(keystrokes, romajiMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class MatchedKeystroke {
        final int keystrokeLen;
        final int keystrokeIndex;

        MatchedKeystroke(int keystrokeLen, int keystrokeIndex) {
            this.keystrokeLen = keystrokeLen;
            this.keystrokeIndex = keystrokeIndex;
        }
    }
}

