/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.lucene.analysis.ko.dict.BinaryDictionary;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.IOSupplier;
import org.apache.lucene.util.IOUtils;

public final class ConnectionCosts {
    public static final String FILENAME_SUFFIX = ".dat";
    public static final String HEADER = "ko_cc";
    public static final int VERSION = 1;
    private final ByteBuffer buffer;
    private final int forwardSize;

    @Deprecated(forRemoval=true, since="9.1")
    public ConnectionCosts(BinaryDictionary.ResourceScheme scheme, String path) throws IOException {
        this(() -> BinaryDictionary.getResource(scheme, path.replace('.', '/') + FILENAME_SUFFIX));
    }

    public ConnectionCosts(Path connectionCostsFile) throws IOException {
        this(() -> Files.newInputStream(connectionCostsFile, new OpenOption[0]));
    }

    public ConnectionCosts(URL connectionCostsUrl) throws IOException {
        this(() -> connectionCostsUrl.openStream());
    }

    private ConnectionCosts() throws IOException {
        this(ConnectionCosts::getClassResource);
    }

    private ConnectionCosts(IOSupplier<InputStream> connectionCostResource) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(connectionCostResource.get());){
            InputStreamDataInput in = new InputStreamDataInput(is);
            CodecUtil.checkHeader(in, HEADER, 1, 1);
            this.forwardSize = in.readVInt();
            int backwardSize = in.readVInt();
            int size = this.forwardSize * backwardSize;
            ByteBuffer tmpBuffer = ByteBuffer.allocateDirect(size * 2);
            int accum = 0;
            for (int j = 0; j < backwardSize; ++j) {
                for (int i = 0; i < this.forwardSize; ++i) {
                    tmpBuffer.putShort((short)(accum += in.readZInt()));
                }
            }
            this.buffer = tmpBuffer.asReadOnlyBuffer();
        }
    }

    private static InputStream getClassResource() throws IOException {
        String resourcePath = ConnectionCosts.class.getSimpleName() + FILENAME_SUFFIX;
        return IOUtils.requireResourceNonNull(ConnectionCosts.class.getResourceAsStream(resourcePath), resourcePath);
    }

    public int get(int forwardId, int backwardId) {
        int offset = (backwardId * this.forwardSize + forwardId) * 2;
        return this.buffer.getShort(offset);
    }

    public static ConnectionCosts getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        static final ConnectionCosts INSTANCE;

        private SingletonHolder() {
        }

        static {
            try {
                INSTANCE = new ConnectionCosts();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Cannot load ConnectionCosts.", ioe);
            }
        }
    }
}

