/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.phonetic;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.PhoneticEngine;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.IgnoreRandomChains;

@IgnoreRandomChains(reason="LUCENE-10360: cannot handle empty tokens (or those only dashes and whitespace)")
public final class BeiderMorseFilter
extends TokenFilter {
    private final PhoneticEngine engine;
    private final Languages.LanguageSet languages;
    private static final Pattern pattern = Pattern.compile("([^()|-]+)");
    private final Matcher matcher = pattern.matcher("");
    private String encoded;
    private AttributeSource.State state;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncAtt = this.addAttribute(PositionIncrementAttribute.class);

    public BeiderMorseFilter(TokenStream input, PhoneticEngine engine) {
        this(input, engine, null);
    }

    @IgnoreRandomChains(reason="LUCENE-10352: Add support for LanguageSet randomization")
    public BeiderMorseFilter(TokenStream input, PhoneticEngine engine, Languages.LanguageSet languages) {
        super(input);
        this.engine = engine;
        this.languages = languages;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.matcher.find()) {
            assert (this.state != null && this.encoded != null);
            this.restoreState(this.state);
            this.termAtt.setEmpty().append(this.encoded, this.matcher.start(1), this.matcher.end(1));
            this.posIncAtt.setPositionIncrement(0);
            return true;
        }
        if (this.input.incrementToken()) {
            this.encoded = this.languages == null ? this.engine.encode(this.termAtt.toString()) : this.engine.encode(this.termAtt.toString(), this.languages);
            this.state = this.captureState();
            this.matcher.reset(this.encoded);
            if (this.matcher.find()) {
                this.termAtt.setEmpty().append(this.encoded, this.matcher.start(1), this.matcher.end(1));
            }
            return true;
        }
        return false;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.matcher.reset("");
    }
}

