/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.classification.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.FuzzyTermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;

public class NearestFuzzyQuery
extends Query {
    private final ArrayList<FieldVals> fieldVals = new ArrayList();
    private final Analyzer analyzer;
    private static final int MAX_VARIANTS_PER_TERM = 50;
    private static final float MIN_SIMILARITY = 1.0f;
    private static final int PREFIX_LENGTH = 2;
    private static final int MAX_NUM_TERMS = 300;

    public NearestFuzzyQuery(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void addTerms(String queryString, String fieldName) {
        int maxEdits = 1;
        if ((float)maxEdits != 1.0f) {
            throw new IllegalArgumentException("MIN_SIMILARITY must integer value between 0 and 2, inclusive; got 1.0");
        }
        this.fieldVals.add(new FieldVals(fieldName, maxEdits, queryString));
    }

    private void addTerms(IndexReader reader, FieldVals f, ScoreTermQueue q) throws IOException {
        if (f.queryString == null) {
            return;
        }
        Terms terms = MultiTerms.getTerms(reader, f.fieldName);
        if (terms == null) {
            return;
        }
        try (TokenStream ts = this.analyzer.tokenStream(f.fieldName, f.queryString);){
            CharTermAttribute termAtt = ts.addAttribute(CharTermAttribute.class);
            int corpusNumDocs = reader.numDocs();
            HashSet<String> processedTerms = new HashSet<String>();
            ts.reset();
            while (ts.incrementToken()) {
                BytesRef possibleMatch;
                String term = termAtt.toString();
                if (processedTerms.contains(term)) continue;
                processedTerms.add(term);
                ScoreTermQueue variantsQ = new ScoreTermQueue(50);
                float minScore = 0.0f;
                Term startTerm = new Term(f.fieldName, term);
                FuzzyTermsEnum fe = new FuzzyTermsEnum(terms, startTerm, f.maxEdits, f.prefixLength, true);
                int df = reader.docFreq(startTerm);
                int numVariants = 0;
                int totalVariantDocFreqs = 0;
                while ((possibleMatch = fe.next()) != null) {
                    ++numVariants;
                    totalVariantDocFreqs += fe.docFreq();
                    float score = fe.getBoost();
                    if (variantsQ.size() < 50 || score > minScore) {
                        ScoreTerm st = new ScoreTerm(new Term(startTerm.field(), BytesRef.deepCopyOf(possibleMatch)), score, startTerm);
                        variantsQ.insertWithOverflow(st);
                        minScore = ((ScoreTerm)variantsQ.top()).score;
                    }
                    fe.setMaxNonCompetitiveBoost(variantsQ.size() >= 50 ? minScore : Float.NEGATIVE_INFINITY);
                }
                if (numVariants <= 0) continue;
                int avgDf = totalVariantDocFreqs / numVariants;
                if (df == 0) {
                    df = avgDf;
                }
                int size = variantsQ.size();
                for (int i = 0; i < size; ++i) {
                    ScoreTerm st = (ScoreTerm)variantsQ.pop();
                    if (st == null) continue;
                    st.score = st.score * st.score * this.idf(df, corpusNumDocs);
                    q.insertWithOverflow(st);
                }
            }
            ts.end();
        }
    }

    private float idf(int docFreq, int docCount) {
        return (float)(Math.log((double)(docCount + 1) / (double)(docFreq + 1)) + 1.0);
    }

    private Query newTermQuery(IndexReader reader, Term term) throws IOException {
        TermStates termStates = new TermStates(reader.getContext());
        for (LeafReaderContext leafContext : reader.leaves()) {
            Terms terms = Terms.getTerms(leafContext.reader(), term.field());
            TermsEnum termsEnum = terms.iterator();
            if (!termsEnum.seekExact(term.bytes())) continue;
            int freq = 1 - termStates.docFreq();
            termStates.register(termsEnum.termState(), leafContext.ord, freq, freq);
        }
        return new TermQuery(term, termStates);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        IndexReader reader = indexSearcher.getIndexReader();
        ScoreTermQueue q = new ScoreTermQueue(300);
        for (FieldVals f : this.fieldVals) {
            this.addTerms(reader, f, q);
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        HashMap<Term, ArrayList> variantQueries = new HashMap<Term, ArrayList>();
        int size = q.size();
        for (int i = 0; i < size; ++i) {
            ScoreTerm st = (ScoreTerm)q.pop();
            if (st == null) continue;
            ArrayList l = variantQueries.computeIfAbsent(st.fuzziedSourceTerm, k -> new ArrayList());
            l.add(st);
        }
        for (ArrayList variants : variantQueries.values()) {
            if (variants.size() == 1) {
                ScoreTerm st = (ScoreTerm)variants.get(0);
                Query tq = this.newTermQuery(reader, st.term);
                bq.add(new BoostQuery(tq, st.score), BooleanClause.Occur.SHOULD);
                continue;
            }
            BooleanQuery.Builder termVariants = new BooleanQuery.Builder();
            for (ScoreTerm st : variants) {
                Query tq = this.newTermQuery(reader, st.term);
                termVariants.add(new BoostQuery(tq, st.score), BooleanClause.Occur.SHOULD);
            }
            bq.add(termVariants.build(), BooleanClause.Occur.SHOULD);
        }
        return bq.build();
    }

    @Override
    public String toString(String field) {
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = prime * result + Objects.hashCode(this.analyzer);
        result = prime * result + Objects.hashCode(this.fieldVals);
        return result;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((NearestFuzzyQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(NearestFuzzyQuery other) {
        return Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.fieldVals, other.fieldVals);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }

    private static class ScoreTermQueue
    extends PriorityQueue<ScoreTerm> {
        ScoreTermQueue(int size) {
            super(size);
        }

        @Override
        protected boolean lessThan(ScoreTerm termA, ScoreTerm termB) {
            if (termA.score == termB.score) {
                return termA.term.compareTo(termB.term) > 0;
            }
            return termA.score < termB.score;
        }
    }

    private static class ScoreTerm {
        public final Term term;
        public float score;
        final Term fuzziedSourceTerm;

        ScoreTerm(Term term, float score, Term fuzziedSourceTerm) {
            this.term = term;
            this.score = score;
            this.fuzziedSourceTerm = fuzziedSourceTerm;
        }
    }

    static class FieldVals {
        final String queryString;
        final String fieldName;
        final int maxEdits;
        final int prefixLength;

        FieldVals(String name, int maxEdits, String queryString) {
            this.fieldName = name;
            this.maxEdits = maxEdits;
            this.queryString = queryString;
            this.prefixLength = 2;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
            result = 31 * result + this.maxEdits;
            result = 31 * result + this.prefixLength;
            result = 31 * result + (this.queryString == null ? 0 : this.queryString.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldVals other = (FieldVals)obj;
            if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
                return false;
            }
            if (this.maxEdits != other.maxEdits) {
                return false;
            }
            if (this.prefixLength != other.prefixLength) {
                return false;
            }
            if (this.queryString == null) {
                return other.queryString == null;
            }
            return this.queryString.equals(other.queryString);
        }
    }
}

