/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;

class SimpleTextDocValuesWriter
extends DocValuesConsumer {
    static final BytesRef END = new BytesRef("END");
    static final BytesRef FIELD = new BytesRef("field ");
    static final BytesRef TYPE = new BytesRef("  type ");
    static final BytesRef MINVALUE = new BytesRef("  minvalue ");
    static final BytesRef PATTERN = new BytesRef("  pattern ");
    static final BytesRef LENGTH = new BytesRef("length ");
    static final BytesRef MAXLENGTH = new BytesRef("  maxlength ");
    static final BytesRef NUMVALUES = new BytesRef("  numvalues ");
    static final BytesRef ORDPATTERN = new BytesRef("  ordpattern ");
    IndexOutput data;
    final BytesRefBuilder scratch = new BytesRefBuilder();
    final int numDocs;
    private final Set<String> fieldsSeen = new HashSet<String>();

    public SimpleTextDocValuesWriter(SegmentWriteState state, String ext) throws IOException {
        this.data = state.directory.createOutput(IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, ext), state.context);
        this.numDocs = state.segmentInfo.maxDoc();
    }

    private boolean fieldSeen(String field) {
        assert (!this.fieldsSeen.contains(field)) : "field \"" + field + "\" was added more than once during flush";
        this.fieldsSeen.add(field);
        return true;
    }

    @Override
    public void addNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        assert (this.fieldSeen(field.name));
        assert (field.getDocValuesType() == DocValuesType.NUMERIC || field.hasNorms());
        this.writeFieldEntry(field, DocValuesType.NUMERIC);
        long minValue = Long.MAX_VALUE;
        long maxValue = Long.MIN_VALUE;
        NumericDocValues values = valuesProducer.getNumeric(field);
        int numValues = 0;
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            long v = values.longValue();
            minValue = Math.min(minValue, v);
            maxValue = Math.max(maxValue, v);
            ++numValues;
            doc = values.nextDoc();
        }
        if (numValues != this.numDocs) {
            minValue = Math.min(minValue, 0L);
            maxValue = Math.max(maxValue, 0L);
        }
        SimpleTextUtil.write(this.data, MINVALUE);
        SimpleTextUtil.write(this.data, Long.toString(minValue), this.scratch);
        SimpleTextUtil.writeNewline(this.data);
        BigInteger maxBig = BigInteger.valueOf(maxValue);
        BigInteger minBig = BigInteger.valueOf(minValue);
        BigInteger diffBig = maxBig.subtract(minBig);
        int maxBytesPerValue = diffBig.toString().length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < maxBytesPerValue; ++i) {
            sb.append('0');
        }
        SimpleTextUtil.write(this.data, PATTERN);
        SimpleTextUtil.write(this.data, sb.toString(), this.scratch);
        SimpleTextUtil.writeNewline(this.data);
        String patternString = sb.toString();
        DecimalFormat encoder = new DecimalFormat(patternString, new DecimalFormatSymbols(Locale.ROOT));
        int numDocsWritten = 0;
        values = valuesProducer.getNumeric(field);
        for (int i = 0; i < this.numDocs; ++i) {
            long value;
            if (values.docID() < i) {
                values.nextDoc();
                assert (values.docID() >= i);
            }
            long l = value = values.docID() != i ? 0L : values.longValue();
            assert (value >= minValue);
            BigInteger delta = BigInteger.valueOf(value).subtract(BigInteger.valueOf(minValue));
            String s = encoder.format(delta);
            assert (s.length() == patternString.length());
            SimpleTextUtil.write(this.data, s, this.scratch);
            SimpleTextUtil.writeNewline(this.data);
            if (values.docID() != i) {
                SimpleTextUtil.write(this.data, "F", this.scratch);
            } else {
                SimpleTextUtil.write(this.data, "T", this.scratch);
            }
            SimpleTextUtil.writeNewline(this.data);
            assert (++numDocsWritten <= this.numDocs);
        }
        assert (this.numDocs == numDocsWritten) : "numDocs=" + this.numDocs + " numDocsWritten=" + numDocsWritten;
    }

    @Override
    public void addBinaryField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        assert (this.fieldSeen(field.name));
        assert (field.getDocValuesType() == DocValuesType.BINARY);
        this.doAddBinaryField(field, valuesProducer);
    }

    private void doAddBinaryField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        int maxLength = 0;
        BinaryDocValues values = valuesProducer.getBinary(field);
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            maxLength = Math.max(maxLength, values.binaryValue().length);
            doc = values.nextDoc();
        }
        this.writeFieldEntry(field, DocValuesType.BINARY);
        SimpleTextUtil.write(this.data, MAXLENGTH);
        SimpleTextUtil.write(this.data, Integer.toString(maxLength), this.scratch);
        SimpleTextUtil.writeNewline(this.data);
        int maxBytesLength = Long.toString(maxLength).length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < maxBytesLength; ++i) {
            sb.append('0');
        }
        SimpleTextUtil.write(this.data, PATTERN);
        SimpleTextUtil.write(this.data, sb.toString(), this.scratch);
        SimpleTextUtil.writeNewline(this.data);
        DecimalFormat encoder = new DecimalFormat(sb.toString(), new DecimalFormatSymbols(Locale.ROOT));
        values = valuesProducer.getBinary(field);
        int numDocsWritten = 0;
        for (int i = 0; i < this.numDocs; ++i) {
            if (values.docID() < i) {
                values.nextDoc();
                assert (values.docID() >= i);
            }
            int length = values.docID() != i ? 0 : values.binaryValue().length;
            SimpleTextUtil.write(this.data, LENGTH);
            SimpleTextUtil.write(this.data, encoder.format(length), this.scratch);
            SimpleTextUtil.writeNewline(this.data);
            if (values.docID() == i) {
                BytesRef value = values.binaryValue();
                this.data.writeBytes(value.bytes, value.offset, value.length);
            }
            for (int j = length; j < maxLength; ++j) {
                this.data.writeByte((byte)32);
            }
            SimpleTextUtil.writeNewline(this.data);
            if (values.docID() != i) {
                SimpleTextUtil.write(this.data, "F", this.scratch);
            } else {
                SimpleTextUtil.write(this.data, "T", this.scratch);
            }
            SimpleTextUtil.writeNewline(this.data);
            ++numDocsWritten;
        }
        assert (this.numDocs == numDocsWritten);
    }

    @Override
    public void addSortedField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        int i;
        assert (this.fieldSeen(field.name));
        assert (field.getDocValuesType() == DocValuesType.SORTED);
        this.writeFieldEntry(field, DocValuesType.SORTED);
        int valueCount = 0;
        int maxLength = -1;
        TermsEnum terms = valuesProducer.getSorted(field).termsEnum();
        BytesRef value = terms.next();
        while (value != null) {
            maxLength = Math.max(maxLength, value.length);
            ++valueCount;
            value = terms.next();
        }
        SimpleTextUtil.write(this.data, NUMVALUES);
        SimpleTextUtil.write(this.data, Integer.toString(valueCount), this.scratch);
        SimpleTextUtil.writeNewline(this.data);
        SimpleTextUtil.write(this.data, MAXLENGTH);
        SimpleTextUtil.write(this.data, Integer.toString(maxLength), this.scratch);
        SimpleTextUtil.writeNewline(this.data);
        int maxBytesLength = Integer.toString(maxLength).length();
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < maxBytesLength; ++i2) {
            sb.append('0');
        }
        SimpleTextUtil.write(this.data, PATTERN);
        SimpleTextUtil.write(this.data, sb.toString(), this.scratch);
        SimpleTextUtil.writeNewline(this.data);
        DecimalFormat encoder = new DecimalFormat(sb.toString(), new DecimalFormatSymbols(Locale.ROOT));
        int maxOrdBytes = Long.toString((long)valueCount + 1L).length();
        sb.setLength(0);
        for (int i3 = 0; i3 < maxOrdBytes; ++i3) {
            sb.append('0');
        }
        SimpleTextUtil.write(this.data, ORDPATTERN);
        SimpleTextUtil.write(this.data, sb.toString(), this.scratch);
        SimpleTextUtil.writeNewline(this.data);
        DecimalFormat ordEncoder = new DecimalFormat(sb.toString(), new DecimalFormatSymbols(Locale.ROOT));
        int valuesSeen = 0;
        terms = valuesProducer.getSorted(field).termsEnum();
        BytesRef value2 = terms.next();
        while (value2 != null) {
            SimpleTextUtil.write(this.data, LENGTH);
            SimpleTextUtil.write(this.data, encoder.format(value2.length), this.scratch);
            SimpleTextUtil.writeNewline(this.data);
            this.data.writeBytes(value2.bytes, value2.offset, value2.length);
            for (i = value2.length; i < maxLength; ++i) {
                this.data.writeByte((byte)32);
            }
            SimpleTextUtil.writeNewline(this.data);
            assert (++valuesSeen <= valueCount);
            value2 = terms.next();
        }
        assert (valuesSeen == valueCount);
        SortedDocValues values = valuesProducer.getSorted(field);
        for (i = 0; i < this.numDocs; ++i) {
            if (values.docID() < i) {
                values.nextDoc();
                assert (values.docID() >= i);
            }
            int ord = -1;
            if (values.docID() == i) {
                ord = values.ordValue();
            }
            SimpleTextUtil.write(this.data, ordEncoder.format((long)ord + 1L), this.scratch);
            SimpleTextUtil.writeNewline(this.data);
        }
    }

    @Override
    public void addSortedNumericField(FieldInfo field, final DocValuesProducer valuesProducer) throws IOException {
        assert (this.fieldSeen(field.name));
        assert (field.getDocValuesType() == DocValuesType.SORTED_NUMERIC);
        this.doAddBinaryField(field, new EmptyDocValuesProducer(){

            @Override
            public BinaryDocValues getBinary(FieldInfo field) throws IOException {
                final SortedNumericDocValues values = valuesProducer.getSortedNumeric(field);
                return new BinaryDocValues(){
                    final StringBuilder builder = new StringBuilder();
                    BytesRef binaryValue;

                    @Override
                    public int nextDoc() throws IOException {
                        int doc = values.nextDoc();
                        this.setCurrentDoc();
                        return doc;
                    }

                    @Override
                    public int docID() {
                        return values.docID();
                    }

                    @Override
                    public long cost() {
                        return values.cost();
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        int doc = values.advance(target);
                        this.setCurrentDoc();
                        return doc;
                    }

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        if (values.advanceExact(target)) {
                            this.setCurrentDoc();
                            return true;
                        }
                        return false;
                    }

                    private void setCurrentDoc() throws IOException {
                        if (this.docID() == Integer.MAX_VALUE) {
                            return;
                        }
                        this.builder.setLength(0);
                        int count = values.docValueCount();
                        for (int i = 0; i < count; ++i) {
                            if (i > 0) {
                                this.builder.append(',');
                            }
                            this.builder.append(Long.toString(values.nextValue()));
                        }
                        this.binaryValue = new BytesRef(this.builder.toString());
                    }

                    @Override
                    public BytesRef binaryValue() throws IOException {
                        return this.binaryValue;
                    }
                };
            }
        });
    }

    @Override
    public void addSortedSetField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        assert (this.fieldSeen(field.name));
        assert (field.getDocValuesType() == DocValuesType.SORTED_SET);
        this.writeFieldEntry(field, DocValuesType.SORTED_SET);
        long valueCount = 0L;
        int maxLength = 0;
        TermsEnum terms = valuesProducer.getSortedSet(field).termsEnum();
        BytesRef value = terms.next();
        while (value != null) {
            maxLength = Math.max(maxLength, value.length);
            ++valueCount;
            value = terms.next();
        }
        SimpleTextUtil.write(this.data, NUMVALUES);
        SimpleTextUtil.write(this.data, Long.toString(valueCount), this.scratch);
        SimpleTextUtil.writeNewline(this.data);
        SimpleTextUtil.write(this.data, MAXLENGTH);
        SimpleTextUtil.write(this.data, Integer.toString(maxLength), this.scratch);
        SimpleTextUtil.writeNewline(this.data);
        int maxBytesLength = Integer.toString(maxLength).length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < maxBytesLength; ++i) {
            sb.append('0');
        }
        SimpleTextUtil.write(this.data, PATTERN);
        SimpleTextUtil.write(this.data, sb.toString(), this.scratch);
        SimpleTextUtil.writeNewline(this.data);
        DecimalFormat encoder = new DecimalFormat(sb.toString(), new DecimalFormatSymbols(Locale.ROOT));
        int maxOrdListLength = 0;
        StringBuilder sb2 = new StringBuilder();
        SortedSetDocValues values = valuesProducer.getSortedSet(field);
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            sb2.setLength(0);
            for (int i = 0; i < values.docValueCount(); ++i) {
                if (sb2.length() > 0) {
                    sb2.append(",");
                }
                sb2.append(Long.toString(values.nextOrd()));
            }
            maxOrdListLength = Math.max(maxOrdListLength, sb2.length());
            doc = values.nextDoc();
        }
        sb2.setLength(0);
        for (int i = 0; i < maxOrdListLength; ++i) {
            sb2.append('X');
        }
        SimpleTextUtil.write(this.data, ORDPATTERN);
        SimpleTextUtil.write(this.data, sb2.toString(), this.scratch);
        SimpleTextUtil.writeNewline(this.data);
        long valuesSeen = 0L;
        terms = valuesProducer.getSortedSet(field).termsEnum();
        BytesRef value2 = terms.next();
        while (value2 != null) {
            SimpleTextUtil.write(this.data, LENGTH);
            SimpleTextUtil.write(this.data, encoder.format(value2.length), this.scratch);
            SimpleTextUtil.writeNewline(this.data);
            this.data.writeBytes(value2.bytes, value2.offset, value2.length);
            for (int i = value2.length; i < maxLength; ++i) {
                this.data.writeByte((byte)32);
            }
            SimpleTextUtil.writeNewline(this.data);
            assert (++valuesSeen <= valueCount);
            value2 = terms.next();
        }
        assert (valuesSeen == valueCount);
        values = valuesProducer.getSortedSet(field);
        for (int i = 0; i < this.numDocs; ++i) {
            if (values.docID() < i) {
                values.nextDoc();
                assert (values.docID() >= i);
            }
            sb2.setLength(0);
            if (values.docID() == i) {
                for (int j = 0; j < values.docValueCount(); ++j) {
                    if (sb2.length() > 0) {
                        sb2.append(",");
                    }
                    sb2.append(Long.toString(values.nextOrd()));
                }
            }
            int numPadding = maxOrdListLength - sb2.length();
            for (int j = 0; j < numPadding; ++j) {
                sb2.append(' ');
            }
            SimpleTextUtil.write(this.data, sb2.toString(), this.scratch);
            SimpleTextUtil.writeNewline(this.data);
        }
    }

    private void writeFieldEntry(FieldInfo field, DocValuesType type) throws IOException {
        SimpleTextUtil.write(this.data, FIELD);
        SimpleTextUtil.write(this.data, field.name, this.scratch);
        SimpleTextUtil.writeNewline(this.data);
        SimpleTextUtil.write(this.data, TYPE);
        SimpleTextUtil.write(this.data, type.toString(), this.scratch);
        SimpleTextUtil.writeNewline(this.data);
    }

    @Override
    public void close() throws IOException {
        block6: {
            block7: {
                block5: {
                    if (this.data == null) break block6;
                    boolean success = false;
                    try {
                        assert (!this.fieldsSeen.isEmpty());
                        SimpleTextUtil.write(this.data, END);
                        SimpleTextUtil.writeNewline(this.data);
                        SimpleTextUtil.writeChecksum(this.data, this.scratch);
                        success = true;
                        if (!success) break block5;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            IOUtils.close(this.data);
                        } else {
                            IOUtils.closeWhileHandlingException(this.data);
                        }
                        this.data = null;
                        throw throwable;
                    }
                    IOUtils.close(this.data);
                    break block7;
                }
                IOUtils.closeWhileHandlingException(this.data);
            }
            this.data = null;
        }
    }
}

