/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;

public class SimpleTextFieldInfosFormat
extends FieldInfosFormat {
    static final String FIELD_INFOS_EXTENSION = "inf";
    static final BytesRef NUMFIELDS = new BytesRef("number of fields ");
    static final BytesRef NAME = new BytesRef("  name ");
    static final BytesRef NUMBER = new BytesRef("  number ");
    static final BytesRef STORETV = new BytesRef("  term vectors ");
    static final BytesRef STORETVPOS = new BytesRef("  term vector positions ");
    static final BytesRef STORETVOFF = new BytesRef("  term vector offsets ");
    static final BytesRef PAYLOADS = new BytesRef("  payloads ");
    static final BytesRef NORMS = new BytesRef("  norms ");
    static final BytesRef DOCVALUES = new BytesRef("  doc values ");
    static final BytesRef DOCVALUES_GEN = new BytesRef("  doc values gen ");
    static final BytesRef INDEXOPTIONS = new BytesRef("  index options ");
    static final BytesRef NUM_ATTS = new BytesRef("  attributes ");
    static final BytesRef ATT_KEY = new BytesRef("    key ");
    static final BytesRef ATT_VALUE = new BytesRef("    value ");
    static final BytesRef DATA_DIM_COUNT = new BytesRef("  data dimensional count ");
    static final BytesRef INDEX_DIM_COUNT = new BytesRef("  index dimensional count ");
    static final BytesRef DIM_NUM_BYTES = new BytesRef("  dimensional num bytes ");
    static final BytesRef VECTOR_NUM_DIMS = new BytesRef("  vector number of dimensions ");
    static final BytesRef VECTOR_ENCODING = new BytesRef("  vector encoding ");
    static final BytesRef VECTOR_SIMILARITY = new BytesRef("  vector similarity ");
    static final BytesRef SOFT_DELETES = new BytesRef("  soft-deletes ");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldInfos read(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, IOContext iocontext) throws IOException {
        FieldInfos fieldInfos;
        block26: {
            ChecksumIndexInput input;
            block25: {
                String fileName = IndexFileNames.segmentFileName(segmentInfo.name, segmentSuffix, FIELD_INFOS_EXTENSION);
                input = directory.openChecksumInput(fileName, iocontext);
                BytesRefBuilder scratch = new BytesRefBuilder();
                boolean success = false;
                try {
                    SimpleTextUtil.readLine(input, scratch);
                    assert (StringHelper.startsWith(scratch.get(), NUMFIELDS));
                    int size = Integer.parseInt(this.readString(SimpleTextFieldInfosFormat.NUMFIELDS.length, scratch));
                    FieldInfo[] infos = new FieldInfo[size];
                    for (int i = 0; i < size; ++i) {
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch.get(), NAME));
                        String name = this.readString(SimpleTextFieldInfosFormat.NAME.length, scratch);
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch.get(), NUMBER));
                        int fieldNumber = Integer.parseInt(this.readString(SimpleTextFieldInfosFormat.NUMBER.length, scratch));
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch.get(), INDEXOPTIONS));
                        String s = this.readString(SimpleTextFieldInfosFormat.INDEXOPTIONS.length, scratch);
                        IndexOptions indexOptions = IndexOptions.valueOf(s);
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch.get(), STORETV));
                        boolean storeTermVector = Boolean.parseBoolean(this.readString(SimpleTextFieldInfosFormat.STORETV.length, scratch));
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch.get(), PAYLOADS));
                        boolean storePayloads = Boolean.parseBoolean(this.readString(SimpleTextFieldInfosFormat.PAYLOADS.length, scratch));
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch.get(), NORMS));
                        boolean omitNorms = !Boolean.parseBoolean(this.readString(SimpleTextFieldInfosFormat.NORMS.length, scratch));
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch.get(), DOCVALUES));
                        String dvType = this.readString(SimpleTextFieldInfosFormat.DOCVALUES.length, scratch);
                        DocValuesType docValuesType = this.docValuesType(dvType);
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch.get(), DOCVALUES_GEN));
                        long dvGen = Long.parseLong(this.readString(SimpleTextFieldInfosFormat.DOCVALUES_GEN.length, scratch));
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch.get(), NUM_ATTS));
                        int numAtts = Integer.parseInt(this.readString(SimpleTextFieldInfosFormat.NUM_ATTS.length, scratch));
                        HashMap<String, String> atts = new HashMap<String, String>();
                        for (int j = 0; j < numAtts; ++j) {
                            SimpleTextUtil.readLine(input, scratch);
                            assert (StringHelper.startsWith(scratch.get(), ATT_KEY));
                            String key = this.readString(SimpleTextFieldInfosFormat.ATT_KEY.length, scratch);
                            SimpleTextUtil.readLine(input, scratch);
                            assert (StringHelper.startsWith(scratch.get(), ATT_VALUE));
                            String value = this.readString(SimpleTextFieldInfosFormat.ATT_VALUE.length, scratch);
                            atts.put(key, value);
                        }
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch.get(), DATA_DIM_COUNT));
                        int dimensionalCount = Integer.parseInt(this.readString(SimpleTextFieldInfosFormat.DATA_DIM_COUNT.length, scratch));
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch.get(), INDEX_DIM_COUNT));
                        int indexDimensionalCount = Integer.parseInt(this.readString(SimpleTextFieldInfosFormat.INDEX_DIM_COUNT.length, scratch));
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch.get(), DIM_NUM_BYTES));
                        int dimensionalNumBytes = Integer.parseInt(this.readString(SimpleTextFieldInfosFormat.DIM_NUM_BYTES.length, scratch));
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch.get(), VECTOR_NUM_DIMS));
                        int vectorNumDimensions = Integer.parseInt(this.readString(SimpleTextFieldInfosFormat.VECTOR_NUM_DIMS.length, scratch));
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch.get(), VECTOR_ENCODING));
                        String encoding = this.readString(SimpleTextFieldInfosFormat.VECTOR_ENCODING.length, scratch);
                        VectorEncoding vectorEncoding = this.vectorEncoding(encoding);
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch.get(), VECTOR_SIMILARITY));
                        String scoreFunction = this.readString(SimpleTextFieldInfosFormat.VECTOR_SIMILARITY.length, scratch);
                        VectorSimilarityFunction vectorDistFunc = this.distanceFunction(scoreFunction);
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch.get(), SOFT_DELETES));
                        boolean isSoftDeletesField = Boolean.parseBoolean(this.readString(SimpleTextFieldInfosFormat.SOFT_DELETES.length, scratch));
                        infos[i] = new FieldInfo(name, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, docValuesType, dvGen, Collections.unmodifiableMap(atts), dimensionalCount, indexDimensionalCount, dimensionalNumBytes, vectorNumDimensions, vectorEncoding, vectorDistFunc, isSoftDeletesField);
                    }
                    SimpleTextUtil.checkFooter(input);
                    FieldInfos fieldInfos2 = new FieldInfos(infos);
                    success = true;
                    fieldInfos = fieldInfos2;
                    if (!success) break block25;
                }
                catch (Throwable throwable) {
                    if (success) {
                        input.close();
                    } else {
                        IOUtils.closeWhileHandlingException(input);
                    }
                    throw throwable;
                }
                input.close();
                break block26;
            }
            IOUtils.closeWhileHandlingException(input);
        }
        return fieldInfos;
    }

    public DocValuesType docValuesType(String dvType) {
        return DocValuesType.valueOf(dvType);
    }

    public VectorEncoding vectorEncoding(String vectorEncoding) {
        return VectorEncoding.valueOf(vectorEncoding);
    }

    public VectorSimilarityFunction distanceFunction(String scoreFunction) {
        return VectorSimilarityFunction.valueOf(scoreFunction);
    }

    private String readString(int offset, BytesRefBuilder scratch) {
        return new String(scratch.bytes(), offset, scratch.length() - offset, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, FieldInfos infos, IOContext context) throws IOException {
        block9: {
            IndexOutput out;
            block8: {
                String fileName = IndexFileNames.segmentFileName(segmentInfo.name, segmentSuffix, FIELD_INFOS_EXTENSION);
                out = directory.createOutput(fileName, context);
                BytesRefBuilder scratch = new BytesRefBuilder();
                boolean success = false;
                try {
                    SimpleTextUtil.write(out, NUMFIELDS);
                    SimpleTextUtil.write(out, Integer.toString(infos.size()), scratch);
                    SimpleTextUtil.writeNewline(out);
                    for (FieldInfo fi : infos) {
                        SimpleTextUtil.write(out, NAME);
                        SimpleTextUtil.write(out, fi.name, scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, NUMBER);
                        SimpleTextUtil.write(out, Integer.toString(fi.number), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, INDEXOPTIONS);
                        IndexOptions indexOptions = fi.getIndexOptions();
                        assert (indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 || !fi.hasPayloads());
                        SimpleTextUtil.write(out, indexOptions.toString(), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, STORETV);
                        SimpleTextUtil.write(out, Boolean.toString(fi.hasVectors()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, PAYLOADS);
                        SimpleTextUtil.write(out, Boolean.toString(fi.hasPayloads()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, NORMS);
                        SimpleTextUtil.write(out, Boolean.toString(!fi.omitsNorms()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, DOCVALUES);
                        SimpleTextUtil.write(out, SimpleTextFieldInfosFormat.getDocValuesType(fi.getDocValuesType()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, DOCVALUES_GEN);
                        SimpleTextUtil.write(out, Long.toString(fi.getDocValuesGen()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        Map<String, String> atts = fi.attributes();
                        int numAtts = atts == null ? 0 : atts.size();
                        SimpleTextUtil.write(out, NUM_ATTS);
                        SimpleTextUtil.write(out, Integer.toString(numAtts), scratch);
                        SimpleTextUtil.writeNewline(out);
                        if (numAtts > 0) {
                            for (Map.Entry<String, String> entry : atts.entrySet()) {
                                SimpleTextUtil.write(out, ATT_KEY);
                                SimpleTextUtil.write(out, entry.getKey(), scratch);
                                SimpleTextUtil.writeNewline(out);
                                SimpleTextUtil.write(out, ATT_VALUE);
                                SimpleTextUtil.write(out, entry.getValue(), scratch);
                                SimpleTextUtil.writeNewline(out);
                            }
                        }
                        SimpleTextUtil.write(out, DATA_DIM_COUNT);
                        SimpleTextUtil.write(out, Integer.toString(fi.getPointDimensionCount()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, INDEX_DIM_COUNT);
                        SimpleTextUtil.write(out, Integer.toString(fi.getPointIndexDimensionCount()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, DIM_NUM_BYTES);
                        SimpleTextUtil.write(out, Integer.toString(fi.getPointNumBytes()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, VECTOR_NUM_DIMS);
                        SimpleTextUtil.write(out, Integer.toString(fi.getVectorDimension()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, VECTOR_ENCODING);
                        SimpleTextUtil.write(out, fi.getVectorEncoding().name(), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, VECTOR_SIMILARITY);
                        SimpleTextUtil.write(out, fi.getVectorSimilarityFunction().name(), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, SOFT_DELETES);
                        SimpleTextUtil.write(out, Boolean.toString(fi.isSoftDeletesField()), scratch);
                        SimpleTextUtil.writeNewline(out);
                    }
                    SimpleTextUtil.writeChecksum(out, scratch);
                    success = true;
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) {
                        out.close();
                    } else {
                        IOUtils.closeWhileHandlingException(out);
                    }
                    throw throwable;
                }
                out.close();
                break block9;
            }
            IOUtils.closeWhileHandlingException(out);
        }
    }

    private static String getDocValuesType(DocValuesType type) {
        return type.toString();
    }
}

