/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import org.apache.lucene.codecs.NormsConsumer;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.simpletext.SimpleTextDocValuesReader;
import org.apache.lucene.codecs.simpletext.SimpleTextDocValuesWriter;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

public class SimpleTextNormsFormat
extends NormsFormat {
    private static final String NORMS_SEG_EXTENSION = "len";

    @Override
    public NormsConsumer normsConsumer(SegmentWriteState state) throws IOException {
        return new SimpleTextNormsConsumer(state);
    }

    @Override
    public NormsProducer normsProducer(SegmentReadState state) throws IOException {
        return new SimpleTextNormsProducer(state);
    }

    public static class SimpleTextNormsConsumer
    extends NormsConsumer {
        private final SimpleTextDocValuesWriter impl;

        public SimpleTextNormsConsumer(SegmentWriteState state) throws IOException {
            this.impl = new SimpleTextDocValuesWriter(state, SimpleTextNormsFormat.NORMS_SEG_EXTENSION);
        }

        @Override
        public void addNormsField(FieldInfo field, final NormsProducer normsProducer) throws IOException {
            this.impl.addNumericField(field, new EmptyDocValuesProducer(){

                @Override
                public NumericDocValues getNumeric(FieldInfo field) throws IOException {
                    return normsProducer.getNorms(field);
                }
            });
        }

        @Override
        public void close() throws IOException {
            this.impl.close();
        }
    }

    public static class SimpleTextNormsProducer
    extends NormsProducer {
        private final SimpleTextDocValuesReader impl;

        public SimpleTextNormsProducer(SegmentReadState state) throws IOException {
            this.impl = new SimpleTextDocValuesReader(state, SimpleTextNormsFormat.NORMS_SEG_EXTENSION);
        }

        @Override
        public NumericDocValues getNorms(FieldInfo field) throws IOException {
            return this.impl.getNumeric(field);
        }

        @Override
        public void close() throws IOException {
            this.impl.close();
        }

        @Override
        public void checkIntegrity() throws IOException {
            this.impl.checkIntegrity();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.impl + ")";
        }
    }
}

