/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.codecs.simpletext.SimpleTextTermVectorsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SlowImpactsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;

public class SimpleTextTermVectorsReader
extends TermVectorsReader {
    private long[] offsets;
    private IndexInput in;
    private BytesRefBuilder scratch = new BytesRefBuilder();
    private CharsRefBuilder scratchUTF16 = new CharsRefBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleTextTermVectorsReader(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        boolean success = false;
        try {
            this.in = directory.openInput(IndexFileNames.segmentFileName(si.name, "", "tvc"), context);
            success = true;
        }
        finally {
            if (!success) {
                try {
                    this.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.readIndex(si.maxDoc());
    }

    SimpleTextTermVectorsReader(long[] offsets, IndexInput in) {
        this.offsets = offsets;
        this.in = in;
    }

    private void readIndex(int maxDoc) throws IOException {
        BufferedChecksumIndexInput input = new BufferedChecksumIndexInput(this.in);
        this.offsets = new long[maxDoc];
        int upto = 0;
        while (!this.scratch.get().equals(SimpleTextTermVectorsWriter.END)) {
            SimpleTextUtil.readLine(input, this.scratch);
            if (!StringHelper.startsWith(this.scratch.get(), SimpleTextTermVectorsWriter.DOC)) continue;
            this.offsets[upto] = ((IndexInput)input).getFilePointer();
            ++upto;
        }
        SimpleTextUtil.checkFooter(input);
        assert (upto == this.offsets.length);
    }

    @Override
    public Fields get(int doc) throws IOException {
        TreeMap<String, SimpleTVTerms> fields = new TreeMap<String, SimpleTVTerms>();
        this.in.seek(this.offsets[doc]);
        this.readLine();
        assert (StringHelper.startsWith(this.scratch.get(), SimpleTextTermVectorsWriter.NUMFIELDS));
        int numFields = this.parseIntAt(SimpleTextTermVectorsWriter.NUMFIELDS.length);
        if (numFields == 0) {
            return null;
        }
        for (int i = 0; i < numFields; ++i) {
            this.readLine();
            assert (StringHelper.startsWith(this.scratch.get(), SimpleTextTermVectorsWriter.FIELD));
            this.parseIntAt(SimpleTextTermVectorsWriter.FIELD.length);
            this.readLine();
            assert (StringHelper.startsWith(this.scratch.get(), SimpleTextTermVectorsWriter.FIELDNAME));
            String fieldName = this.readString(SimpleTextTermVectorsWriter.FIELDNAME.length, this.scratch);
            this.readLine();
            assert (StringHelper.startsWith(this.scratch.get(), SimpleTextTermVectorsWriter.FIELDPOSITIONS));
            boolean positions = Boolean.parseBoolean(this.readString(SimpleTextTermVectorsWriter.FIELDPOSITIONS.length, this.scratch));
            this.readLine();
            assert (StringHelper.startsWith(this.scratch.get(), SimpleTextTermVectorsWriter.FIELDOFFSETS));
            boolean offsets = Boolean.parseBoolean(this.readString(SimpleTextTermVectorsWriter.FIELDOFFSETS.length, this.scratch));
            this.readLine();
            assert (StringHelper.startsWith(this.scratch.get(), SimpleTextTermVectorsWriter.FIELDPAYLOADS));
            boolean payloads = Boolean.parseBoolean(this.readString(SimpleTextTermVectorsWriter.FIELDPAYLOADS.length, this.scratch));
            this.readLine();
            assert (StringHelper.startsWith(this.scratch.get(), SimpleTextTermVectorsWriter.FIELDTERMCOUNT));
            int termCount = this.parseIntAt(SimpleTextTermVectorsWriter.FIELDTERMCOUNT.length);
            SimpleTVTerms terms = new SimpleTVTerms(offsets, positions, payloads);
            fields.put(fieldName, terms);
            BytesRefBuilder term = new BytesRefBuilder();
            for (int j = 0; j < termCount; ++j) {
                this.readLine();
                assert (StringHelper.startsWith(this.scratch.get(), SimpleTextTermVectorsWriter.TERMTEXT));
                int termLength = this.scratch.length() - SimpleTextTermVectorsWriter.TERMTEXT.length;
                term.grow(termLength);
                term.setLength(termLength);
                System.arraycopy(this.scratch.bytes(), SimpleTextTermVectorsWriter.TERMTEXT.length, term.bytes(), 0, termLength);
                SimpleTVPostings postings = new SimpleTVPostings();
                terms.terms.put(term.toBytesRef(), postings);
                this.readLine();
                assert (StringHelper.startsWith(this.scratch.get(), SimpleTextTermVectorsWriter.TERMFREQ));
                postings.freq = this.parseIntAt(SimpleTextTermVectorsWriter.TERMFREQ.length);
                if (!positions && !offsets) continue;
                if (positions) {
                    postings.positions = new int[postings.freq];
                    if (payloads) {
                        postings.payloads = new BytesRef[postings.freq];
                    }
                }
                if (offsets) {
                    postings.startOffsets = new int[postings.freq];
                    postings.endOffsets = new int[postings.freq];
                }
                for (int k = 0; k < postings.freq; ++k) {
                    if (positions) {
                        this.readLine();
                        assert (StringHelper.startsWith(this.scratch.get(), SimpleTextTermVectorsWriter.POSITION));
                        postings.positions[k] = this.parseIntAt(SimpleTextTermVectorsWriter.POSITION.length);
                        if (payloads) {
                            this.readLine();
                            assert (StringHelper.startsWith(this.scratch.get(), SimpleTextTermVectorsWriter.PAYLOAD));
                            if (this.scratch.length() - SimpleTextTermVectorsWriter.PAYLOAD.length == 0) {
                                postings.payloads[k] = null;
                            } else {
                                byte[] payloadBytes = new byte[this.scratch.length() - SimpleTextTermVectorsWriter.PAYLOAD.length];
                                System.arraycopy(this.scratch.bytes(), SimpleTextTermVectorsWriter.PAYLOAD.length, payloadBytes, 0, payloadBytes.length);
                                postings.payloads[k] = new BytesRef(payloadBytes);
                            }
                        }
                    }
                    if (!offsets) continue;
                    this.readLine();
                    assert (StringHelper.startsWith(this.scratch.get(), SimpleTextTermVectorsWriter.STARTOFFSET));
                    postings.startOffsets[k] = this.parseIntAt(SimpleTextTermVectorsWriter.STARTOFFSET.length);
                    this.readLine();
                    assert (StringHelper.startsWith(this.scratch.get(), SimpleTextTermVectorsWriter.ENDOFFSET));
                    postings.endOffsets[k] = this.parseIntAt(SimpleTextTermVectorsWriter.ENDOFFSET.length);
                }
            }
        }
        return new SimpleTVFields(fields);
    }

    @Override
    public TermVectorsReader clone() {
        if (this.in == null) {
            throw new AlreadyClosedException("this TermVectorsReader is closed");
        }
        return new SimpleTextTermVectorsReader(this.offsets, this.in.clone());
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.in);
        }
        finally {
            this.in = null;
            this.offsets = null;
        }
    }

    private void readLine() throws IOException {
        SimpleTextUtil.readLine(this.in, this.scratch);
    }

    private int parseIntAt(int offset) {
        this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), offset, this.scratch.length() - offset);
        return ArrayUtil.parseInt(this.scratchUTF16.chars(), 0, this.scratchUTF16.length());
    }

    private String readString(int offset, BytesRefBuilder scratch) {
        this.scratchUTF16.copyUTF8Bytes(scratch.bytes(), offset, scratch.length() - offset);
        return this.scratchUTF16.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void checkIntegrity() throws IOException {
    }

    private static class SimpleTVPostingsEnum
    extends PostingsEnum {
        private boolean didNext;
        private int doc = -1;
        private int nextPos;
        private int[] positions;
        private BytesRef[] payloads;
        private int[] startOffsets;
        private int[] endOffsets;

        private SimpleTVPostingsEnum() {
        }

        @Override
        public int freq() throws IOException {
            if (this.positions != null) {
                return this.positions.length;
            }
            assert (this.startOffsets != null);
            return this.startOffsets.length;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() {
            if (!this.didNext) {
                this.didNext = true;
                this.doc = 0;
                return 0;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        public void reset(int[] positions, int[] startOffsets, int[] endOffsets, BytesRef[] payloads) {
            this.positions = positions;
            this.startOffsets = startOffsets;
            this.endOffsets = endOffsets;
            this.payloads = payloads;
            this.doc = -1;
            this.didNext = false;
            this.nextPos = 0;
        }

        @Override
        public BytesRef getPayload() {
            return this.payloads == null ? null : this.payloads[this.nextPos - 1];
        }

        @Override
        public int nextPosition() {
            if (this.positions != null) {
                assert (this.nextPos < this.positions.length) : "nextPosition() called more than freq() times!";
                return this.positions[this.nextPos++];
            }
            assert (this.nextPos < this.startOffsets.length) : "nextPosition() called more than freq() times!";
            ++this.nextPos;
            return -1;
        }

        @Override
        public int startOffset() {
            if (this.startOffsets == null) {
                return -1;
            }
            return this.startOffsets[this.nextPos - 1];
        }

        @Override
        public int endOffset() {
            if (this.endOffsets == null) {
                return -1;
            }
            return this.endOffsets[this.nextPos - 1];
        }

        @Override
        public long cost() {
            return 1L;
        }
    }

    private static class SimpleTVDocsEnum
    extends PostingsEnum {
        private boolean didNext;
        private int doc = -1;
        private int freq;

        private SimpleTVDocsEnum() {
        }

        @Override
        public int freq() throws IOException {
            assert (this.freq != -1);
            return this.freq;
        }

        @Override
        public int nextPosition() throws IOException {
            return -1;
        }

        @Override
        public int startOffset() throws IOException {
            return -1;
        }

        @Override
        public int endOffset() throws IOException {
            return -1;
        }

        @Override
        public BytesRef getPayload() throws IOException {
            return null;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() {
            if (!this.didNext) {
                this.didNext = true;
                this.doc = 0;
                return 0;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        public void reset(int freq) {
            this.freq = freq;
            this.doc = -1;
            this.didNext = false;
        }

        @Override
        public long cost() {
            return 1L;
        }
    }

    private static class SimpleTVTermsEnum
    extends BaseTermsEnum {
        SortedMap<BytesRef, SimpleTVPostings> terms;
        Iterator<Map.Entry<BytesRef, SimpleTVPostings>> iterator;
        Map.Entry<BytesRef, SimpleTVPostings> current;

        SimpleTVTermsEnum(SortedMap<BytesRef, SimpleTVPostings> terms) {
            this.terms = terms;
            this.iterator = terms.entrySet().iterator();
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            this.iterator = this.terms.tailMap(text).entrySet().iterator();
            if (!this.iterator.hasNext()) {
                return TermsEnum.SeekStatus.END;
            }
            return this.next().equals(text) ? TermsEnum.SeekStatus.FOUND : TermsEnum.SeekStatus.NOT_FOUND;
        }

        @Override
        public void seekExact(long ord) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public BytesRef next() throws IOException {
            if (!this.iterator.hasNext()) {
                return null;
            }
            this.current = this.iterator.next();
            return this.current.getKey();
        }

        @Override
        public BytesRef term() throws IOException {
            return this.current.getKey();
        }

        @Override
        public long ord() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docFreq() throws IOException {
            return 1;
        }

        @Override
        public long totalTermFreq() throws IOException {
            return this.current.getValue().freq;
        }

        @Override
        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            if (PostingsEnum.featureRequested(flags, (short)24)) {
                SimpleTVPostings postings = this.current.getValue();
                if (postings.positions != null || postings.startOffsets != null) {
                    SimpleTVPostingsEnum e = new SimpleTVPostingsEnum();
                    e.reset(postings.positions, postings.startOffsets, postings.endOffsets, postings.payloads);
                    return e;
                }
            }
            SimpleTVDocsEnum e = new SimpleTVDocsEnum();
            e.reset(!PostingsEnum.featureRequested(flags, (short)8) ? 1 : this.current.getValue().freq);
            return e;
        }

        @Override
        public ImpactsEnum impacts(int flags) throws IOException {
            return new SlowImpactsEnum(this.postings(null, 8));
        }
    }

    private static class SimpleTVPostings {
        private int freq;
        private int[] positions;
        private int[] startOffsets;
        private int[] endOffsets;
        private BytesRef[] payloads;

        private SimpleTVPostings() {
        }
    }

    private static class SimpleTVTerms
    extends Terms {
        final SortedMap<BytesRef, SimpleTVPostings> terms;
        final boolean hasOffsets;
        final boolean hasPositions;
        final boolean hasPayloads;

        SimpleTVTerms(boolean hasOffsets, boolean hasPositions, boolean hasPayloads) {
            this.hasOffsets = hasOffsets;
            this.hasPositions = hasPositions;
            this.hasPayloads = hasPayloads;
            this.terms = new TreeMap<BytesRef, SimpleTVPostings>();
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return new SimpleTVTermsEnum(this.terms);
        }

        @Override
        public long size() throws IOException {
            return this.terms.size();
        }

        @Override
        public long getSumTotalTermFreq() throws IOException {
            long ttf = 0L;
            TermsEnum iterator = this.iterator();
            BytesRef b = iterator.next();
            while (b != null) {
                ttf += iterator.totalTermFreq();
                b = iterator.next();
            }
            return ttf;
        }

        @Override
        public long getSumDocFreq() throws IOException {
            return this.terms.size();
        }

        @Override
        public int getDocCount() throws IOException {
            return 1;
        }

        @Override
        public boolean hasFreqs() {
            return true;
        }

        @Override
        public boolean hasOffsets() {
            return this.hasOffsets;
        }

        @Override
        public boolean hasPositions() {
            return this.hasPositions;
        }

        @Override
        public boolean hasPayloads() {
            return this.hasPayloads;
        }
    }

    private static class SimpleTVFields
    extends Fields {
        private final SortedMap<String, SimpleTVTerms> fields;

        SimpleTVFields(SortedMap<String, SimpleTVTerms> fields) {
            this.fields = fields;
        }

        @Override
        public Iterator<String> iterator() {
            return Collections.unmodifiableSet(this.fields.keySet()).iterator();
        }

        @Override
        public Terms terms(String field) throws IOException {
            return (Terms)this.fields.get(field);
        }

        @Override
        public int size() {
            return this.fields.size();
        }
    }
}

