/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.uniformsplit.DeltaBaseTermStateSerializer;
import org.apache.lucene.codecs.uniformsplit.RamUsageUtil;
import org.apache.lucene.codecs.uniformsplit.TermBytes;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;

public class BlockLine
implements Accountable {
    private static final long BASE_RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(BlockLine.class);
    protected TermBytes termBytes;
    protected int termStateRelativeOffset;
    protected final BlockTermState termState;

    protected BlockLine(TermBytes termBytes, BlockTermState termState) {
        this(termBytes, -1, termState);
    }

    protected BlockLine(TermBytes termBytes, int termStateRelativeOffset) {
        this(termBytes, termStateRelativeOffset, null);
    }

    private BlockLine(TermBytes termBytes, int termStateRelativeOffset, BlockTermState termState) {
        this.reset(termBytes, termStateRelativeOffset);
        this.termState = termState;
    }

    protected BlockLine reset(TermBytes termBytes, int termStateRelativeOffset) {
        assert (this.termState == null);
        this.termBytes = termBytes;
        this.termStateRelativeOffset = termStateRelativeOffset;
        return this;
    }

    public TermBytes getTermBytes() {
        return this.termBytes;
    }

    public int getTermStateRelativeOffset() {
        return this.termStateRelativeOffset;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_USAGE + this.termBytes.ramBytesUsed() + RamUsageUtil.ramBytesUsed(this.termState);
    }

    public static class Serializer
    implements Accountable {
        private static final long BASE_RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(Serializer.class);
        protected final BytesRef currentTerm = new BytesRef(64);

        public BlockLine readLine(DataInput blockInput, boolean isIncrementalEncodingSeed, BlockLine reuse) throws IOException {
            int termStateRelativeOffset = blockInput.readVInt();
            if (termStateRelativeOffset < 0) {
                throw new CorruptIndexException("Illegal termStateRelativeOffset= " + termStateRelativeOffset, blockInput);
            }
            return reuse == null ? new BlockLine(this.readIncrementallyEncodedTerm(blockInput, isIncrementalEncodingSeed, null), termStateRelativeOffset) : reuse.reset(this.readIncrementallyEncodedTerm(blockInput, isIncrementalEncodingSeed, reuse.termBytes), termStateRelativeOffset);
        }

        public void writeLine(DataOutput blockOutput, BlockLine line, BlockLine previousLine, int termStateRelativeOffset, boolean isIncrementalEncodingSeed) throws IOException {
            blockOutput.writeVInt(termStateRelativeOffset);
            this.writeIncrementallyEncodedTerm(line.getTermBytes(), previousLine == null ? null : previousLine.getTermBytes(), isIncrementalEncodingSeed, blockOutput);
        }

        protected void writeLineTermState(DataOutput termStatesOutput, BlockLine line, FieldInfo fieldInfo, DeltaBaseTermStateSerializer encoder) throws IOException {
            assert (line.termState != null);
            encoder.writeTermState(termStatesOutput, fieldInfo, line.termState);
        }

        protected void writeIncrementallyEncodedTerm(TermBytes termBytes, TermBytes previousTermBytes, boolean isIncrementalEncodingSeed, DataOutput blockOutput) throws IOException {
            BytesRef term = termBytes.getTerm();
            assert (term.offset == 0);
            if (isIncrementalEncodingSeed) {
                blockOutput.writeVLong(term.length);
                blockOutput.writeBytes(term.bytes, 0, term.length);
                return;
            }
            if (term.length == 0) {
                blockOutput.writeVLong(0L);
                return;
            }
            assert (previousTermBytes != null);
            assert (termBytes.getMdpLength() >= 1);
            int numMdpBits = Serializer.numBitsToEncode(previousTermBytes.getTerm().length);
            assert (Serializer.numBitsToEncode(termBytes.getMdpLength() - 1) <= numMdpBits);
            long mdpAndSuffixLengths = (long)termBytes.getSuffixLength() << numMdpBits | (long)(termBytes.getMdpLength() - 1);
            assert (mdpAndSuffixLengths != 0L);
            blockOutput.writeVLong(mdpAndSuffixLengths);
            blockOutput.writeBytes(term.bytes, termBytes.getSuffixOffset(), termBytes.getSuffixLength());
        }

        protected TermBytes readIncrementallyEncodedTerm(DataInput blockInput, boolean isIncrementalEncodingSeed, TermBytes reuse) throws IOException {
            int mdpLength;
            assert (this.currentTerm.offset == 0);
            if (isIncrementalEncodingSeed) {
                int length = (int)blockInput.readVLong();
                mdpLength = length == 0 ? 0 : 1;
                this.readBytes(blockInput, this.currentTerm, 0, length);
            } else {
                long mdpAndSuffixLengths = blockInput.readVLong();
                if (mdpAndSuffixLengths == 0L) {
                    mdpLength = 0;
                    this.currentTerm.length = 0;
                } else {
                    int numMdpBits = Serializer.numBitsToEncode(this.currentTerm.length);
                    mdpLength = (int)(mdpAndSuffixLengths & (long)((1 << numMdpBits) - 1)) + 1;
                    int suffixLength = (int)(mdpAndSuffixLengths >>> numMdpBits);
                    assert (mdpLength >= 1);
                    assert (suffixLength >= 1);
                    this.readBytes(blockInput, this.currentTerm, mdpLength - 1, suffixLength);
                }
            }
            return reuse == null ? new TermBytes(mdpLength, this.currentTerm) : reuse.reset(mdpLength, this.currentTerm);
        }

        protected void readBytes(DataInput input, BytesRef bytes, int offset, int length) throws IOException {
            assert (bytes.offset == 0);
            bytes.length = offset + length;
            bytes.bytes = ArrayUtil.grow(bytes.bytes, bytes.length);
            input.readBytes(bytes.bytes, offset, length);
        }

        @Override
        public long ramBytesUsed() {
            return BASE_RAM_USAGE + RamUsageUtil.ramBytesUsed(this.currentTerm);
        }

        protected static int numBitsToEncode(int i) {
            return 32 - Integer.numberOfLeadingZeros(i);
        }
    }
}

