/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.uniformsplit.BlockDecoder;
import org.apache.lucene.codecs.uniformsplit.BlockHeader;
import org.apache.lucene.codecs.uniformsplit.BlockLine;
import org.apache.lucene.codecs.uniformsplit.DeltaBaseTermStateSerializer;
import org.apache.lucene.codecs.uniformsplit.FieldMetadata;
import org.apache.lucene.codecs.uniformsplit.IndexDictionary;
import org.apache.lucene.codecs.uniformsplit.RamUsageUtil;
import org.apache.lucene.codecs.uniformsplit.TermBytes;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;

public class BlockReader
extends BaseTermsEnum
implements Accountable {
    private static final long BASE_RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(BlockReader.class) + RamUsageEstimator.shallowSizeOfInstance(IndexInput.class) + RamUsageEstimator.shallowSizeOfInstance(ByteArrayDataInput.class) * 2L;
    protected IndexInput blockInput;
    protected final PostingsReaderBase postingsReader;
    protected final FieldMetadata fieldMetadata;
    protected final BlockDecoder blockDecoder;
    protected BlockHeader.Serializer blockHeaderReader;
    protected BlockLine.Serializer blockLineReader;
    protected ByteArrayDataInput blockReadBuffer;
    protected ByteArrayDataInput termStatesReadBuffer;
    protected DeltaBaseTermStateSerializer termStateSerializer;
    protected final IndexDictionary.BrowserSupplier dictionaryBrowserSupplier;
    protected IndexDictionary.Browser dictionaryBrowser;
    protected long blockStartFP;
    protected BlockHeader blockHeader;
    protected BlockLine blockLine;
    protected BlockTermState termState;
    protected int blockFirstLineStart;
    protected int lineIndexInBlock;
    protected boolean termStateForced;
    protected BytesRefBuilder forcedTerm;
    protected BytesRef scratchBlockBytes;
    protected final BlockTermState scratchTermState;
    protected BlockLine scratchBlockLine;

    protected BlockReader(IndexDictionary.BrowserSupplier dictionaryBrowserSupplier, IndexInput blockInput, PostingsReaderBase postingsReader, FieldMetadata fieldMetadata, BlockDecoder blockDecoder) throws IOException {
        this.dictionaryBrowserSupplier = dictionaryBrowserSupplier;
        this.blockInput = blockInput;
        this.postingsReader = postingsReader;
        this.fieldMetadata = fieldMetadata;
        this.blockDecoder = blockDecoder;
        this.blockStartFP = -1L;
        this.scratchTermState = postingsReader.newTermState();
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef searchedTerm) throws IOException {
        if (this.isCurrentTerm(searchedTerm)) {
            return TermsEnum.SeekStatus.FOUND;
        }
        this.clearTermState();
        long blockStartFP = this.getOrCreateDictionaryBrowser().seekBlock(searchedTerm);
        blockStartFP = Math.max(blockStartFP, this.fieldMetadata.getFirstBlockStartFP());
        if (this.isBeyondLastTerm(searchedTerm, blockStartFP)) {
            return TermsEnum.SeekStatus.END;
        }
        TermsEnum.SeekStatus seekStatus = this.seekInBlock(searchedTerm, blockStartFP);
        if (seekStatus != TermsEnum.SeekStatus.END) {
            return seekStatus;
        }
        return this.nextTerm() == null ? TermsEnum.SeekStatus.END : TermsEnum.SeekStatus.NOT_FOUND;
    }

    @Override
    public boolean seekExact(BytesRef searchedTerm) throws IOException {
        if (this.isCurrentTerm(searchedTerm)) {
            return true;
        }
        this.clearTermState();
        long blockStartFP = this.getOrCreateDictionaryBrowser().seekBlock(searchedTerm);
        if (blockStartFP < this.fieldMetadata.getFirstBlockStartFP() || this.isBeyondLastTerm(searchedTerm, blockStartFP)) {
            return false;
        }
        return this.seekInBlock(searchedTerm, blockStartFP) == TermsEnum.SeekStatus.FOUND;
    }

    protected boolean isCurrentTerm(BytesRef searchedTerm) {
        return searchedTerm.equals(this.term());
    }

    protected boolean isBeyondLastTerm(BytesRef searchedTerm, long blockStartFP) {
        return blockStartFP == this.fieldMetadata.getLastBlockStartFP() && searchedTerm.compareTo(this.fieldMetadata.getLastTerm()) > 0;
    }

    protected TermsEnum.SeekStatus seekInBlock(BytesRef searchedTerm, long blockStartFP) throws IOException {
        this.initializeHeader(searchedTerm, blockStartFP);
        if (this.blockHeader == null) {
            throw this.newCorruptIndexException("Illegal absence of block", blockStartFP);
        }
        return this.seekInBlock(searchedTerm);
    }

    protected TermsEnum.SeekStatus seekInBlock(BytesRef searchedTerm) throws IOException {
        int comparison;
        if (this.compareToMiddleAndJump(searchedTerm) == 0) {
            return TermsEnum.SeekStatus.FOUND;
        }
        int comparisonOffset = 0;
        do {
            if (this.readLineInBlock() == null) {
                return TermsEnum.SeekStatus.END;
            }
            TermBytes lineTermBytes = this.blockLine.getTermBytes();
            BytesRef lineTerm = lineTermBytes.getTerm();
            assert (lineTerm.offset == 0);
            int suffixOffset = lineTermBytes.getSuffixOffset();
            int start = Math.min(comparisonOffset, suffixOffset);
            int end = Math.min(searchedTerm.length, lineTerm.length);
            comparison = searchedTerm.length - lineTerm.length;
            for (int i = start; i < end; ++i) {
                int byteDiff = (searchedTerm.bytes[i + searchedTerm.offset] & 0xFF) - (lineTerm.bytes[i] & 0xFF);
                if (byteDiff != 0) {
                    comparison = byteDiff;
                    break;
                }
                comparisonOffset = i + 1;
            }
            if (comparison != 0) continue;
            return TermsEnum.SeekStatus.FOUND;
        } while (comparison >= 0);
        return TermsEnum.SeekStatus.NOT_FOUND;
    }

    protected int compareToMiddleAndJump(BytesRef searchedTerm) throws IOException {
        if (this.lineIndexInBlock != 0) {
            return -1;
        }
        this.blockReadBuffer.skipBytes(this.blockHeader.getMiddleLineOffset());
        this.lineIndexInBlock = this.blockHeader.getMiddleLineIndex();
        this.readLineInBlock();
        if (this.blockLine == null) {
            throw this.newCorruptIndexException("Illegal absence of line at the middle of the block", null);
        }
        int compare = searchedTerm.compareTo(this.term());
        if (compare < 0) {
            this.blockReadBuffer.setPosition(this.blockFirstLineStart);
            this.lineIndexInBlock = 0;
        }
        return compare;
    }

    protected BlockLine readLineInBlock() throws IOException {
        if (this.lineIndexInBlock >= this.blockHeader.getLinesCount()) {
            this.blockLine = null;
            return null;
        }
        boolean isIncrementalEncodingSeed = this.lineIndexInBlock == 0 || this.lineIndexInBlock == this.blockHeader.getMiddleLineIndex();
        ++this.lineIndexInBlock;
        this.blockLine = this.blockLineReader.readLine(this.blockReadBuffer, isIncrementalEncodingSeed, this.scratchBlockLine);
        return this.blockLine;
    }

    @Override
    public void seekExact(BytesRef term, TermState state) {
        this.termStateForced = true;
        this.termState = this.scratchTermState;
        this.termState.copyFrom(state);
        if (this.forcedTerm == null) {
            this.forcedTerm = new BytesRefBuilder();
        }
        this.forcedTerm.copyBytes(term);
    }

    @Override
    public void seekExact(long ord) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BytesRef next() throws IOException {
        if (this.termStateForced) {
            this.initializeHeader(this.forcedTerm.get(), this.termState.blockFilePointer);
            if (this.blockHeader == null) {
                throw this.newCorruptIndexException("Illegal absence of block for TermState", this.termState.blockFilePointer);
            }
            for (int i = this.lineIndexInBlock; i < this.termState.termBlockOrd; ++i) {
                this.readLineInBlock();
            }
            assert (this.blockLine.getTermBytes().getTerm().equals(this.forcedTerm.get()));
        }
        this.clearTermState();
        return this.nextTerm();
    }

    protected BytesRef nextTerm() throws IOException {
        if (this.blockHeader == null) {
            this.initializeHeader(null, this.fieldMetadata.getFirstBlockStartFP());
            if (this.blockHeader == null) {
                throw this.newCorruptIndexException("Illegal absence of first block", this.fieldMetadata.getFirstBlockStartFP());
            }
        }
        if (this.readLineInBlock() == null) {
            this.initializeHeader(null, this.blockInput.getFilePointer());
            if (this.blockHeader == null) {
                return null;
            }
            this.readLineInBlock();
        }
        return this.term();
    }

    protected void initializeHeader(BytesRef searchedTerm, long targetBlockStartFP) throws IOException {
        this.initializeBlockReadLazily();
        if (this.blockStartFP == targetBlockStartFP) {
            if (this.blockHeader == null) {
                throw this.newCorruptIndexException("Illegal absence of block", this.blockStartFP);
            }
            if (searchedTerm == null || this.blockLine == null || searchedTerm.compareTo(this.blockLine.getTermBytes().getTerm()) <= 0) {
                this.blockReadBuffer.setPosition(this.blockFirstLineStart);
                this.lineIndexInBlock = 0;
            }
        } else {
            this.blockInput.seek(targetBlockStartFP);
            this.blockStartFP = targetBlockStartFP;
            this.readHeader();
            this.blockFirstLineStart = this.blockReadBuffer.getPosition();
            this.lineIndexInBlock = 0;
        }
    }

    protected void initializeBlockReadLazily() throws IOException {
        if (this.blockStartFP == -1L) {
            this.blockInput = this.blockInput.clone();
            this.blockHeaderReader = this.createBlockHeaderSerializer();
            this.blockLineReader = this.createBlockLineSerializer();
            this.blockReadBuffer = new ByteArrayDataInput();
            this.termStatesReadBuffer = new ByteArrayDataInput();
            this.termStateSerializer = this.createDeltaBaseTermStateSerializer();
            this.scratchBlockBytes = new BytesRef();
            this.scratchBlockLine = new BlockLine(new TermBytes(0, this.scratchBlockBytes), 0);
        }
    }

    protected BlockHeader.Serializer createBlockHeaderSerializer() {
        return new BlockHeader.Serializer();
    }

    protected BlockLine.Serializer createBlockLineSerializer() {
        return new BlockLine.Serializer();
    }

    protected DeltaBaseTermStateSerializer createDeltaBaseTermStateSerializer() {
        return new DeltaBaseTermStateSerializer();
    }

    protected BlockHeader readHeader() throws IOException {
        if (this.blockInput.getFilePointer() > this.fieldMetadata.getLastBlockStartFP()) {
            this.blockHeader = null;
            return null;
        }
        int numBlockBytes = this.blockInput.readVInt();
        BytesRef blockBytesRef = this.decodeBlockBytesIfNeeded(numBlockBytes);
        this.blockReadBuffer.reset(blockBytesRef.bytes, blockBytesRef.offset, blockBytesRef.length);
        this.termStatesReadBuffer.reset(blockBytesRef.bytes, blockBytesRef.offset, blockBytesRef.length);
        this.blockHeader = this.blockHeaderReader.read(this.blockReadBuffer, this.blockHeader);
        return this.blockHeader;
    }

    protected BytesRef decodeBlockBytesIfNeeded(int numBlockBytes) throws IOException {
        this.scratchBlockBytes.bytes = ArrayUtil.grow(this.scratchBlockBytes.bytes, numBlockBytes);
        this.blockInput.readBytes(this.scratchBlockBytes.bytes, 0, numBlockBytes);
        this.scratchBlockBytes.length = numBlockBytes;
        if (this.blockDecoder == null) {
            return this.scratchBlockBytes;
        }
        this.blockReadBuffer.reset(this.scratchBlockBytes.bytes, 0, numBlockBytes);
        return this.blockDecoder.decode(this.blockReadBuffer, numBlockBytes);
    }

    protected BlockTermState readTermStateIfNotRead() throws IOException {
        if (this.termState == null) {
            this.termState = this.readTermState();
            if (this.termState != null) {
                this.termState.termBlockOrd = this.lineIndexInBlock;
                this.termState.blockFilePointer = this.blockStartFP;
            }
        }
        return this.termState;
    }

    protected BlockTermState readTermState() throws IOException {
        this.termStatesReadBuffer.setPosition(this.blockFirstLineStart + this.blockHeader.getTermStatesBaseOffset() + this.blockLine.getTermStateRelativeOffset());
        this.termState = this.termStateSerializer.readTermState(this.blockHeader.getBaseDocsFP(), this.blockHeader.getBasePositionsFP(), this.blockHeader.getBasePayloadsFP(), this.termStatesReadBuffer, this.fieldMetadata.getFieldInfo(), this.scratchTermState);
        return this.termState;
    }

    @Override
    public BytesRef term() {
        if (this.termStateForced) {
            return this.forcedTerm.get();
        }
        return this.blockLine == null ? null : this.blockLine.getTermBytes().getTerm();
    }

    @Override
    public long ord() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int docFreq() throws IOException {
        this.readTermStateIfNotRead();
        return this.termState.docFreq;
    }

    @Override
    public long totalTermFreq() throws IOException {
        this.readTermStateIfNotRead();
        return this.termState.totalTermFreq;
    }

    @Override
    public TermState termState() throws IOException {
        this.readTermStateIfNotRead();
        return this.termState.clone();
    }

    @Override
    public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
        this.readTermStateIfNotRead();
        return this.postingsReader.postings(this.fieldMetadata.getFieldInfo(), this.termState, reuse, flags);
    }

    @Override
    public ImpactsEnum impacts(int flags) throws IOException {
        this.readTermStateIfNotRead();
        return this.postingsReader.impacts(this.fieldMetadata.getFieldInfo(), this.termState, flags);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_USAGE + (this.blockLineReader == null ? 0L : this.blockLineReader.ramBytesUsed()) + (this.blockReadBuffer == null ? 0L : RamUsageUtil.ramBytesUsedByByteArrayOfLength(this.blockReadBuffer.length())) + (this.termStateSerializer == null ? 0L : this.termStateSerializer.ramBytesUsed()) + (this.forcedTerm == null ? 0L : RamUsageUtil.ramBytesUsed(this.forcedTerm)) + (this.blockHeader == null ? 0L : this.blockHeader.ramBytesUsed()) + (this.blockLine == null ? 0L : this.blockLine.ramBytesUsed()) + (this.termState == null ? 0L : RamUsageUtil.ramBytesUsed(this.termState));
    }

    protected IndexDictionary.Browser getOrCreateDictionaryBrowser() throws IOException {
        if (this.dictionaryBrowser == null) {
            this.dictionaryBrowser = (IndexDictionary.Browser)this.dictionaryBrowserSupplier.get();
        }
        return this.dictionaryBrowser;
    }

    protected void clearTermState() {
        this.termState = null;
        this.termStateForced = false;
    }

    protected CorruptIndexException newCorruptIndexException(String msg, Long fp) {
        return new CorruptIndexException(msg + (String)(fp == null ? "" : " at FP " + fp) + " for field \"" + this.fieldMetadata.getFieldInfo().name + "\"", this.blockInput);
    }
}

