/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.ExpressionFunctionValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;

class ExpressionValueSource
extends DoubleValuesSource {
    final DoubleValuesSource[] variables;
    final Expression expression;
    final boolean needsScores;

    ExpressionValueSource(Bindings bindings, Expression expression) {
        if (bindings == null) {
            throw new NullPointerException();
        }
        this.expression = Objects.requireNonNull(expression);
        this.variables = new DoubleValuesSource[expression.variables.length];
        boolean needsScores = false;
        for (int i = 0; i < this.variables.length; ++i) {
            DoubleValuesSource source = bindings.getDoubleValuesSource(expression.variables[i]);
            if (source == null) {
                throw new RuntimeException("Internal error. Variable (" + expression.variables[i] + ") does not exist.");
            }
            needsScores |= source.needsScores();
            this.variables[i] = source;
        }
        this.needsScores = needsScores;
    }

    ExpressionValueSource(DoubleValuesSource[] variables, Expression expression, boolean needsScores) {
        this.variables = variables;
        this.expression = expression;
        this.needsScores = needsScores;
    }

    @Override
    public DoubleValues getValues(LeafReaderContext readerContext, DoubleValues scores) throws IOException {
        HashMap<String, DoubleValues> valuesCache = new HashMap<String, DoubleValues>();
        DoubleValues[] externalValues = new DoubleValues[this.expression.variables.length];
        for (int i = 0; i < this.variables.length; ++i) {
            String externalName = this.expression.variables[i];
            DoubleValues values = (DoubleValues)valuesCache.get(externalName);
            if (values == null) {
                values = this.variables[i].getValues(readerContext, scores);
                if (values == null) {
                    throw new RuntimeException("Unrecognized variable (" + externalName + ") referenced in expression (" + this.expression.sourceText + ").");
                }
                valuesCache.put(externalName, values);
            }
            externalValues[i] = ExpressionValueSource.zeroWhenUnpositioned(values);
        }
        return new ExpressionFunctionValues(this.expression, externalValues);
    }

    static DoubleValues zeroWhenUnpositioned(final DoubleValues in) {
        return new DoubleValues(){
            int currentDoc = -1;
            double value;
            boolean computed = false;

            @Override
            public double doubleValue() throws IOException {
                if (!this.computed) {
                    this.value = in.advanceExact(this.currentDoc) ? in.doubleValue() : 0.0;
                    this.computed = true;
                }
                return this.value;
            }

            @Override
            public boolean advanceExact(int doc) {
                if (this.currentDoc == doc) {
                    return true;
                }
                this.currentDoc = doc;
                this.computed = false;
                return true;
            }
        };
    }

    @Override
    public String toString() {
        return "expr(" + this.expression.sourceText + ")";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.sourceText.hashCode());
        result = 31 * result + (this.needsScores ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.variables);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionValueSource other = (ExpressionValueSource)obj;
        if (this.expression == null ? other.expression != null : !this.expression.sourceText.equals(other.expression.sourceText)) {
            return false;
        }
        if (this.needsScores != other.needsScores) {
            return false;
        }
        return Arrays.equals(this.variables, other.variables);
    }

    @Override
    public boolean needsScores() {
        return this.needsScores;
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        for (DoubleValuesSource v : this.variables) {
            if (v.isCacheable(ctx)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
        Explanation[] explanations = new Explanation[this.variables.length];
        DoubleValues dv = this.getValues(ctx, DoubleValuesSource.constant(scoreExplanation.getValue().doubleValue()).getValues(ctx, null));
        if (!dv.advanceExact(docId)) {
            return Explanation.noMatch(this.expression.sourceText, new Explanation[0]);
        }
        int i = 0;
        for (DoubleValuesSource var : this.variables) {
            explanations[i++] = var.explain(ctx, docId, scoreExplanation);
        }
        return Explanation.match((Number)dv.doubleValue(), this.expression.sourceText + ", computed from:", explanations);
    }

    @Override
    public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
        boolean changed = false;
        DoubleValuesSource[] rewritten = new DoubleValuesSource[this.variables.length];
        for (int i = 0; i < this.variables.length; ++i) {
            rewritten[i] = this.variables[i].rewrite(searcher);
            changed |= rewritten[i] != this.variables[i];
        }
        if (changed) {
            return new ExpressionValueSource(rewritten, this.expression, this.needsScores);
        }
        return this;
    }
}

