/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.DrillSidewaysQuery;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsCollectorManager;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.MultiFacets;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetCounts;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.facet.taxonomy.FastTaxonomyFacetCounts;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.MultiCollectorManager;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.ThreadInterruptedException;

public class DrillSideways {
    protected final IndexSearcher searcher;
    protected final TaxonomyReader taxoReader;
    protected final SortedSetDocValuesReaderState state;
    protected final FacetsConfig config;
    private final ExecutorService executor;

    public DrillSideways(IndexSearcher searcher, FacetsConfig config, TaxonomyReader taxoReader) {
        this(searcher, config, taxoReader, null);
    }

    public DrillSideways(IndexSearcher searcher, FacetsConfig config, SortedSetDocValuesReaderState state) {
        this(searcher, config, null, state);
    }

    public DrillSideways(IndexSearcher searcher, FacetsConfig config, TaxonomyReader taxoReader, SortedSetDocValuesReaderState state) {
        this(searcher, config, taxoReader, state, null);
    }

    public DrillSideways(IndexSearcher searcher, FacetsConfig config, TaxonomyReader taxoReader, SortedSetDocValuesReaderState state, ExecutorService executor) {
        this.searcher = searcher;
        this.config = config;
        this.taxoReader = taxoReader;
        this.state = state;
        this.executor = executor;
    }

    protected FacetsCollector createDrillDownFacetsCollector() {
        return new FacetsCollector();
    }

    protected FacetsCollectorManager createDrillDownFacetsCollectorManager() {
        return new FacetsCollectorManager();
    }

    protected Facets buildFacetsResult(FacetsCollector drillDowns, FacetsCollector[] drillSideways, String[] drillSidewaysDims) throws IOException {
        Facets drillDownFacets = null;
        HashMap<String, Facets> drillSidewaysFacets = new HashMap<String, Facets>();
        if (this.taxoReader != null) {
            if (drillDowns != null) {
                drillDownFacets = new FastTaxonomyFacetCounts(this.taxoReader, this.config, drillDowns);
            }
            if (drillSideways != null) {
                for (int i = 0; i < drillSideways.length; ++i) {
                    drillSidewaysFacets.put(drillSidewaysDims[i], new FastTaxonomyFacetCounts(this.taxoReader, this.config, drillSideways[i]));
                }
            }
        } else {
            if (drillDowns != null) {
                drillDownFacets = new SortedSetDocValuesFacetCounts(this.state, drillDowns);
            }
            if (drillSideways != null) {
                for (int i = 0; i < drillSideways.length; ++i) {
                    drillSidewaysFacets.put(drillSidewaysDims[i], new SortedSetDocValuesFacetCounts(this.state, drillSideways[i]));
                }
            }
        }
        if (drillSidewaysFacets.isEmpty()) {
            return drillDownFacets;
        }
        return new MultiFacets(drillSidewaysFacets, drillDownFacets);
    }

    @Deprecated
    public DrillSidewaysResult search(DrillDownQuery query, Collector hitCollector) throws IOException {
        Map<String, Integer> drillDownDims = query.getDims();
        if (drillDownDims.isEmpty()) {
            FacetsCollector drillDownCollector = this.createDrillDownFacetsCollector();
            if (drillDownCollector != null) {
                this.searcher.search((Query)query, MultiCollector.wrap(hitCollector, drillDownCollector));
            } else {
                this.searcher.search((Query)query, hitCollector);
            }
            return new DrillSidewaysResult(this.buildFacetsResult(drillDownCollector, null, null), null, drillDownCollector, null, null);
        }
        Query baseQuery = query.getBaseQuery();
        if (baseQuery == null) {
            baseQuery = new MatchAllDocsQuery();
        }
        Query[] drillDownQueries = query.getDrillDownQueries();
        int numDims = drillDownDims.size();
        FacetsCollectorManager drillDownCollectorManager = this.createDrillDownFacetsCollectorManager();
        FacetsCollectorManager[] drillSidewaysFacetsCollectorManagers = new FacetsCollectorManager[numDims];
        for (int i = 0; i < numDims; ++i) {
            drillSidewaysFacetsCollectorManagers[i] = new FacetsCollectorManager();
        }
        DrillSidewaysQuery dsq = new DrillSidewaysQuery(baseQuery, drillDownCollectorManager, drillSidewaysFacetsCollectorManagers, drillDownQueries, this.scoreSubDocsAtOnce());
        this.searcher.search((Query)dsq, hitCollector);
        Object drillDownCollector = drillDownCollectorManager != null ? drillDownCollectorManager.reduce(dsq.managedDrillDownCollectors) : null;
        FacetsCollector[] drillSidewaysCollectors = new FacetsCollector[numDims];
        int numSlices = dsq.managedDrillSidewaysCollectors.size();
        for (int dim = 0; dim < numDims; ++dim) {
            ArrayList<FacetsCollector> facetsCollectorsForDim = new ArrayList<FacetsCollector>(numSlices);
            for (int slice = 0; slice < numSlices; ++slice) {
                facetsCollectorsForDim.add(dsq.managedDrillSidewaysCollectors.get(slice)[dim]);
            }
            drillSidewaysCollectors[dim] = drillSidewaysFacetsCollectorManagers[dim].reduce(facetsCollectorsForDim);
        }
        String[] drillSidewaysDims = drillDownDims.keySet().toArray(new String[0]);
        return new DrillSidewaysResult(this.buildFacetsResult((FacetsCollector)drillDownCollector, drillSidewaysCollectors, drillSidewaysDims), null, (FacetsCollector)drillDownCollector, drillSidewaysCollectors, drillSidewaysDims);
    }

    public DrillSidewaysResult search(DrillDownQuery query, Query filter, FieldDoc after, int topN, Sort sort, boolean doDocScores) throws IOException {
        if (filter != null) {
            query = new DrillDownQuery(this.config, filter, query);
        }
        if (sort != null) {
            int limit = this.searcher.getIndexReader().maxDoc();
            if (limit == 0) {
                limit = 1;
            }
            int fTopN = Math.min(topN, limit);
            CollectorManager<TopFieldCollector, TopFieldDocs> collectorManager = TopFieldCollector.createSharedManager(sort, fTopN, after, Integer.MAX_VALUE);
            ConcurrentDrillSidewaysResult<TopFieldDocs> r = this.search(query, collectorManager);
            TopFieldDocs topDocs = (TopFieldDocs)r.collectorResult;
            if (doDocScores) {
                TopFieldCollector.populateScores(topDocs.scoreDocs, this.searcher, query);
            }
            return new DrillSidewaysResult(r.facets, (TopDocs)r.collectorResult, r.drillDownFacetsCollector, r.drillSidewaysFacetsCollector, r.drillSidewaysDims);
        }
        return this.search(after, query, topN);
    }

    public DrillSidewaysResult search(DrillDownQuery query, int topN) throws IOException {
        return this.search(null, query, topN);
    }

    public DrillSidewaysResult search(ScoreDoc after, DrillDownQuery query, int topN) throws IOException {
        int limit = this.searcher.getIndexReader().maxDoc();
        if (limit == 0) {
            limit = 1;
        }
        int fTopN = Math.min(topN, limit);
        CollectorManager<TopScoreDocCollector, TopDocs> collectorManager = TopScoreDocCollector.createSharedManager(fTopN, after, Integer.MAX_VALUE);
        ConcurrentDrillSidewaysResult<TopDocs> r = this.search(query, collectorManager);
        return new DrillSidewaysResult(r.facets, (TopDocs)r.collectorResult, r.drillDownFacetsCollector, r.drillSidewaysFacetsCollector, r.drillSidewaysDims);
    }

    protected boolean scoreSubDocsAtOnce() {
        return false;
    }

    private DrillDownQuery getDrillDownQuery(DrillDownQuery query, Query[] queries, String excludedDimension) {
        DrillDownQuery ddl = new DrillDownQuery(this.config, query.getBaseQuery());
        query.getDims().forEach((dim, pos) -> {
            if (!dim.equals(excludedDimension)) {
                ddl.add((String)dim, queries[pos]);
            }
        });
        return ddl.getDims().size() == queries.length ? null : ddl;
    }

    public <R> ConcurrentDrillSidewaysResult<R> search(DrillDownQuery query, CollectorManager<?, R> hitCollectorManager) throws IOException {
        if (this.executor != null) {
            return this.searchConcurrently(query, hitCollectorManager);
        }
        return this.searchSequentially(query, hitCollectorManager);
    }

    private <R> ConcurrentDrillSidewaysResult<R> searchSequentially(DrillDownQuery query, CollectorManager<?, R> hitCollectorManager) throws IOException {
        Map<String, Integer> drillDownDims = query.getDims();
        if (drillDownDims.isEmpty()) {
            Object collectorResult;
            FacetsCollector mainFacetsCollector;
            FacetsCollectorManager drillDownCollectorManager = this.createDrillDownFacetsCollectorManager();
            if (drillDownCollectorManager != null) {
                Object[] mainResults = this.searcher.search((Query)query, new MultiCollectorManager(drillDownCollectorManager, hitCollectorManager));
                mainFacetsCollector = (FacetsCollector)mainResults[0];
                collectorResult = mainResults[1];
            } else {
                mainFacetsCollector = null;
                collectorResult = this.searcher.search((Query)query, hitCollectorManager);
            }
            return new ConcurrentDrillSidewaysResult<R>(this.buildFacetsResult(mainFacetsCollector, null, null), null, collectorResult, mainFacetsCollector, null, null);
        }
        Query baseQuery = query.getBaseQuery();
        if (baseQuery == null) {
            baseQuery = new MatchAllDocsQuery();
        }
        Query[] drillDownQueries = query.getDrillDownQueries();
        int numDims = drillDownDims.size();
        FacetsCollectorManager drillDownCollectorManager = this.createDrillDownFacetsCollectorManager();
        FacetsCollectorManager[] drillSidewaysFacetsCollectorManagers = new FacetsCollectorManager[numDims];
        for (int i = 0; i < numDims; ++i) {
            drillSidewaysFacetsCollectorManagers[i] = new FacetsCollectorManager();
        }
        DrillSidewaysQuery dsq = new DrillSidewaysQuery(baseQuery, drillDownCollectorManager, drillSidewaysFacetsCollectorManagers, drillDownQueries, this.scoreSubDocsAtOnce());
        R collectorResult = this.searcher.search((Query)dsq, hitCollectorManager);
        Object drillDownCollector = drillDownCollectorManager != null ? drillDownCollectorManager.reduce(dsq.managedDrillDownCollectors) : null;
        FacetsCollector[] drillSidewaysCollectors = new FacetsCollector[numDims];
        int numSlices = dsq.managedDrillSidewaysCollectors.size();
        for (int dim = 0; dim < numDims; ++dim) {
            ArrayList<FacetsCollector> facetsCollectorsForDim = new ArrayList<FacetsCollector>(numSlices);
            for (int slice = 0; slice < numSlices; ++slice) {
                facetsCollectorsForDim.add(dsq.managedDrillSidewaysCollectors.get(slice)[dim]);
            }
            drillSidewaysCollectors[dim] = drillSidewaysFacetsCollectorManagers[dim].reduce(facetsCollectorsForDim);
        }
        String[] drillSidewaysDims = drillDownDims.keySet().toArray(new String[0]);
        return new ConcurrentDrillSidewaysResult<R>(this.buildFacetsResult((FacetsCollector)drillDownCollector, drillSidewaysCollectors, drillSidewaysDims), null, collectorResult, (FacetsCollector)drillDownCollector, drillSidewaysCollectors, drillSidewaysDims);
    }

    private <R> ConcurrentDrillSidewaysResult<R> searchConcurrently(DrillDownQuery query, CollectorManager<?, R> hitCollectorManager) throws IOException {
        Object collectorResult;
        FacetsCollector mainFacetsCollector;
        Map<String, Integer> drillDownDims = query.getDims();
        ArrayList<CallableCollector> callableCollectors = new ArrayList<CallableCollector>(drillDownDims.size() + 1);
        FacetsCollectorManager drillDownFacetsCollectorManager = this.createDrillDownFacetsCollectorManager();
        MultiCollectorManager mainCollectorManager = drillDownFacetsCollectorManager != null ? new MultiCollectorManager(drillDownFacetsCollectorManager, hitCollectorManager) : hitCollectorManager;
        callableCollectors.add(new CallableCollector(-1, this.searcher, query, mainCollectorManager));
        int i = 0;
        Query[] filters = query.getDrillDownQueries();
        for (String dim : drillDownDims.keySet()) {
            callableCollectors.add(new CallableCollector(i++, this.searcher, this.getDrillDownQuery(query, filters, dim), new FacetsCollectorManager()));
        }
        FacetsCollector[] facetsCollectors = new FacetsCollector[drillDownDims.size()];
        try {
            List futures = this.executor.invokeAll(callableCollectors);
            if (drillDownFacetsCollectorManager != null) {
                Object[] mainResults = (Object[])((CallableResult)futures.get((int)0).get()).result;
                mainFacetsCollector = (FacetsCollector)mainResults[0];
                collectorResult = mainResults[1];
            } else {
                mainFacetsCollector = null;
                collectorResult = ((CallableResult)futures.get((int)0).get()).result;
            }
            for (i = 1; i < futures.size(); ++i) {
                CallableResult result = (CallableResult)futures.get(i).get();
                facetsCollectors[result.pos] = (FacetsCollector)result.result;
            }
            for (i = 0; i < facetsCollectors.length; ++i) {
                if (facetsCollectors[i] != null) continue;
                facetsCollectors[i] = mainFacetsCollector;
            }
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        String[] drillSidewaysDims = drillDownDims.keySet().toArray(new String[0]);
        return new ConcurrentDrillSidewaysResult<Object>(this.buildFacetsResult(mainFacetsCollector, facetsCollectors, drillSidewaysDims), null, collectorResult, mainFacetsCollector, facetsCollectors, drillSidewaysDims);
    }

    public static class ConcurrentDrillSidewaysResult<R>
    extends DrillSidewaysResult {
        public final R collectorResult;

        ConcurrentDrillSidewaysResult(Facets facets, TopDocs hits, R collectorResult, FacetsCollector drillDownFacetsCollector, FacetsCollector[] drillSidewaysFacetsCollector, String[] drillSidewaysDims) {
            super(facets, hits, drillDownFacetsCollector, drillSidewaysFacetsCollector, drillSidewaysDims);
            this.collectorResult = collectorResult;
        }
    }

    private static class CallableResult {
        private final int pos;
        private final Object result;

        private CallableResult(int pos, Object result) {
            this.pos = pos;
            this.result = result;
        }
    }

    private static class CallableCollector
    implements Callable<CallableResult> {
        private final int pos;
        private final IndexSearcher searcher;
        private final Query query;
        private final CollectorManager<?, ?> collectorManager;

        private CallableCollector(int pos, IndexSearcher searcher, Query query, CollectorManager<?, ?> collectorManager) {
            this.pos = pos;
            this.searcher = searcher;
            this.query = query;
            this.collectorManager = collectorManager;
        }

        @Override
        public CallableResult call() throws Exception {
            return new CallableResult(this.pos, this.searcher.search(this.query, this.collectorManager));
        }
    }

    public static class DrillSidewaysResult {
        public final Facets facets;
        public final TopDocs hits;
        public final FacetsCollector drillDownFacetsCollector;
        public final FacetsCollector[] drillSidewaysFacetsCollector;
        public final String[] drillSidewaysDims;

        public DrillSidewaysResult(Facets facets, TopDocs hits, FacetsCollector drillDownFacetsCollector, FacetsCollector[] drillSidewaysFacetsCollector, String[] drillSidewaysDims) {
            this.facets = facets;
            this.hits = hits;
            this.drillDownFacetsCollector = drillDownFacetsCollector;
            this.drillSidewaysFacetsCollector = drillSidewaysFacetsCollector;
            this.drillSidewaysDims = drillSidewaysDims;
        }
    }
}

