/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import com.carrotsearch.hppc.FloatArrayList;
import com.carrotsearch.hppc.IntArrayList;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.TopOrdAndFloatQueue;
import org.apache.lucene.facet.taxonomy.AssociationAggregationFunction;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.TaxonomyFacets;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.util.PriorityQueue;

@Deprecated
public abstract class FloatTaxonomyFacets
extends TaxonomyFacets {
    protected final AssociationAggregationFunction aggregationFunction;
    protected final float[] values;

    protected FloatTaxonomyFacets(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config) throws IOException {
        super(indexFieldName, taxoReader, config);
        this.aggregationFunction = AssociationAggregationFunction.SUM;
        this.values = new float[taxoReader.getSize()];
    }

    protected FloatTaxonomyFacets(String indexFieldName, TaxonomyReader taxoReader, AssociationAggregationFunction aggregationFunction, FacetsConfig config) throws IOException {
        super(indexFieldName, taxoReader, config);
        this.aggregationFunction = aggregationFunction;
        this.values = new float[taxoReader.getSize()];
    }

    protected void rollup() throws IOException {
        int[] children = this.getChildren();
        for (Map.Entry<String, FacetsConfig.DimConfig> ent : this.config.getDimConfigs().entrySet()) {
            float newValue;
            String dim = ent.getKey();
            FacetsConfig.DimConfig ft = ent.getValue();
            if (!ft.hierarchical || ft.multiValued) continue;
            int dimRootOrd = this.taxoReader.getOrdinal(new FacetLabel(dim));
            assert (dimRootOrd > 0);
            this.values[dimRootOrd] = newValue = this.aggregationFunction.aggregate(this.values[dimRootOrd], this.rollup(children[dimRootOrd]));
        }
    }

    private float rollup(int ord) throws IOException {
        int[] children = this.getChildren();
        int[] siblings = this.getSiblings();
        float aggregationValue = 0.0f;
        while (ord != -1) {
            float childValue;
            this.values[ord] = childValue = this.aggregationFunction.aggregate(this.values[ord], this.rollup(children[ord]));
            aggregationValue = this.aggregationFunction.aggregate(aggregationValue, childValue);
            ord = siblings[ord];
        }
        return aggregationValue;
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        FacetsConfig.DimConfig dimConfig = this.verifyDim(dim);
        if (!(path.length != 0 || dimConfig.hierarchical && !dimConfig.multiValued || dimConfig.requireDimCount && dimConfig.multiValued)) {
            throw new IllegalArgumentException("cannot return dimension-level value alone; use getTopChildren instead");
        }
        int ord = this.taxoReader.getOrdinal(new FacetLabel(dim, path));
        if (ord < 0) {
            return -1;
        }
        return Float.valueOf(this.values[ord]);
    }

    @Override
    public FacetResult getAllChildren(String dim, String ... path) throws IOException {
        FacetsConfig.DimConfig dimConfig = this.verifyDim(dim);
        FacetLabel cp = new FacetLabel(dim, path);
        int dimOrd = this.taxoReader.getOrdinal(cp);
        if (dimOrd == -1) {
            return null;
        }
        int[] children = this.getChildren();
        int[] siblings = this.getSiblings();
        int ord = children[dimOrd];
        float aggregatedValue = 0.0f;
        IntArrayList ordinals = new IntArrayList();
        FloatArrayList ordValues = new FloatArrayList();
        while (ord != -1) {
            if (this.values[ord] > 0.0f) {
                aggregatedValue = this.aggregationFunction.aggregate(aggregatedValue, this.values[ord]);
                ordinals.add(ord);
                ordValues.add(this.values[ord]);
            }
            ord = siblings[ord];
        }
        if (aggregatedValue == 0.0f) {
            return null;
        }
        if (dimConfig.multiValued) {
            aggregatedValue = dimConfig.requireDimCount ? this.values[dimOrd] : -1.0f;
        }
        FacetLabel[] bulkPath = this.taxoReader.getBulkPath(ordinals.toArray());
        LabelAndValue[] labelValues = new LabelAndValue[ordValues.size()];
        for (int i = 0; i < labelValues.length; ++i) {
            labelValues[i] = new LabelAndValue(bulkPath[i].components[cp.length], Float.valueOf(ordValues.get(i)));
        }
        return new FacetResult(dim, path, Float.valueOf(aggregatedValue), labelValues, ordinals.size());
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        FloatTaxonomyFacets.validateTopN(topN);
        FacetsConfig.DimConfig dimConfig = this.verifyDim(dim);
        FacetLabel cp = new FacetLabel(dim, path);
        int dimOrd = this.taxoReader.getOrdinal(cp);
        if (dimOrd == -1) {
            return null;
        }
        TopChildrenForPath topChildrenForPath = this.getTopChildrenForPath(dimConfig, dimOrd, topN);
        return this.createFacetResult(topChildrenForPath, dim, path);
    }

    private TopChildrenForPath getTopChildrenForPath(FacetsConfig.DimConfig dimConfig, int pathOrd, int topN) throws IOException {
        TopOrdAndFloatQueue q = new TopOrdAndFloatQueue(Math.min(this.taxoReader.getSize(), topN));
        float bottomValue = 0.0f;
        int bottomOrd = Integer.MAX_VALUE;
        int[] children = this.getChildren();
        int[] siblings = this.getSiblings();
        int ord = children[pathOrd];
        float aggregatedValue = 0.0f;
        int childCount = 0;
        TopOrdAndFloatQueue.OrdAndValue reuse = null;
        while (ord != -1) {
            float value = this.values[ord];
            if (value > 0.0f) {
                aggregatedValue = this.aggregationFunction.aggregate(aggregatedValue, value);
                ++childCount;
                if (value > bottomValue || value == bottomValue && ord < bottomOrd) {
                    if (reuse == null) {
                        reuse = new TopOrdAndFloatQueue.OrdAndValue();
                    }
                    reuse.ord = ord;
                    reuse.value = value;
                    reuse = q.insertWithOverflow(reuse);
                    if (q.size() == topN) {
                        bottomValue = ((TopOrdAndFloatQueue.OrdAndValue)q.top()).value;
                        bottomOrd = ((TopOrdAndFloatQueue.OrdAndValue)q.top()).ord;
                    }
                }
            }
            ord = siblings[ord];
        }
        if (dimConfig.multiValued) {
            aggregatedValue = dimConfig.requireDimCount ? this.values[pathOrd] : -1.0f;
        }
        return new TopChildrenForPath(aggregatedValue, childCount, q);
    }

    FacetResult createFacetResult(TopChildrenForPath topChildrenForPath, String dim, String ... path) throws IOException {
        if (topChildrenForPath == null || topChildrenForPath.childCount == 0) {
            return null;
        }
        TopOrdAndFloatQueue q = topChildrenForPath.childQueue;
        assert (q != null);
        LabelAndValue[] labelValues = new LabelAndValue[q.size()];
        int[] ordinals = new int[labelValues.length];
        float[] values = new float[labelValues.length];
        for (int i = labelValues.length - 1; i >= 0; --i) {
            TopOrdAndFloatQueue.OrdAndValue ordAndValue = (TopOrdAndFloatQueue.OrdAndValue)q.pop();
            assert (ordAndValue != null);
            ordinals[i] = ordAndValue.ord;
            values[i] = ordAndValue.value;
        }
        FacetLabel[] bulkPath = this.taxoReader.getBulkPath(ordinals);
        int childComponentIdx = path.length + 1;
        for (int i = 0; i < labelValues.length; ++i) {
            labelValues[i] = new LabelAndValue(bulkPath[i].components[childComponentIdx], Float.valueOf(values[i]));
        }
        return new FacetResult(dim, path, Float.valueOf(topChildrenForPath.pathValue), labelValues, topChildrenForPath.childCount);
    }

    @Override
    public List<FacetResult> getTopDims(int topNDims, int topNChildren) throws IOException {
        FloatTaxonomyFacets.validateTopN(topNDims);
        FloatTaxonomyFacets.validateTopN(topNChildren);
        int[] children = this.getChildren();
        int[] siblings = this.getSiblings();
        PriorityQueue<DimValue> pq = new PriorityQueue<DimValue>(topNDims){

            @Override
            protected boolean lessThan(DimValue a, DimValue b) {
                if (a.value > b.value) {
                    return false;
                }
                if (a.value < b.value) {
                    return true;
                }
                return a.dim.compareTo(b.dim) > 0;
            }
        };
        HashMap<String, TopChildrenForPath> intermediateResults = null;
        int ord = children[0];
        while (ord != -1) {
            FacetLabel cp;
            int dimOrd;
            String dim = this.taxoReader.getPath((int)ord).components[0];
            FacetsConfig.DimConfig dimConfig = this.config.getDimConfig(dim);
            if (dimConfig.indexFieldName.equals(this.indexFieldName) && (dimOrd = this.taxoReader.getOrdinal(cp = new FacetLabel(dim))) != -1) {
                float dimValue;
                if (dimConfig.multiValued) {
                    dimValue = dimConfig.requireDimCount ? this.values[dimOrd] : -1.0f;
                } else {
                    TopChildrenForPath topChildrenForPath = this.getTopChildrenForPath(dimConfig, dimOrd, topNChildren);
                    if (intermediateResults == null) {
                        intermediateResults = new HashMap<String, TopChildrenForPath>();
                    }
                    intermediateResults.put(dim, topChildrenForPath);
                    dimValue = topChildrenForPath.pathValue;
                }
                if (dimValue != 0.0f) {
                    if (pq.size() < topNDims) {
                        pq.add(new DimValue(dim, dimOrd, dimValue));
                    } else if (dimValue > ((DimValue)pq.top()).value || dimValue == ((DimValue)pq.top()).value && dim.compareTo(((DimValue)pq.top()).dim) < 0) {
                        DimValue bottomDim = (DimValue)pq.top();
                        bottomDim.dim = dim;
                        bottomDim.value = dimValue;
                        pq.updateTop();
                    }
                }
            }
            ord = siblings[ord];
        }
        FacetResult[] results = new FacetResult[pq.size()];
        while (pq.size() > 0) {
            DimValue dimValue = (DimValue)pq.pop();
            assert (dimValue != null);
            String dim = dimValue.dim;
            TopChildrenForPath topChildrenForPath = null;
            if (intermediateResults != null) {
                topChildrenForPath = (TopChildrenForPath)intermediateResults.get(dim);
            }
            if (topChildrenForPath == null) {
                FacetsConfig.DimConfig dimConfig = this.config.getDimConfig(dim);
                topChildrenForPath = this.getTopChildrenForPath(dimConfig, dimValue.dimOrd, topNChildren);
            }
            FacetResult facetResult = this.createFacetResult(topChildrenForPath, dim, new String[0]);
            assert (facetResult != null);
            results[pq.size()] = facetResult;
        }
        return Arrays.asList(results);
    }

    private static class TopChildrenForPath {
        private final float pathValue;
        private final int childCount;
        private final TopOrdAndFloatQueue childQueue;

        TopChildrenForPath(float pathValue, int childCount, TopOrdAndFloatQueue childQueue) {
            this.pathValue = pathValue;
            this.childCount = childCount;
            this.childQueue = childQueue;
        }
    }

    private static class DimValue {
        String dim;
        int dimOrd;
        float value;

        DimValue(String dim, int dimOrd, float value) {
            this.dim = dim;
            this.dimOrd = dimOrd;
            this.value = value;
        }
    }
}

