/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.TopOrdAndIntQueue;
import org.apache.lucene.facet.taxonomy.AssociationAggregationFunction;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.TaxonomyFacets;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.util.PriorityQueue;

@Deprecated
public abstract class IntTaxonomyFacets
extends TaxonomyFacets {
    protected final AssociationAggregationFunction aggregationFunction;
    protected final int[] values;
    protected final IntIntHashMap sparseValues;

    protected IntTaxonomyFacets(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc) throws IOException {
        super(indexFieldName, taxoReader, config);
        this.aggregationFunction = AssociationAggregationFunction.SUM;
        if (this.useHashTable(fc, taxoReader)) {
            this.sparseValues = new IntIntHashMap();
            this.values = null;
        } else {
            this.sparseValues = null;
            this.values = new int[taxoReader.getSize()];
        }
    }

    protected IntTaxonomyFacets(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, AssociationAggregationFunction aggregationFunction, FacetsCollector fc) throws IOException {
        super(indexFieldName, taxoReader, config);
        this.aggregationFunction = aggregationFunction;
        if (this.useHashTable(fc, taxoReader)) {
            this.sparseValues = new IntIntHashMap();
            this.values = null;
        } else {
            this.sparseValues = null;
            this.values = new int[taxoReader.getSize()];
        }
    }

    protected boolean useHashTable(FacetsCollector fc, TaxonomyReader taxoReader) {
        if (taxoReader.getSize() < 1024) {
            return false;
        }
        if (fc == null) {
            return false;
        }
        int maxDoc = 0;
        int sumTotalHits = 0;
        for (FacetsCollector.MatchingDocs docs : fc.getMatchingDocs()) {
            sumTotalHits += docs.totalHits;
            maxDoc += docs.context.reader().maxDoc();
        }
        return sumTotalHits < maxDoc / 10;
    }

    protected void increment(int ordinal) {
        this.increment(ordinal, 1);
    }

    protected void increment(int ordinal, int amount) {
        if (this.sparseValues != null) {
            this.sparseValues.addTo(ordinal, amount);
        } else {
            int n = ordinal;
            this.values[n] = this.values[n] + amount;
        }
    }

    void setValue(int ordinal, int newValue) {
        if (this.sparseValues != null) {
            this.sparseValues.put(ordinal, newValue);
        } else {
            this.values[ordinal] = newValue;
        }
    }

    protected int getValue(int ordinal) {
        if (this.sparseValues != null) {
            return this.sparseValues.get(ordinal);
        }
        return this.values[ordinal];
    }

    protected void rollup() throws IOException {
        int[] children = null;
        for (Map.Entry<String, FacetsConfig.DimConfig> ent : this.config.getDimConfigs().entrySet()) {
            int dimRootOrd;
            String dim = ent.getKey();
            FacetsConfig.DimConfig ft = ent.getValue();
            if (!ft.hierarchical || ft.multiValued || (dimRootOrd = this.taxoReader.getOrdinal(new FacetLabel(dim))) <= 0) continue;
            if (children == null) {
                children = this.getChildren();
            }
            int currentValue = this.getValue(dimRootOrd);
            int newValue = this.aggregationFunction.aggregate(currentValue, this.rollup(children[dimRootOrd]));
            this.setValue(dimRootOrd, newValue);
        }
    }

    private int rollup(int ord) throws IOException {
        int[] children = this.getChildren();
        int[] siblings = this.getSiblings();
        int aggregatedValue = 0;
        while (ord != -1) {
            int currentValue = this.getValue(ord);
            int newValue = this.aggregationFunction.aggregate(currentValue, this.rollup(children[ord]));
            this.setValue(ord, newValue);
            aggregatedValue = this.aggregationFunction.aggregate(aggregatedValue, this.getValue(ord));
            ord = siblings[ord];
        }
        return aggregatedValue;
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        FacetsConfig.DimConfig dimConfig = this.verifyDim(dim);
        if (!(path.length != 0 || dimConfig.hierarchical && !dimConfig.multiValued || dimConfig.requireDimCount && dimConfig.multiValued)) {
            throw new IllegalArgumentException("cannot return dimension-level value alone; use getTopChildren instead");
        }
        int ord = this.taxoReader.getOrdinal(new FacetLabel(dim, path));
        if (ord < 0) {
            return -1;
        }
        return this.getValue(ord);
    }

    @Override
    public FacetResult getAllChildren(String dim, String ... path) throws IOException {
        FacetsConfig.DimConfig dimConfig = this.verifyDim(dim);
        FacetLabel cp = new FacetLabel(dim, path);
        int dimOrd = this.taxoReader.getOrdinal(cp);
        if (dimOrd == -1) {
            return null;
        }
        int aggregatedValue = 0;
        IntArrayList ordinals = new IntArrayList();
        IntArrayList ordValues = new IntArrayList();
        if (this.sparseValues != null) {
            for (IntIntCursor c : this.sparseValues) {
                int value = c.value;
                int ord = c.key;
                if (this.parents[ord] != dimOrd || value <= 0) continue;
                aggregatedValue = this.aggregationFunction.aggregate(aggregatedValue, value);
                ordinals.add(ord);
                ordValues.add(value);
            }
        } else {
            int[] children = this.getChildren();
            int[] siblings = this.getSiblings();
            int ord = children[dimOrd];
            while (ord != -1) {
                int value = this.values[ord];
                if (value > 0) {
                    aggregatedValue = this.aggregationFunction.aggregate(aggregatedValue, value);
                    ordinals.add(ord);
                    ordValues.add(value);
                }
                ord = siblings[ord];
            }
        }
        if (aggregatedValue == 0) {
            return null;
        }
        if (dimConfig.multiValued) {
            aggregatedValue = dimConfig.requireDimCount ? this.getValue(dimOrd) : -1;
        }
        FacetLabel[] bulkPath = this.taxoReader.getBulkPath(ordinals.toArray());
        LabelAndValue[] labelValues = new LabelAndValue[ordValues.size()];
        for (int i = 0; i < ordValues.size(); ++i) {
            labelValues[i] = new LabelAndValue(bulkPath[i].components[cp.length], ordValues.get(i));
        }
        return new FacetResult(dim, path, aggregatedValue, labelValues, ordinals.size());
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        IntTaxonomyFacets.validateTopN(topN);
        FacetsConfig.DimConfig dimConfig = this.verifyDim(dim);
        FacetLabel cp = new FacetLabel(dim, path);
        int dimOrd = this.taxoReader.getOrdinal(cp);
        if (dimOrd == -1) {
            return null;
        }
        TopChildrenForPath topChildrenForPath = this.getTopChildrenForPath(dimConfig, dimOrd, topN);
        return this.createFacetResult(topChildrenForPath, dim, path);
    }

    private TopChildrenForPath getTopChildrenForPath(FacetsConfig.DimConfig dimConfig, int pathOrd, int topN) throws IOException {
        TopOrdAndIntQueue q = new TopOrdAndIntQueue(Math.min(this.taxoReader.getSize(), topN));
        int bottomValue = 0;
        int bottomOrd = Integer.MAX_VALUE;
        int aggregatedValue = 0;
        int childCount = 0;
        TopOrdAndIntQueue.OrdAndValue reuse = null;
        if (this.sparseValues != null) {
            for (IntIntCursor c : this.sparseValues) {
                int value = c.value;
                int ord = c.key;
                if (this.parents[ord] != pathOrd || value <= 0) continue;
                aggregatedValue = this.aggregationFunction.aggregate(aggregatedValue, value);
                ++childCount;
                if (value <= bottomValue && (value != bottomValue || ord >= bottomOrd)) continue;
                if (reuse == null) {
                    reuse = new TopOrdAndIntQueue.OrdAndValue();
                }
                reuse.ord = ord;
                reuse.value = value;
                reuse = q.insertWithOverflow(reuse);
                if (q.size() != topN) continue;
                bottomValue = ((TopOrdAndIntQueue.OrdAndValue)q.top()).value;
                bottomOrd = ((TopOrdAndIntQueue.OrdAndValue)q.top()).ord;
            }
        } else {
            int[] children = this.getChildren();
            int[] siblings = this.getSiblings();
            int ord = children[pathOrd];
            while (ord != -1) {
                int value = this.values[ord];
                if (value > 0) {
                    aggregatedValue = this.aggregationFunction.aggregate(aggregatedValue, value);
                    ++childCount;
                    if (value > bottomValue || value == bottomValue && ord < bottomOrd) {
                        if (reuse == null) {
                            reuse = new TopOrdAndIntQueue.OrdAndValue();
                        }
                        reuse.ord = ord;
                        reuse.value = value;
                        reuse = q.insertWithOverflow(reuse);
                        if (q.size() == topN) {
                            bottomValue = ((TopOrdAndIntQueue.OrdAndValue)q.top()).value;
                            bottomOrd = ((TopOrdAndIntQueue.OrdAndValue)q.top()).ord;
                        }
                    }
                }
                ord = siblings[ord];
            }
        }
        if (dimConfig.multiValued) {
            aggregatedValue = dimConfig.requireDimCount ? this.getValue(pathOrd) : -1;
        }
        return new TopChildrenForPath(aggregatedValue, childCount, q);
    }

    @Override
    public List<FacetResult> getTopDims(int topNDims, int topNChildren) throws IOException {
        if (topNDims <= 0 || topNChildren <= 0) {
            throw new IllegalArgumentException("topN must be > 0");
        }
        int[] children = this.getChildren();
        int[] siblings = this.getSiblings();
        PriorityQueue<DimValue> pq = new PriorityQueue<DimValue>(topNDims){

            @Override
            protected boolean lessThan(DimValue a, DimValue b) {
                if (a.value > b.value) {
                    return false;
                }
                if (a.value < b.value) {
                    return true;
                }
                return a.dim.compareTo(b.dim) > 0;
            }
        };
        HashMap<String, TopChildrenForPath> intermediateResults = null;
        int ord = children[0];
        while (ord != -1) {
            FacetLabel cp;
            int dimOrd;
            String dim = this.taxoReader.getPath((int)ord).components[0];
            FacetsConfig.DimConfig dimConfig = this.config.getDimConfig(dim);
            if (dimConfig.indexFieldName.equals(this.indexFieldName) && (dimOrd = this.taxoReader.getOrdinal(cp = new FacetLabel(dim))) != -1) {
                int dimValue;
                if (dimConfig.multiValued) {
                    dimValue = dimConfig.requireDimCount ? this.getValue(dimOrd) : -1;
                } else {
                    TopChildrenForPath topChildrenForPath = this.getTopChildrenForPath(dimConfig, dimOrd, topNChildren);
                    if (intermediateResults == null) {
                        intermediateResults = new HashMap<String, TopChildrenForPath>();
                    }
                    intermediateResults.put(dim, topChildrenForPath);
                    dimValue = topChildrenForPath.pathValue;
                }
                if (dimValue != 0) {
                    if (pq.size() < topNDims) {
                        pq.add(new DimValue(dim, dimOrd, dimValue));
                    } else if (dimValue > ((DimValue)pq.top()).value || dimValue == ((DimValue)pq.top()).value && dim.compareTo(((DimValue)pq.top()).dim) < 0) {
                        DimValue bottomDim = (DimValue)pq.top();
                        bottomDim.dim = dim;
                        bottomDim.value = dimValue;
                        pq.updateTop();
                    }
                }
            }
            ord = siblings[ord];
        }
        FacetResult[] results = new FacetResult[pq.size()];
        while (pq.size() > 0) {
            DimValue dimValue = (DimValue)pq.pop();
            assert (dimValue != null);
            String dim = dimValue.dim;
            TopChildrenForPath topChildrenForPath = null;
            if (intermediateResults != null) {
                topChildrenForPath = (TopChildrenForPath)intermediateResults.get(dim);
            }
            if (topChildrenForPath == null) {
                FacetsConfig.DimConfig dimConfig = this.config.getDimConfig(dim);
                topChildrenForPath = this.getTopChildrenForPath(dimConfig, dimValue.dimOrd, topNChildren);
            }
            FacetResult facetResult = this.createFacetResult(topChildrenForPath, dim, new String[0]);
            assert (facetResult != null);
            results[pq.size()] = facetResult;
        }
        return Arrays.asList(results);
    }

    FacetResult createFacetResult(TopChildrenForPath topChildrenForPath, String dim, String ... path) throws IOException {
        if (topChildrenForPath == null || topChildrenForPath.childCount == 0) {
            return null;
        }
        TopOrdAndIntQueue q = topChildrenForPath.childQueue;
        assert (q != null);
        LabelAndValue[] labelValues = new LabelAndValue[q.size()];
        int[] ordinals = new int[labelValues.length];
        int[] values = new int[labelValues.length];
        for (int i = labelValues.length - 1; i >= 0; --i) {
            TopOrdAndIntQueue.OrdAndValue ordAndValue = (TopOrdAndIntQueue.OrdAndValue)q.pop();
            assert (ordAndValue != null);
            ordinals[i] = ordAndValue.ord;
            values[i] = ordAndValue.value;
        }
        FacetLabel[] bulkPath = this.taxoReader.getBulkPath(ordinals);
        int childComponentIdx = path.length + 1;
        for (int i = 0; i < labelValues.length; ++i) {
            labelValues[i] = new LabelAndValue(bulkPath[i].components[childComponentIdx], values[i]);
        }
        return new FacetResult(dim, path, topChildrenForPath.pathValue, labelValues, topChildrenForPath.childCount);
    }

    private static class TopChildrenForPath {
        private final int pathValue;
        private final int childCount;
        private final TopOrdAndIntQueue childQueue;

        TopChildrenForPath(int pathValue, int childCount, TopOrdAndIntQueue childQueue) {
            this.pathValue = pathValue;
            this.childCount = childCount;
            this.childQueue = childQueue;
        }
    }

    private static class DimValue {
        String dim;
        int dimOrd;
        int value;

        DimValue(String dim, int dimOrd, int value) {
            this.dim = dim;
            this.dimOrd = dimOrd;
            this.value = value;
        }
    }
}

