/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.AssociationAggregationFunction;
import org.apache.lucene.facet.taxonomy.IntTaxonomyFacets;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;

public class TaxonomyFacetIntAssociations
extends IntTaxonomyFacets {
    public TaxonomyFacetIntAssociations(TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction) throws IOException {
        this("$facets", taxoReader, config, fc, aggregationFunction);
    }

    public TaxonomyFacetIntAssociations(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction) throws IOException {
        super(indexFieldName, taxoReader, config, aggregationFunction, fc);
        this.aggregateValues(aggregationFunction, fc.getMatchingDocs());
    }

    private void aggregateValues(AssociationAggregationFunction aggregationFunction, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            BinaryDocValues dv = DocValues.getBinary(hits.context.reader(), this.indexFieldName);
            DocIdSetIterator it = ConjunctionUtils.intersectIterators(List.of(hits.bits.iterator(), dv));
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                BytesRef bytesRef = dv.binaryValue();
                byte[] bytes = bytesRef.bytes;
                int end = bytesRef.offset + bytesRef.length;
                for (int offset = bytesRef.offset; offset < end; offset += 4) {
                    int ord = BitUtil.VH_BE_INT.get(bytes, offset);
                    int value = BitUtil.VH_BE_INT.get(bytes, offset += 4);
                    int currentValue = this.getValue(ord);
                    int newValue = aggregationFunction.aggregate(currentValue, value);
                    this.setValue(ord, newValue);
                }
                doc = it.nextDoc();
            }
        }
    }
}

