/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

abstract class BaseGlobalOrdinalScorer
extends Scorer {
    final SortedDocValues values;
    final DocIdSetIterator approximation;
    final float boost;
    float score;

    public BaseGlobalOrdinalScorer(Weight weight, SortedDocValues values, DocIdSetIterator approximationScorer, float boost) {
        super(weight);
        this.values = values;
        this.approximation = approximationScorer;
        this.boost = boost;
    }

    @Override
    public float score() throws IOException {
        return this.score * this.boost;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return Float.POSITIVE_INFINITY;
    }

    @Override
    public int docID() {
        return this.approximation.docID();
    }

    @Override
    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator());
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return this.createTwoPhaseIterator(this.approximation);
    }

    protected abstract TwoPhaseIterator createTwoPhaseIterator(DocIdSetIterator var1);
}

