/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d;

import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.SortField;
import org.apache.lucene.spatial3d.Geo3DPointOutsideDistanceComparator;
import org.apache.lucene.spatial3d.Geo3DPointSortField;
import org.apache.lucene.spatial3d.geom.GeoOutsideDistance;
import org.apache.lucene.spatial3d.geom.PlanetModel;

final class Geo3DPointOutsideSortField
extends SortField {
    final GeoOutsideDistance distanceShape;
    private final PlanetModel planetModel;

    Geo3DPointOutsideSortField(String field, PlanetModel planetModel, GeoOutsideDistance distanceShape) {
        super(field, SortField.Type.CUSTOM);
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (distanceShape == null) {
            throw new IllegalArgumentException("distanceShape must not be null");
        }
        this.planetModel = planetModel;
        this.distanceShape = distanceShape;
        this.setMissingValue(Double.POSITIVE_INFINITY);
    }

    @Override
    public FieldComparator<?> getComparator(int numHits, Pruning pruning) {
        return new Geo3DPointOutsideDistanceComparator(this.getField(), this.planetModel, this.distanceShape, numHits);
    }

    @Override
    public Double getMissingValue() {
        return (Double)super.getMissingValue();
    }

    @Override
    public void setMissingValue(Object missingValue) {
        if (!Double.valueOf(Double.POSITIVE_INFINITY).equals(missingValue)) {
            throw new IllegalArgumentException("Missing value can only be Double.POSITIVE_INFINITY (missing values last), but got " + missingValue);
        }
        this.missingValue = missingValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = this.distanceShape.hashCode();
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Geo3DPointSortField other = (Geo3DPointSortField)obj;
        return this.distanceShape.equals(other.distanceShape);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<outsideDistanceShape:");
        builder.append('\"');
        builder.append(this.getField());
        builder.append('\"');
        builder.append(" shape=");
        builder.append(this.distanceShape);
        if (Double.POSITIVE_INFINITY != this.getMissingValue()) {
            builder.append(" missingValue=").append(this.getMissingValue());
        }
        builder.append('>');
        return builder.toString();
    }
}

