/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.ReversedWildcardFilter;

public class ReversedWildcardFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "reversedWildcard";
    private char markerChar = '\u0001';
    private boolean withOriginal;
    private int maxPosAsterisk;
    private int maxPosQuestion;
    private int minTrailing;
    private float maxFractionAsterisk;

    public ReversedWildcardFilterFactory(Map<String, String> args) {
        super(args);
        this.withOriginal = this.getBoolean(args, "withOriginal", true);
        this.maxPosAsterisk = this.getInt(args, "maxPosAsterisk", 2);
        this.maxPosQuestion = this.getInt(args, "maxPosQuestion", 1);
        this.minTrailing = this.getInt(args, "minTrailing", 2);
        this.maxFractionAsterisk = this.getFloat(args, "maxFractionAsterisk", 0.0f);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public ReversedWildcardFilterFactory() {
        throw ReversedWildcardFilterFactory.defaultCtorException();
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new ReversedWildcardFilter(input, this.withOriginal, this.markerChar);
    }

    public boolean shouldReverse(String token) {
        int posQ = token.indexOf(63);
        int posA = token.indexOf(42);
        if (posQ == -1 && posA == -1) {
            return false;
        }
        int len = token.length();
        int lastPos = token.lastIndexOf(63);
        int pos = token.lastIndexOf(42);
        if (pos > lastPos) {
            lastPos = pos;
        }
        if (posQ != -1) {
            pos = posQ;
            if (posA != -1) {
                pos = Math.min(posQ, posA);
            }
        } else {
            pos = posA;
        }
        if (len - lastPos < this.minTrailing) {
            return false;
        }
        if (posQ != -1 && posQ < this.maxPosQuestion) {
            return true;
        }
        if (posA != -1 && posA < this.maxPosAsterisk) {
            return true;
        }
        return this.maxFractionAsterisk > 0.0f && (float)pos < (float)token.length() * this.maxFractionAsterisk;
    }

    public char getMarkerChar() {
        return this.markerChar;
    }
}

