/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.StatusTool;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.HealthCheckRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertTool
extends ToolBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static String message = null;
    private static boolean useExitCode = false;
    private static Long timeoutMs = 1000L;

    public AssertTool() {
        this(CLIO.getOutStream());
    }

    public AssertTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public String getName() {
        return "assert";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder((String)"R").desc("Asserts that we are NOT the root user.").longOpt("not-root").build(), Option.builder((String)"r").desc("Asserts that we are the root user.").longOpt("root").build(), Option.builder((String)"S").desc("Asserts that Solr is NOT running on a certain URL. Default timeout is 1000ms.").longOpt("not-started").hasArg(true).argName("url").build(), Option.builder((String)"s").desc("Asserts that Solr is running on a certain URL. Default timeout is 1000ms.").longOpt("started").hasArg(true).argName("url").build(), Option.builder((String)"u").desc("Asserts that we run as same user that owns <directory>.").longOpt("same-user").hasArg(true).argName("directory").build(), Option.builder((String)"x").desc("Asserts that directory <directory> exists.").longOpt("exists").hasArg(true).argName("directory").build(), Option.builder((String)"X").desc("Asserts that directory <directory> does NOT exist.").longOpt("not-exists").hasArg(true).argName("directory").build(), Option.builder((String)"c").desc("Asserts that Solr is running in cloud mode.  Also fails if Solr not running.  URL should be for root Solr path.").longOpt("cloud").hasArg(true).argName("url").build(), Option.builder((String)"C").desc("Asserts that Solr is not running in cloud mode.  Also fails if Solr not running.  URL should be for root Solr path.").longOpt("not-cloud").hasArg(true).argName("url").build(), Option.builder((String)"m").desc("Exception message to be used in place of the default error message.").longOpt("message").hasArg(true).argName("message").build(), Option.builder((String)"t").desc("Timeout in ms for commands supporting a timeout.").longOpt("timeout").hasArg(true).type(Long.class).argName("ms").build(), Option.builder((String)"e").desc("Return an exit code instead of printing error message on assert fail.").longOpt("exitcode").build());
    }

    @Override
    public int runTool(CommandLine cli) throws Exception {
        this.verbose = cli.hasOption(SolrCLI.OPTION_VERBOSE.getOpt());
        int toolExitStatus = 0;
        try {
            toolExitStatus = this.runAssert(cli);
        }
        catch (Exception exc) {
            String excMsg = exc.getMessage();
            if (excMsg != null) {
                if (this.verbose) {
                    CLIO.err("\nERROR: " + exc + "\n");
                } else {
                    CLIO.err("\nERROR: " + excMsg + "\n");
                }
                toolExitStatus = 100;
            }
            throw exc;
        }
        return toolExitStatus;
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        this.runAssert(cli);
    }

    protected int runAssert(CommandLine cli) throws Exception {
        if (cli.getOptions().length == 0 || cli.getArgs().length > 0 || cli.hasOption("h")) {
            new HelpFormatter().printHelp("bin/solr assert [-m <message>] [-e] [-rR] [-s <url>] [-S <url>] [-c <url>] [-C <url>] [-u <dir>] [-x <dir>] [-X <dir>]", SolrCLI.getToolOptions(this));
            return 1;
        }
        if (cli.hasOption("m")) {
            message = cli.getOptionValue("m");
        }
        if (cli.hasOption("t")) {
            timeoutMs = Long.parseLong(cli.getOptionValue("t"));
        }
        if (cli.hasOption("e")) {
            useExitCode = true;
        }
        int ret = 0;
        if (cli.hasOption("r")) {
            ret += AssertTool.assertRootUser();
        }
        if (cli.hasOption("R")) {
            ret += AssertTool.assertNotRootUser();
        }
        if (cli.hasOption("x")) {
            ret += AssertTool.assertFileExists(cli.getOptionValue("x"));
        }
        if (cli.hasOption("X")) {
            ret += AssertTool.assertFileNotExists(cli.getOptionValue("X"));
        }
        if (cli.hasOption("u")) {
            ret += AssertTool.sameUser(cli.getOptionValue("u"));
        }
        if (cli.hasOption("s")) {
            ret += AssertTool.assertSolrRunning(cli.getOptionValue("s"));
        }
        if (cli.hasOption("S")) {
            ret += AssertTool.assertSolrNotRunning(cli.getOptionValue("S"));
        }
        if (cli.hasOption("c")) {
            ret += AssertTool.assertSolrRunningInCloudMode(cli.getOptionValue("c"));
        }
        if (cli.hasOption("C")) {
            ret += AssertTool.assertSolrNotRunningInCloudMode(cli.getOptionValue("C"));
        }
        return ret;
    }

    public static int assertSolrRunning(String url) throws Exception {
        StatusTool status = new StatusTool();
        try {
            status.waitToSeeSolrUp(url, timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (Exception se) {
            if (SolrCLI.exceptionIsAuthRelated(se)) {
                throw se;
            }
            return AssertTool.exitOrException("Solr is not running on url " + url + " after " + TimeUnit.SECONDS.convert(timeoutMs, TimeUnit.MILLISECONDS) + " seconds");
        }
        return 0;
    }

    public static int assertSolrNotRunning(String url) throws Exception {
        StatusTool status = new StatusTool();
        long timeout = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeoutMs, TimeUnit.MILLISECONDS);
        try (SolrClient solrClient = SolrCLI.getSolrClient(url);){
            NamedList<Object> response = solrClient.request(new HealthCheckRequest());
            Integer statusCode = (Integer)response.findRecursive("responseHeader", "status");
            SolrCLI.checkCodeForAuthError(statusCode);
        }
        catch (IOException | SolrServerException e) {
            log.debug("Opening connection to {} failed, Solr does not seem to be running", (Object)url, (Object)e);
            return 0;
        }
        while (System.nanoTime() < timeout) {
            try {
                status.waitToSeeSolrUp(url, 1L, TimeUnit.SECONDS);
                try {
                    log.debug("Solr still up. Waiting before trying again to see if it was stopped");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interrupted) {
                    timeout = 0L;
                }
            }
            catch (Exception se) {
                if (SolrCLI.exceptionIsAuthRelated(se)) {
                    throw se;
                }
                return AssertTool.exitOrException(se.getMessage());
            }
        }
        return AssertTool.exitOrException("Solr is still running at " + url + " after " + TimeUnit.SECONDS.convert(timeoutMs, TimeUnit.MILLISECONDS) + " seconds");
    }

    public static int assertSolrRunningInCloudMode(String url) throws Exception {
        if (!AssertTool.isSolrRunningOn(url)) {
            return AssertTool.exitOrException("Solr is not running on url " + url + " after " + TimeUnit.SECONDS.convert(timeoutMs, TimeUnit.MILLISECONDS) + " seconds");
        }
        if (!AssertTool.runningSolrIsCloud(url)) {
            return AssertTool.exitOrException("Solr is not running in cloud mode on " + url);
        }
        return 0;
    }

    public static int assertSolrNotRunningInCloudMode(String url) throws Exception {
        if (!AssertTool.isSolrRunningOn(url)) {
            return AssertTool.exitOrException("Solr is not running on url " + url + " after " + TimeUnit.SECONDS.convert(timeoutMs, TimeUnit.MILLISECONDS) + " seconds");
        }
        if (AssertTool.runningSolrIsCloud(url)) {
            return AssertTool.exitOrException("Solr is not running in standalone mode on " + url);
        }
        return 0;
    }

    public static int sameUser(String directory) throws Exception {
        if (Files.exists(Paths.get(directory, new String[0]), new LinkOption[0])) {
            String userForDir = AssertTool.userForDir(Paths.get(directory, new String[0]));
            if (!AssertTool.currentUser().equals(userForDir)) {
                return AssertTool.exitOrException("Must run as user " + userForDir + ". We are " + AssertTool.currentUser());
            }
        } else {
            return AssertTool.exitOrException("Directory " + directory + " does not exist.");
        }
        return 0;
    }

    public static int assertFileExists(String directory) throws Exception {
        if (!Files.exists(Paths.get(directory, new String[0]), new LinkOption[0])) {
            return AssertTool.exitOrException("Directory " + directory + " does not exist.");
        }
        return 0;
    }

    public static int assertFileNotExists(String directory) throws Exception {
        if (Files.exists(Paths.get(directory, new String[0]), new LinkOption[0])) {
            return AssertTool.exitOrException("Directory " + directory + " should not exist.");
        }
        return 0;
    }

    public static int assertRootUser() throws Exception {
        if (!AssertTool.currentUser().equals("root")) {
            return AssertTool.exitOrException("Must run as root user");
        }
        return 0;
    }

    public static int assertNotRootUser() throws Exception {
        if (AssertTool.currentUser().equals("root")) {
            return AssertTool.exitOrException("Not allowed to run as root user");
        }
        return 0;
    }

    public static String currentUser() {
        return System.getProperty("user.name");
    }

    public static String userForDir(Path pathToDir) {
        try {
            FileOwnerAttributeView ownerAttributeView = Files.getFileAttributeView(pathToDir, FileOwnerAttributeView.class, new LinkOption[0]);
            return ownerAttributeView.getOwner().getName();
        }
        catch (IOException e) {
            return "N/A";
        }
    }

    private static int exitOrException(String msg) throws SolrCLI.AssertionFailureException {
        if (useExitCode) {
            return 1;
        }
        throw new SolrCLI.AssertionFailureException(message != null ? message : msg);
    }

    private static boolean isSolrRunningOn(String url) throws Exception {
        StatusTool status = new StatusTool();
        try {
            status.waitToSeeSolrUp(url, timeoutMs, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (Exception se) {
            if (SolrCLI.exceptionIsAuthRelated(se)) {
                throw se;
            }
            return false;
        }
    }

    private static boolean runningSolrIsCloud(String url) throws Exception {
        boolean bl;
        block9: {
            Http2SolrClient client = new Http2SolrClient.Builder(url).build();
            try {
                CollectionAdminRequest.ClusterStatus request = new CollectionAdminRequest.ClusterStatus();
                CollectionAdminResponse response = (CollectionAdminResponse)request.process(client);
                bl = true;
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (SolrCLI.exceptionIsAuthRelated(e)) {
                        throw e;
                    }
                    return false;
                }
            }
            client.close();
        }
        return bl;
    }
}

