/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.CreateCollectionTool;
import org.apache.solr.cli.CreateCoreTool;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.common.util.NamedList;

public class CreateTool
extends ToolBase {
    public CreateTool() {
        this(CLIO.getOutStream());
    }

    public CreateTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public String getName() {
        return "create";
    }

    @Override
    public List<Option> getOptions() {
        return SolrCLI.CREATE_COLLECTION_OPTIONS;
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        Object solrUrl = cli.getOptionValue("solrUrl", SolrCLI.getDefaultSolrUrl());
        if (!((String)solrUrl).endsWith("/")) {
            solrUrl = (String)solrUrl + "/";
        }
        try (SolrClient solrClient = SolrCLI.getSolrClient((String)solrUrl);){
            NamedList<Object> systemInfo = solrClient.request(new GenericSolrRequest(SolrRequest.METHOD.GET, "/admin/info/system"));
            ToolBase tool = "solrcloud".equals(systemInfo.get("mode")) ? new CreateCollectionTool(this.stdout) : new CreateCoreTool(this.stdout);
            tool.runImpl(cli);
        }
    }
}

