/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.solr.client.solrj.io.stream.SolrStream;
import org.apache.solr.client.solrj.io.stream.TupleStreamParser;
import org.apache.solr.common.util.DataInputInputStream;
import org.apache.solr.common.util.FastInputStream;
import org.apache.solr.common.util.JavaBinCodec;

public class JavabinTupleStreamParser
extends JavaBinCodec
implements TupleStreamParser {
    private final InputStream is;
    final FastInputStream fis;
    private int arraySize = Integer.MAX_VALUE;
    private boolean onlyJsonTypes = false;
    int objectSize;
    private boolean atDocs;

    public JavabinTupleStreamParser(InputStream is, boolean onlyJsonTypes) throws IOException {
        this.onlyJsonTypes = onlyJsonTypes;
        this.is = is;
        this.fis = this.initRead(is);
    }

    private boolean readTillDocs() throws IOException {
        if (this.isObjectType(this.fis)) {
            Object k;
            if (this.tagByte == 12) {
                this.readVal(this.fis);
                this.tagByte = this.fis.readByte();
                this.arraySize = this.readSize(this.fis);
                return true;
            }
            for (int i = this.objectSize; i > 0 && (k = this.readVal(this.fis)) != END_OBJ; --i) {
                if ("docs".equals(k)) {
                    this.tagByte = this.fis.readByte();
                    if (this.tagByte == 14) {
                        return true;
                    }
                    if (this.tagByte >>> 5 == 0x7FFFFFC) {
                        this.arraySize = this.readSize(this.fis);
                        return true;
                    }
                    return false;
                }
                if ("error".equals(k)) {
                    this.handleError();
                    return true;
                }
                if (!this.readTillDocs()) continue;
                return true;
            }
        } else {
            this.readObject(this.fis);
            return false;
        }
        return false;
    }

    private boolean isObjectType(DataInputInputStream dis) throws IOException {
        this.tagByte = dis.readByte();
        if (this.tagByte >>> 5 == 0x7FFFFFD || this.tagByte >>> 5 == 0x7FFFFFE) {
            this.objectSize = this.readSize(dis);
            return true;
        }
        if (this.tagByte == 10) {
            this.objectSize = JavabinTupleStreamParser.readVInt(dis);
            return true;
        }
        if (this.tagByte == 17) {
            this.objectSize = Integer.MAX_VALUE;
            return true;
        }
        return this.tagByte == 12;
    }

    private Map<String, ?> readAsMap(DataInputInputStream dis) throws IOException {
        int sz = this.readSize(dis);
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (int i = 0; i < sz; ++i) {
            String name = (String)this.readVal(dis);
            Object val = this.readVal(dis);
            m.put(name, val);
        }
        return m;
    }

    private Map<?, ?> readSolrDocumentAsMap(DataInputInputStream dis) throws IOException {
        this.tagByte = dis.readByte();
        int size = this.readSize(dis);
        LinkedHashMap<String, Object> doc = new LinkedHashMap<String, Object>();
        for (int i = 0; i < size; ++i) {
            Object obj = this.readVal(dis);
            if (obj instanceof Map) {
                ArrayList<Object> l = (ArrayList<Object>)doc.get("_childDocuments_");
                if (l == null) {
                    l = new ArrayList<Object>();
                    doc.put("_childDocuments_", l);
                }
                l.add(obj);
                continue;
            }
            String fieldName = (String)obj;
            Object fieldVal = this.readVal(dis);
            doc.put(fieldName, fieldVal);
        }
        return doc;
    }

    @Override
    protected Object readObject(DataInputInputStream dis) throws IOException {
        if (this.tagByte == 11) {
            return this.readSolrDocumentAsMap(dis);
        }
        if (this.onlyJsonTypes) {
            switch (this.tagByte >>> 5) {
                case 2: {
                    int i = this.readSmallInt(dis);
                    return (long)i;
                }
                case 0x7FFFFFD: 
                case 0x7FFFFFE: {
                    return this.readAsMap(dis);
                }
            }
            switch (this.tagByte) {
                case 6: {
                    int i = dis.readInt();
                    return (long)i;
                }
                case 8: {
                    float v = dis.readFloat();
                    return (double)v;
                }
                case 3: {
                    byte b = dis.readByte();
                    return (long)b;
                }
                case 4: {
                    short s = dis.readShort();
                    return (long)s;
                }
                case 9: {
                    return Instant.ofEpochMilli(dis.readLong()).toString();
                }
            }
            return super.readObject(dis);
        }
        return super.readObject(dis);
    }

    @Override
    public Map<String, Object> next() throws IOException {
        if (!this.atDocs) {
            this.atDocs = true;
            if (!this.readTillDocs()) {
                this.arraySize = 0;
                return null;
            }
        }
        if (this.arraySize == 0) {
            return null;
        }
        Object o = this.readVal(this.fis);
        --this.arraySize;
        if (o == END_OBJ) {
            return null;
        }
        return (Map)o;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    private void handleError() throws IOException {
        this.tagByte = this.fis.readByte();
        Map<String, ?> error = this.readAsMap(this.fis);
        String msg = Optional.ofNullable(error.get("msg")).map(String::valueOf).orElse("Unknown Exception");
        throw new SolrStream.HandledException(msg);
    }
}

